/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fircm.business.helper;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fircm.business.factory.credit.CreditLevelSerivceFactory;
import kd.fi.fircm.enums.ModifySourceEnum;
import kd.fi.fircm.enums.ModifyTypeEnum;
import kd.fi.fircm.task.util.TaskParamControlUtil;
import kd.fi.fircm.utils.DateSpanUtils;
import kd.ssc.task.workflow.dto.CreditPointDTO;

public class CreditPlusAndMinusPointsHelper {
    private static final Log log = LogFactory.getLog(CreditPlusAndMinusPointsHelper.class);
    private static final String ALGO_KEY = CreditPlusAndMinusPointsHelper.class.getName();
    private static final String SYSTEM_TYPE = "fi-fircm-business";
    private static final String METADATA_NUMBER_CREDIT_PARAMETER = "fircm_creditarg";
    private static final String METADATA_NUMBER_CREDIT_LEVEL = "task_creditlevel";
    private static final String METADATA_NUMBER_CREDIT_RECORD = "task_creditfiles";
    private static final String METADATA_NUMBER_CREDIT_RULE_COMMON = "task_credit_commonrule";
    private static final String METADATA_NUMBER_CREDIT_SCORE_LIMIT = "task_creditscorelimit";
    private static final String METADATA_NUMBER_CREDIT_LOG_MODIFY = "task_creditmodifylog";
    private static final String METADATA_NUMBER_CREDIT_IMAGE = "task_creditbyimagenew";
    public static final int TYPE_PLUS_POINTS_DIRECT = 0;
    public static final int TYPE_PLUS_POINTS_CONDITION = 1;
    public static final int TYPE_MINUS_POINTS_IMAGE = 2;
    public static final int TYPE_PLUS_POINTS_APPEAL = 3;

    public static List<String> getCreditParameterCols() {
        Map creditParameterMap = BusinessDataServiceHelper.loadFromCache((String)METADATA_NUMBER_CREDIT_PARAMETER, (String)"bizbill.number", (QFilter[])new QFilter[]{CreditPlusAndMinusPointsHelper.getCommonFilter(), CreditPlusAndMinusPointsHelper.getEnableFilter()});
        return creditParameterMap.values().stream().map(dy -> dy.getString("bizbill.number")).collect(Collectors.toList());
    }

    public static boolean validateCreditParameter(String number) {
        return CreditPlusAndMinusPointsHelper.getCreditParameterCols().contains(number);
    }

    public static boolean isEmptyOfCreditRecord(DynamicObject record) {
        boolean res = false;
        if (record == null || record.getLong("id") == 0L || StringUtils.isEmpty((String)record.getString("creditlevel.name"))) {
            res = true;
        }
        return res;
    }

    public static DynamicObject getCreditBonusPointOfSingleBill() {
        return QueryServiceHelper.queryOne((String)METADATA_NUMBER_CREDIT_SCORE_LIMIT, (String)"addscoreper", (QFilter[])new QFilter[]{CreditPlusAndMinusPointsHelper.getCommonFilter(), CreditPlusAndMinusPointsHelper.getEnableFilter()});
    }

    public static void updateCreditModifyLog(DynamicObject dy, DynamicObject rule, CreditPointDTO dto, int type) {
        log.info(String.format("start to call updateCreditModifyLog, creditRecord:%s, creditRule:%s", dy, rule));
        DynamicObject modifyLog = CreditPlusAndMinusPointsHelper.createModifyLog(dy, rule, type);
        modifyLog.set("billentity", (Object)dto.getBillNumber());
        modifyLog.set("billid", (Object)dto.getBillId());
        if (StringUtils.isNotEmpty((String)dto.getBillNo())) {
            modifyLog.set("billno", (Object)dto.getBillNo());
        }
        OperationServiceHelper.executeOperate((String)"save", (String)METADATA_NUMBER_CREDIT_LOG_MODIFY, (DynamicObject[])new DynamicObject[]{modifyLog}, null);
        log.info(String.format("call updateCreditModifyLog is successful, creditModifyLog:%s", modifyLog));
    }

    private static boolean needToExecuteCreditTask() {
        boolean beExcuted = false;
        AppParam param = new AppParam("1ZH12M=M8H7O", "15", Long.valueOf(OrgUnitServiceHelper.getRootOrgId()), Long.valueOf(0L));
        String dateForm = (String)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param, (String)"creditexcuterecord");
        if (StringUtils.isEmpty((String)dateForm)) {
            log.error("system parameter \"creditexcuterecord\" not exist or is empty");
            return CreditPlusAndMinusPointsHelper.queryExcuteRecordFromTask();
        }
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM");
            Date dateRecord = dateFormat.parse(dateForm);
            beExcuted = CreditPlusAndMinusPointsHelper.compareWithToday(dateRecord);
        }
        catch (ParseException e) {
            log.error("system parameter \"creditexcuterecord\" parse error", (Throwable)e);
            return true;
        }
        return beExcuted;
    }

    private static boolean queryExcuteRecordFromTask() {
        boolean beExcuted = false;
        String creditExcuteRecord = TaskParamControlUtil.querySscParam((String)"creditExcuteRecord");
        if (StringUtils.isEmpty((String)creditExcuteRecord)) {
            log.error("task parameter \"creditexcuterecord\" not exist or is empty");
            return true;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM");
        try {
            Date dateRecord = dateFormat.parse(creditExcuteRecord);
            beExcuted = CreditPlusAndMinusPointsHelper.compareWithToday(dateRecord);
        }
        catch (ParseException e) {
            log.error("task parameter \"creditexcuterecord\" parse error", (Throwable)e);
            return true;
        }
        return beExcuted;
    }

    private static boolean compareWithToday(Date otherDay) {
        Calendar todayCalendar = Calendar.getInstance();
        Calendar hisCalendar = Calendar.getInstance();
        hisCalendar.setTime(otherDay);
        if (todayCalendar.get(1) > hisCalendar.get(1)) {
            return true;
        }
        return todayCalendar.get(1) == hisCalendar.get(1) && todayCalendar.get(2) > hisCalendar.get(2);
    }

    public static void updateParamControl() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM");
        String dateStr = dateFormat.format(new Date());
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("creditexcuterecord", dateStr);
        SystemParamServiceHelper.saveAppParameter((String)"1ZH12M=M8H7O", (String)"15", (Long)OrgUnitServiceHelper.getRootOrgId(), (Long)0L, params);
    }

    public static void analysisCreditModifyLog() {
        CreditPlusAndMinusPointsHelper.analysisCreditModifyLog(null);
    }

    public static void analysisCreditModifyLog(Long userId) {
        log.info("CreditPlusAndMinusPointsHelper start the scheduled task of credit");
        boolean isNeedExecute = CreditPlusAndMinusPointsHelper.needToExecuteCreditTask();
        if (!isNeedExecute) {
            return;
        }
        List<DynamicObject> commonRules = CreditPlusAndMinusPointsHelper.getCreditRuleForCommon();
        log.info("The common credit rule is, " + commonRules);
        if (commonRules.isEmpty()) {
            log.error("The common credit rule is empty");
            return;
        }
        ArrayList<DynamicObject> creditRecordList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> modifyLogList = new ArrayList<DynamicObject>(10);
        QFilter statusFilter = new QFilter("modifysource", "in", (Object)new String[]{ModifySourceEnum.AUDIT.getValue(), ModifySourceEnum.OVERDUE_IMAGE.getValue(), ModifySourceEnum.SSC_QUALITY_TASK.getValue()});
        if (userId != null) {
            statusFilter = statusFilter.and(new QFilter("raiser.id", "=", (Object)userId));
        }
        Map<Long, DynamicObject> modifyLogMap = CreditPlusAndMinusPointsHelper.processModifyLogData(commonRules, statusFilter);
        log.info("call processModifyLogData success, result:" + modifyLogMap);
        CreditPlusAndMinusPointsHelper.fillCreditData(creditRecordList, modifyLogList, modifyLogMap);
        log.info("the credit record data to be updated ," + creditRecordList);
        log.info("the credit modify data to be inserted ," + modifyLogList);
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                SaveServiceHelper.update((DynamicObject[])creditRecordList.toArray(new DynamicObject[0]));
                OperationServiceHelper.executeOperate((String)"save", (String)METADATA_NUMBER_CREDIT_LOG_MODIFY, (DynamicObject[])modifyLogList.toArray(new DynamicObject[0]), null);
                CreditPlusAndMinusPointsHelper.updateParamControl();
            }
            catch (Exception e) {
                txHandle.markRollback();
                throw new KDException(new ErrorCode("TXException", e.getMessage()), new Object[0]);
            }
        }
        catch (Exception e) {
            log.error(String.format("analysisCreditModifyLog occur an error, msg:{%s}", e.getMessage()));
        }
    }

    private static List<DynamicObject> getCreditRuleForCommon() {
        String fields = "correctmonth,approvenum,addscore,levelstart,levelend,flag,enable";
        Map result = BusinessDataServiceHelper.loadFromCache((String)METADATA_NUMBER_CREDIT_RULE_COMMON, (String)fields, (QFilter[])new QFilter[]{CreditPlusAndMinusPointsHelper.getEnableFilter(), CreditPlusAndMinusPointsHelper.getCommonFilter()});
        return result.values().stream().sorted(Comparator.comparing(dy -> ((DynamicObject)dy).getInt("correctmonth")).thenComparing(dy -> ((DynamicObject)dy).getInt("approvenum"))).collect(Collectors.toList());
    }

    private static void fillCreditData(List<DynamicObject> creditRecordList, List<DynamicObject> modifyLogList, Map<Long, DynamicObject> modifyLogMap) {
        Map<String, Integer> creditLevelPoints = CreditPlusAndMinusPointsHelper.getCreditLevelPoints();
        for (Map.Entry<Long, DynamicObject> entry : modifyLogMap.entrySet()) {
            Long id = entry.getKey();
            DynamicObject rule = entry.getValue();
            DynamicObject creditRecord = CreditPlusAndMinusPointsHelper.processCreditRecordData(rule, id, creditLevelPoints);
            if (creditRecord == null) continue;
            DynamicObject modifyLog = CreditPlusAndMinusPointsHelper.createModifyLog(creditRecord, rule, 1);
            creditRecordList.add(creditRecord);
            modifyLogList.add(modifyLog);
        }
    }

    private static Map<Long, DynamicObject> processModifyLogData(List<DynamicObject> commonRules, QFilter statusFilter) {
        String selectFields = "id,raiser,changedscore,modifydate,modifytype,taskid,billid";
        HashMap<Long, DynamicObject> result = new HashMap<Long, DynamicObject>();
        LocalDate now = LocalDate.now().with(TemporalAdjusters.firstDayOfMonth());
        DynamicObject conditionRule = commonRules.get(commonRules.size() - 1);
        LocalDate start = now.minusMonths(conditionRule.getInt("correctmonth"));
        QFilter timeFilter = DateSpanUtils.timeSection((String)"modifydate", (LocalDate)start, (LocalDate)now);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)METADATA_NUMBER_CREDIT_LOG_MODIFY, (String)selectFields, (QFilter[])new QFilter[]{statusFilter, timeFilter, CreditPlusAndMinusPointsHelper.getCommonFilter()}, null);
        for (int i = 0; i < commonRules.size(); ++i) {
            DynamicObject rule = commonRules.get(i);
            int correctMonth = rule.getInt("correctmonth");
            LocalDate startDate = now.minusMonths(correctMonth);
            DataSet rows = DateSpanUtils.filterDataSet((DataSet)dataSet.copy(), (String)"modifydate", (LocalDate)startDate, (LocalDate)now);
            DataSet filterRows = rows.copy().filter("modifytype in ('2','4')").select("raiser").distinct();
            Set ids = StreamSupport.stream(Spliterators.spliteratorUnknownSize(filterRows, 4), false).map(row -> row.getLong("raiser")).collect(Collectors.toSet());
            Map<Long, DynamicObject> map = StreamSupport.stream(Spliterators.spliteratorUnknownSize(rows, 4), false).filter(row -> !ids.contains(row.getLong("raiser"))).filter(row -> row.getLong("taskid") != 0L || StringUtils.isNotEmpty((String)row.getString("billid"))).collect(Collectors.groupingBy(dy -> dy.getLong("raiser"), Collectors.collectingAndThen(Collectors.toList(), data -> CreditPlusAndMinusPointsHelper.validRules(rule, data))));
            for (Map.Entry<Long, DynamicObject> entry : map.entrySet()) {
                DynamicObject val = entry.getValue();
                if (val == null) continue;
                result.put(entry.getKey(), val);
            }
        }
        return result;
    }

    private static DynamicObject validRules(DynamicObject rule, List<Row> rows) {
        LocalDate endDate = LocalDate.now().withDayOfMonth(1);
        int correctMonth = rule.getInt("correctmonth");
        int approveNum = rule.getInt("approvenum");
        LocalDate startDate = endDate.minusMonths(correctMonth);
        long count = rows.stream().filter(row -> row.getDate("modifydate").toInstant().atZone(ZoneId.systemDefault()).toLocalDate().isAfter(startDate) && row.getDate("modifydate").toInstant().atZone(ZoneId.systemDefault()).toLocalDate().isBefore(endDate)).count();
        if ((long)approveNum <= count) {
            return rule;
        }
        return null;
    }

    public static DynamicObject createModifyLog(DynamicObject newCreditRecord, DynamicObject rule, int type) {
        long userId = newCreditRecord.getLong("user.id");
        DynamicObject modifyLog = BusinessDataServiceHelper.newDynamicObject((String)METADATA_NUMBER_CREDIT_LOG_MODIFY);
        Long orgID = UserServiceHelper.getUserMainOrgId((long)userId);
        Long companyId = (Long)OrgServiceHelper.getCompanyfromOrg((Object)orgID).get("id");
        DynamicObject oldCreditRecord = CreditPlusAndMinusPointsHelper.getCreditRecordByUserId(userId);
        BigDecimal oldScore = oldCreditRecord.getBigDecimal("creditvalue").setScale(1, 4);
        BigDecimal newScore = newCreditRecord.getBigDecimal("creditvalue").setScale(1, 4);
        String odlCreditLevel = oldCreditRecord.getString("creditlevel.name");
        String newCreditLevel = newCreditRecord.getString("creditlevel.name");
        BigDecimal changedScore = new BigDecimal(0);
        if (newScore != null) {
            changedScore = newScore.subtract(oldScore);
        }
        String logModifySource = CreditPlusAndMinusPointsHelper.getLogModifySource(type);
        String logModifyType = CreditPlusAndMinusPointsHelper.getLogModifyType(newCreditRecord, oldCreditRecord, newScore, oldScore);
        String logDescription = CreditPlusAndMinusPointsHelper.buildLogDescription(type, logModifyType, rule, odlCreditLevel, newCreditLevel, oldScore, newScore, changedScore);
        modifyLog.set("raiser", (Object)userId);
        modifyLog.set("dept", (Object)orgID);
        modifyLog.set("company", (Object)companyId);
        modifyLog.set("modifytype", (Object)logModifyType);
        modifyLog.set("modifysource", (Object)logModifySource);
        modifyLog.set("oldlevel", (Object)odlCreditLevel);
        modifyLog.set("newlevel", (Object)newCreditLevel);
        modifyLog.set("oldgrade", (Object)oldScore);
        modifyLog.set("newgrade", (Object)newScore);
        modifyLog.set("changedscore", (Object)changedScore);
        modifyLog.set("description", (Object)logDescription);
        modifyLog.set("modifydate", (Object)new Date());
        modifyLog.set("enable", (Object)"1");
        modifyLog.set("status", (Object)"C");
        return modifyLog;
    }

    private static String buildLogDescription(int type, String logModifyType, DynamicObject rule, String odlCreditLevel, String newCreditLevel, BigDecimal oldScore, BigDecimal newScore, BigDecimal changedScore) {
        StringBuilder sb = new StringBuilder(50);
        switch (type) {
            case 1: {
                int correctMonth = rule.getInt("correctmonth");
                if (ModifyTypeEnum.UP_GRADE.getValue().equals(logModifyType)) {
                    sb.append(String.format(ResManager.loadKDString((String)"\u8fde\u7eed%1$s\u4e2a\u6708\u65e0\u5dee\u9519\uff0c\u4fe1\u7528\u7b49\u7ea7\u4ece%2$s\u5347\u81f3%3$s\uff0c\u4fe1\u7528\u5206\u6570\u52a0%4$s", (String)"CreditPlusAndMinusPointsHelper_13", (String)SYSTEM_TYPE, (Object[])new Object[0]), correctMonth, odlCreditLevel, newCreditLevel, changedScore));
                    break;
                }
                sb.append(String.format(ResManager.loadKDString((String)"\u8fde\u7eed%1$s\u4e2a\u6708\u65e0\u5dee\u9519\uff0c\u4fe1\u7528\u5206\u6570\u52a0%2$s", (String)"CreditPlusAndMinusPointsHelper_5", (String)SYSTEM_TYPE, (Object[])new Object[0]), correctMonth, changedScore));
                break;
            }
            case 0: {
                if (ModifyTypeEnum.UP_GRADE.getValue().equals(logModifyType)) {
                    sb.append(String.format(ResManager.loadKDString((String)"\u5355\u636e\u5ba1\u6279\u901a\u8fc7\uff0c\u4fe1\u7528\u7b49\u7ea7\u4ece%1$s\u5347\u81f3%2$s\uff0c\u4fe1\u7528\u5206\u4ece%3$s\u63d0\u5347\u5230%4$s", (String)"CreditPlusAndMinusPointsHelper_2", (String)SYSTEM_TYPE, (Object[])new Object[0]), odlCreditLevel, newCreditLevel, oldScore, newScore));
                    break;
                }
                sb.append(String.format(ResManager.loadKDString((String)"\u5355\u636e\u5ba1\u6279\u901a\u8fc7\uff0c\u4fe1\u7528\u5206\u4ece%1$s\u63d0\u5347\u5230%2$s", (String)"CreditPlusAndMinusPointsHelper_14", (String)SYSTEM_TYPE, (Object[])new Object[0]), oldScore, newScore));
                break;
            }
            case 2: {
                int date = rule.getInt("outdatenum");
                BigDecimal subscore = rule.getBigDecimal("subscore").setScale(1, 4);
                if (ModifyTypeEnum.DOWN_GRADE.getValue().equals(logModifyType)) {
                    sb.append(String.format(ResManager.loadKDString((String)"\u8d85\u8fc7%1$s\u5929\u672a\u4e0a\u4f20\u5f71\u50cf\uff0c\u4fe1\u7528\u7b49\u7ea7\u4ece%2$s\u964d\u81f3%3$s\uff0c\u4fe1\u7528\u5206\u6570\u6263%4$s\u5206", (String)"CreditPlusAndMinusPointsHelper_3", (String)SYSTEM_TYPE, (Object[])new Object[0]), date, odlCreditLevel, newCreditLevel, subscore));
                    break;
                }
                sb.append(String.format(ResManager.loadKDString((String)"\u8d85\u8fc7%1$s\u5929\u672a\u4e0a\u4f20\u5f71\u50cf\uff0c\u4fe1\u7528\u5206\u6570\u6263%2$s\u5206", (String)"CreditPlusAndMinusPointsHelper_15", (String)SYSTEM_TYPE, (Object[])new Object[0]), date, subscore));
            }
        }
        return sb.toString();
    }

    private static String getLogModifySource(int type) {
        switch (type) {
            case 0: 
            case 1: {
                return ModifySourceEnum.AUDIT.getValue();
            }
            case 2: {
                return ModifySourceEnum.OVERDUE_IMAGE.getValue();
            }
            case 3: {
                return ModifySourceEnum.CREDIT_APPEAL.getValue();
            }
        }
        return "";
    }

    private static String getLogModifyType(DynamicObject newCreditRecord, DynamicObject oldCreditRecord, BigDecimal newScore, BigDecimal oldScore) {
        if (newCreditRecord == null || oldCreditRecord == null || newScore == null || oldScore == null) {
            return "";
        }
        Long newLevelId = newCreditRecord.getLong("creditlevel.id");
        Long oldLevelId = oldCreditRecord.getLong("creditlevel.id");
        if (newScore.compareTo(oldScore) < 0) {
            return newLevelId.compareTo(oldLevelId) == 0 ? ModifyTypeEnum.MINUS_POINTS.getValue() : ModifyTypeEnum.DOWN_GRADE.getValue();
        }
        if (newScore.compareTo(oldScore) > 0) {
            return newLevelId.compareTo(oldLevelId) == 0 ? ModifyTypeEnum.PLUS_POINTS.getValue() : ModifyTypeEnum.UP_GRADE.getValue();
        }
        return ModifyTypeEnum.PLUS_POINTS.getValue();
    }

    private static DynamicObject processCreditRecordData(DynamicObject rule, Long userId, Map<String, Integer> creditLevelPoints) {
        boolean flag = rule.getBoolean("flag");
        BigDecimal score = rule.getBigDecimal("addscore");
        DynamicObject creditRecord = CreditPlusAndMinusPointsHelper.getCreditRecordByUserId(userId);
        if (CreditPlusAndMinusPointsHelper.isEmptyOfCreditRecord(creditRecord)) {
            log.error("credit record does not exist, userId:" + userId);
            return null;
        }
        BigDecimal creditValue = creditRecord.getBigDecimal("creditvalue");
        creditRecord.set("bonuspointnum", (Object)creditRecord.getBigDecimal("bonuspointnum").add(BigDecimal.ONE));
        if (!flag) {
            CreditPlusAndMinusPointsHelper.directPlusPoints(score, creditRecord, creditLevelPoints, 1);
        } else {
            BigDecimal minValue = rule.getBigDecimal("levelstart.minvalue");
            BigDecimal maxValue = rule.getBigDecimal("levelend.maxvalue");
            if (creditValue.compareTo(minValue) >= 0 && creditValue.compareTo(maxValue) < 0) {
                creditRecord.set("creditlevel", (Object)rule.getDynamicObject("levelend"));
                creditRecord.set("creditvalue", (Object)rule.getBigDecimal("levelend.defaultvalue"));
            }
            creditRecord.set("bonuspointnum", (Object)creditRecord.getBigDecimal("bonuspointnum").add(BigDecimal.ONE));
        }
        return creditRecord;
    }

    private static void directPlusPoints(BigDecimal score, DynamicObject creditRecord, Map<String, Integer> creditLevelPoints, int type) {
        BigDecimal creditValue = creditRecord.getBigDecimal("creditvalue");
        BigDecimal score_ = CreditPlusAndMinusPointsHelper.addCreditValue(score, creditValue, creditLevelPoints);
        DynamicObject creditLevel = CreditPlusAndMinusPointsHelper.getCreditLevelByScore(score_);
        creditRecord.set("creditvalue", (Object)score_);
        if (type == 0 || type == 1) {
            creditRecord.set("bonuspointnum", (Object)creditRecord.getBigDecimal("bonuspointnum").add(BigDecimal.ONE));
        } else if (type == 2) {
            creditRecord.set("unqualifiedtotalnum", (Object)creditRecord.getBigDecimal("unqualifiedtotalnum").add(BigDecimal.ONE));
        }
        if (creditLevel != null) {
            creditRecord.set("creditlevel", (Object)creditLevel);
        }
    }

    private static BigDecimal addCreditValue(BigDecimal score, BigDecimal creditValue, Map<String, Integer> creditLevelPoints) {
        BigDecimal score_ = creditValue.add(score);
        Integer max = creditLevelPoints.get("max");
        Integer min = creditLevelPoints.get("min");
        if (score_.compareTo(new BigDecimal(max)) > 0) {
            score_ = new BigDecimal(max);
        } else if (score_.compareTo(new BigDecimal(min)) < 0) {
            score_ = new BigDecimal(min);
        }
        return score_;
    }

    public static DynamicObject getCreditRecordByUserId(Long userId) {
        return BusinessDataServiceHelper.loadSingle((String)METADATA_NUMBER_CREDIT_RECORD, (String)"id,creditlevel,creditvalue,bonuspointnum,unqualifiedtotalnum,user.id,modifytime", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)userId), CreditPlusAndMinusPointsHelper.getEnableFilter(), CreditPlusAndMinusPointsHelper.getCommonFilter()});
    }

    public static DynamicObject getCreditLevelByScore(BigDecimal score) {
        Map creditLevelMap = BusinessDataServiceHelper.loadFromCache((String)METADATA_NUMBER_CREDIT_LEVEL, (String)"id,number,minvalue,maxvalue,defaultvalue", (QFilter[])new QFilter[]{CreditPlusAndMinusPointsHelper.getEnableFilter(), CreditPlusAndMinusPointsHelper.getCommonFilter()});
        return creditLevelMap.values().stream().filter(dy -> score.compareTo(dy.getBigDecimal("defaultvalue")) == 0 || score.compareTo(dy.getBigDecimal("minvalue")) >= 0 && score.compareTo(dy.getBigDecimal("maxvalue")) < 0).findFirst().orElse(null);
    }

    private static QFilter getCommonFilter() {
        return new QFilter("status", "!=", (Object)Character.valueOf('D'));
    }

    private static QFilter getEnableFilter() {
        return new QFilter("enable", "=", (Object)Character.valueOf('1'));
    }

    public static boolean processCommonValidation(CreditPointDTO dto) {
        String billNumber = dto.getBillNumber();
        if (!CreditPlusAndMinusPointsHelper.validateCreditParameter(billNumber)) {
            log.error(ResManager.loadKDString((String)String.format("\u4fe1\u7528\u53c2\u6570\u8fc7\u6ee4\u672a\u901a\u8fc7\uff0c\u8bf7\u5148\u4e3a%1$s\u8fdb\u884c\u914d\u7f6e", billNumber), (String)"CreditPlusAndMinusPointsHelper_4", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        if (dto.getUserId() == 0L) {
            log.error("parameter verification failed, param:" + dto);
            return false;
        }
        return true;
    }

    public static void updateCreditPoints(String creditPointDTOStr) {
        CreditPlusAndMinusPointsHelper.updateCreditPoints(creditPointDTOStr, 0, 0);
    }

    public static void creditAppealPoints(Map<String, Object> param) {
        Long userId = (Long)param.get("userid");
        DynamicObject creditRecord = CreditPlusAndMinusPointsHelper.getCreditRecordByUserId(userId);
        if (CreditPlusAndMinusPointsHelper.isEmptyOfCreditRecord(creditRecord)) {
            log.error("the credit record cannot be empty, userId:" + userId);
            return;
        }
        BigDecimal score = (BigDecimal)param.get("auditscore");
        score = score.setScale(1);
        BigDecimal applyAddScore = (BigDecimal)param.get("applyscore");
        applyAddScore = applyAddScore.setScale(1);
        Map<String, Integer> creditLevelPoints = CreditPlusAndMinusPointsHelper.getCreditLevelPoints();
        BigDecimal currCreditValue = creditRecord.getBigDecimal("creditvalue");
        DynamicObject currCreditLevel = CreditPlusAndMinusPointsHelper.getCreditLevelByScore(currCreditValue);
        BigDecimal afterAddCreditValue = CreditPlusAndMinusPointsHelper.addCreditValue(score, currCreditValue, creditLevelPoints);
        DynamicObject afterAddCreditLevel = CreditPlusAndMinusPointsHelper.getCreditLevelByScore(afterAddCreditValue);
        creditRecord.set("bonuspointnum", (Object)creditRecord.getBigDecimal("bonuspointnum").add(BigDecimal.ONE));
        creditRecord.set("creditvalue", (Object)afterAddCreditValue);
        if (afterAddCreditLevel != null) {
            creditRecord.set("creditlevel", (Object)afterAddCreditLevel);
        }
        DynamicObject modifyLog = CreditPlusAndMinusPointsHelper.createModifyLog(creditRecord, null, 3);
        StringBuilder sb = new StringBuilder();
        if (ModifyTypeEnum.UP_GRADE.getValue().equals(modifyLog.getString("modifytype"))) {
            String afterAddCreditLevelName = "";
            if (afterAddCreditLevel != null) {
                afterAddCreditLevelName = afterAddCreditLevel.getString("name");
            }
            sb.append(String.format(ResManager.loadKDString((String)"\u4fe1\u7528\u7533\u8bc9\u52a0%1$s\u5206\uff0c\u6838\u5b9a\u52a0%2$s\u5206\uff0c\u4fe1\u7528\u5206\u4ece%3$s\u63d0\u5347\u5230%4$s\uff0c\u4fe1\u7528\u7b49\u7ea7\u4ece%5$s\u5347\u81f3%6$s", (String)"CreditPlusAndMinusPointsHelper_6", (String)SYSTEM_TYPE, (Object[])new Object[0]), applyAddScore, score, currCreditValue, afterAddCreditValue, currCreditLevel.getString("name"), afterAddCreditLevelName));
        } else {
            sb.append(String.format(ResManager.loadKDString((String)"\u4fe1\u7528\u7533\u8bc9\u52a0%1$s\u5206\uff0c\u6838\u5b9a\u52a0%2$s\u5206\uff0c\u4fe1\u7528\u5206\u4ece%3$s\u63d0\u5347\u5230%4$s", (String)"CreditPlusAndMinusPointsHelper_12", (String)SYSTEM_TYPE, (Object[])new Object[0]), applyAddScore, score, currCreditValue, afterAddCreditValue));
        }
        modifyLog.set("description", (Object)sb.toString());
        modifyLog.set("billentity", param.get("billentity"));
        modifyLog.set("billid", param.get("billid"));
        modifyLog.set("billno", param.get("billno"));
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                OperationServiceHelper.executeOperate((String)"save", (String)METADATA_NUMBER_CREDIT_LOG_MODIFY, (DynamicObject[])new DynamicObject[]{modifyLog}, null);
                log.info(String.format("call updateCreditModifyLog is successful, creditModifyLog:%s", modifyLog));
                SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{creditRecord});
            }
            catch (Exception e) {
                txHandle.markRollback();
                throw new KDException(new ErrorCode("TXException", e.getMessage()), new Object[0]);
            }
        }
        catch (Exception e) {
            log.error(String.format("updateCreditPoints occur an error, parameter:{%s}, msg:{%s}", param, e.getMessage()));
        }
    }

    public static void minusCreditPoints(String creditPointDTOStr, int offset) {
        CreditPlusAndMinusPointsHelper.updateCreditPoints(creditPointDTOStr, 2, offset);
    }

    public static void minusCreditPoints(Map<String, String> param, int offset) {
        String billId = param.get("billId");
        String billNumber = param.get("billNumber");
        String billNo = param.get("billNo");
        long userId = Long.parseLong(param.get("userId"));
        if (StringUtils.isBlank((String)billId) || StringUtils.isBlank((String)billNumber) || StringUtils.isBlank((String)billNo) || userId == 0L) {
            log.error("minusCreditPoints parameter verification failed, param:" + param);
            return;
        }
        CreditPointDTO dto = new CreditPointDTO(billId, billNumber, billNo, userId);
        String creditPointDTOStr = SerializationUtils.toJsonString((Object)dto);
        CreditPlusAndMinusPointsHelper.updateCreditPoints(creditPointDTOStr, 2, offset);
    }

    public static void updateCreditPoints(String creditPointDTOStr, int type, int offset) {
        CreditPointDTO dto = (CreditPointDTO)SerializationUtils.fromJsonString((String)creditPointDTOStr, CreditPointDTO.class);
        log.info("the parameter before updateCreditPoints, " + dto);
        if (type == 2 && offset <= 0 || dto == null) {
            log.error(String.format("the parameter verification failure, dto:{%s}, offset:{%s}", dto, offset));
            return;
        }
        if (CreditPlusAndMinusPointsHelper.validMinusPoints(dto, type)) {
            return;
        }
        if (!CreditPlusAndMinusPointsHelper.processCommonValidation(dto)) {
            return;
        }
        DynamicObject creditRecord = CreditPlusAndMinusPointsHelper.getCreditRecordByUserId(dto.getUserId());
        if (CreditPlusAndMinusPointsHelper.isEmptyOfCreditRecord(creditRecord)) {
            log.error("the credit record cannot be empty, dto:" + dto);
            return;
        }
        DynamicObject rule = CreditPlusAndMinusPointsHelper.processRuleUpdated(type, offset);
        if (rule == null) {
            String msg = CreditPlusAndMinusPointsHelper.isPlusCreditPoints(type) ? ResManager.loadKDString((String)"\u6309\u5355\u76f4\u63a5\u52a0\u5206\u89c4\u5219\u4e3a\u7a7a", (String)"CreditPlusAndMinusPointsHelper_0", (String)SYSTEM_TYPE, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5f71\u50cf\u6263\u5206\u89c4\u5219\u4e3a\u7a7a", (String)"CreditPlusAndMinusPointsHelper_1", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            log.error(msg);
            return;
        }
        BigDecimal score = CreditPlusAndMinusPointsHelper.processScoreUpdated(type, rule);
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                CreditPlusAndMinusPointsHelper.directPlusPoints(score, creditRecord, CreditPlusAndMinusPointsHelper.getCreditLevelPoints(), type);
                CreditPlusAndMinusPointsHelper.updateCreditModifyLog(creditRecord, rule, dto, type);
                SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{creditRecord});
            }
            catch (Exception e) {
                txHandle.markRollback();
                throw new KDException(new ErrorCode("TXException", e.getMessage()), new Object[0]);
            }
        }
        catch (Exception e) {
            log.error(String.format("updateCreditPoints occur an error, parameter:{%s}, msg:{%s}", dto, e.getMessage()), (Throwable)e);
        }
    }

    private static boolean validMinusPoints(CreditPointDTO dto, int type) {
        DynamicObjectCollection cols;
        long count;
        QFilter filter = new QFilter("billno", "=", (Object)dto.getBillNo()).and(new QFilter("billentity", "=", (Object)dto.getBillNumber())).and(new QFilter("raiser.id", "=", (Object)dto.getUserId()));
        if (type == 2) {
            filter.and(new QFilter("modifysource", "=", (Object)ModifySourceEnum.OVERDUE_IMAGE.getValue()));
        }
        if ((count = (cols = QueryServiceHelper.query((String)METADATA_NUMBER_CREDIT_LOG_MODIFY, (String)"modifytype", (QFilter[])new QFilter[]{filter})).stream().filter(dy -> ModifyTypeEnum.DOWN_GRADE.getValue().equals(dy.getString("modifytype")) || ModifyTypeEnum.MINUS_POINTS.getValue().equals(dy.getString("modifytype"))).count()) > 0L) {
            log.error("exist the record of points deducted, dto:" + dto);
            return true;
        }
        return false;
    }

    private static BigDecimal processScoreUpdated(int type, DynamicObject rule) {
        BigDecimal score = BigDecimal.ZERO;
        if (CreditPlusAndMinusPointsHelper.isPlusCreditPoints(type)) {
            score = rule.getBigDecimal("addscoreper");
        } else {
            if (rule == null) {
                return score;
            }
            score = rule.getBigDecimal("subscore").negate();
        }
        return score;
    }

    private static DynamicObject processRuleUpdated(int type, int offset) {
        DynamicObject rule;
        if (CreditPlusAndMinusPointsHelper.isPlusCreditPoints(type)) {
            rule = CreditPlusAndMinusPointsHelper.getCreditBonusPointOfSingleBill();
        } else {
            String fields = "outdatenum,subscore";
            QFilter businessFilter = new QFilter("outdatenum", "<=", (Object)offset);
            Map result = BusinessDataServiceHelper.loadFromCache((String)METADATA_NUMBER_CREDIT_IMAGE, (String)fields, (QFilter[])new QFilter[]{CreditPlusAndMinusPointsHelper.getEnableFilter(), businessFilter, CreditPlusAndMinusPointsHelper.getCommonFilter()}, (String)"outdatenum");
            if (result.isEmpty()) {
                return null;
            }
            ArrayList dys = new ArrayList(result.values());
            rule = (DynamicObject)dys.get(dys.size() - 1);
        }
        return rule;
    }

    private static boolean isPlusCreditPoints(int type) {
        boolean flag = false;
        if (type == 0 || type == 1) {
            flag = true;
        }
        return flag;
    }

    private static Map<String, Integer> getCreditLevelPoints() {
        return CreditLevelSerivceFactory.newInstance().getCreditScoreRange();
    }
}

