/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fircm.business.helper;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.IBaseDataService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fircm.business.factory.credit.CreditFilesServiceFactory;
import kd.fi.fircm.business.factory.credit.CreditLevelSerivceFactory;
import kd.fi.fircm.business.helper.CreditPlusAndMinusPointsHelper;
import kd.fi.fircm.business.helper.pojo.SubScoreRulePojo;
import kd.fi.fircm.business.service.credit.CreditFilesService;
import kd.fi.fircm.business.service.credit.CreditLevelSerivce;
import kd.fi.fircm.enums.ModifySourceEnum;
import kd.fi.fircm.enums.ModifyTypeEnum;
import kd.ssc.task.workflow.dto.CreditPointDTO;

public class CreditServiceHelper {
    private static final Log log = LogFactory.getLog(CreditServiceHelper.class);

    public static DynamicObject queryCreditFileByBillInfo(long userId) {
        CreditFilesService cfService = CreditFilesServiceFactory.newInstance();
        DynamicObject creditFile = cfService.getCreditFile(userId);
        if (creditFile == null) {
            CreditLevelSerivce clSerivce = CreditLevelSerivceFactory.newInstance();
            creditFile = cfService.initCreditFile(userId, clSerivce.getDefaultLevel());
        }
        return creditFile;
    }

    public static DynamicObject queryCreditLevelByUserId(Long userID) {
        String selectFields = "id, user, creditvalue, creditlevel, bonuspointnum, unqualifiedtotalnum";
        QFilter filter = new QFilter("user", "=", (Object)userID);
        QFilter statusFilter = new QFilter("status", "!=", (Object)Character.valueOf('D'));
        DynamicObject userArchive = BusinessDataServiceHelper.loadSingle((String)"task_creditfiles", (String)selectFields, (QFilter[])new QFilter[]{filter, statusFilter});
        if (userArchive == null) {
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)"task_creditfiles");
            DynamicObject obj = null;
            Map map = CreditServiceHelper.getCreditlevel();
            if (map == null) {
                log.info("\u6ca1\u6709\u914d\u7f6e\u4fe1\u7528\u7b49\u7ea7");
                return null;
            }
            Date date = new Date();
            obj = new DynamicObject((DynamicObjectType)type);
            obj.set("user", (Object)userID);
            obj.set("creditlevel", map.get("id"));
            obj.set("creditvalue", map.get("defaultvalue"));
            obj.set("enable", (Object)1);
            obj.set("status", (Object)"A");
            obj.set("createtime", (Object)date);
            obj.set("modifytime", (Object)date);
            Long mainOrgID = UserServiceHelper.getUserMainOrgId((long)userID);
            obj.set("dept", (Object)mainOrgID);
            obj.set("company", OrgServiceHelper.getCompanyfromOrg((Object)mainOrgID).get("id"));
            Object[] objs = null;
            try (TXHandle h = TX.required();){
                try {
                    objs = BusinessDataWriter.save((IDataEntityType)type, (Object[])new Object[]{obj});
                }
                catch (Exception e) {
                    h.markRollback();
                    log.error("\u4efb\u52a1\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
                }
            }
            if (objs != null) {
                return BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)objs[0]).getPkValue(), (String)"task_creditfiles");
            }
        }
        return userArchive;
    }

    private static Map getCreditlevel() {
        QFilter filter = new QFilter("defaultlevel", "=", (Object)Character.valueOf('1'));
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"task_creditlevel", (String)"id,defaultvalue", (QFilter[])filters);
        if (collection.size() == 0) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", ((DynamicObject)collection.get(0)).getString("id"));
        map.put("defaultvalue", ((DynamicObject)collection.get(0)).getString("defaultvalue"));
        return map;
    }

    public static void deductCreditPoints(List<Long> subScoreRuleIds, String modifySource, String creditPointDTOStr, String description) {
        log.info(String.format("deductCreditPoints, creditPointDTO:%s, subScoreRuleIds:%s", creditPointDTOStr, subScoreRuleIds));
        CreditPointDTO dto = (CreditPointDTO)SerializationUtils.fromJsonString((String)creditPointDTOStr, CreditPointDTO.class);
        if (!CreditPlusAndMinusPointsHelper.processCommonValidation(dto)) {
            log.error("bill not in fircm_creditarg");
            return;
        }
        DynamicObject[] subScoreRule = CreditServiceHelper.getSubScoreRuleByIds(subScoreRuleIds);
        if (subScoreRule == null || subScoreRule.length == 0) {
            log.error("subScoreRuleIds is empty");
            return;
        }
        List<DynamicObject> enableSubScoreRuleDynList = Arrays.stream(subScoreRule).filter(rule -> rule.getBoolean("enable")).collect(Collectors.toList());
        if (enableSubScoreRuleDynList.size() == 0) {
            CreditServiceHelper.insertCreditModLogOfZero(creditPointDTOStr, modifySource, description);
            return;
        }
        SubScoreRulePojo subScoreRuleInfo = CreditServiceHelper.getSubScoreRuleInfo(enableSubScoreRuleDynList);
        BigDecimal subScore = subScoreRuleInfo.getSubscore();
        DynamicObject subLevel = subScoreRuleInfo.getSubLevel();
        if (subLevel == null && subScore.compareTo(BigDecimal.ZERO) == 0) {
            CreditServiceHelper.insertCreditModLogOfZero(creditPointDTOStr, modifySource, description);
            return;
        }
        DynamicObject userArchive = CreditServiceHelper.getUserCreditFile(dto.getUserId());
        if (userArchive == null) {
            log.error("deductCreditPoints failed. defaultLevel is null");
            return;
        }
        BigDecimal curScore = userArchive.getBigDecimal("creditvalue");
        DynamicObject curLevel = userArchive.getDynamicObject("creditlevel");
        BigDecimal newScore = CreditServiceHelper.getNewScore(curScore, curLevel, subLevel, subScore);
        DynamicObject newLevel = CreditLevelSerivceFactory.newInstance().getCreditLevel(newScore);
        CreditServiceHelper.updateUserCreditFiles(userArchive, newScore, newLevel);
        List<String> subScoreRuleNameList = subScoreRuleInfo.getSubScoreRuleNames();
        String changeType = CreditServiceHelper.getChangeType(curLevel, newLevel);
        String logDescription = CreditServiceHelper.buildLogDescription(changeType, description, newLevel, curScore, newScore, subScoreRuleNameList);
        CreditServiceHelper.writeModifyLog(dto, changeType, modifySource, curLevel, newLevel, curScore, newScore, logDescription);
    }

    private static DynamicObject[] getSubScoreRuleByIds(List<Long> subScoreRuleIds) {
        String selFields = "flag,subscore,sublevel,name,enable";
        QFilter idFil = new QFilter("id", "in", subScoreRuleIds);
        DynamicObject[] subScoreRules = BusinessDataServiceHelper.load((String)"fircm_subscorerule", (String)selFields, (QFilter[])new QFilter[]{idFil});
        return subScoreRules;
    }

    private static BigDecimal getNewScore(BigDecimal curScore, DynamicObject curLevel, DynamicObject subLevel, BigDecimal subScore) {
        Map<String, Integer> scoreRange = CreditLevelSerivceFactory.newInstance().getCreditScoreRange();
        int min = scoreRange.get("min");
        BigDecimal newScore = null;
        if (subLevel != null && curLevel.getInt("maxvalue") > subLevel.getInt("maxvalue")) {
            newScore = subLevel.getBigDecimal("defaultvalue");
        }
        if (subScore.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal bigDecimal = newScore = newScore == null ? curScore.subtract(subScore) : newScore.subtract(subScore);
        }
        if (newScore == null) {
            return curScore;
        }
        if (newScore.compareTo(BigDecimal.valueOf(min)) < 0) {
            return BigDecimal.valueOf(min);
        }
        return newScore;
    }

    private static String getChangeType(DynamicObject curLevel, DynamicObject newLevel) {
        String changeType = ModifyTypeEnum.MINUS_POINTS.getValue();
        if (curLevel.getInt("maxvalue") > newLevel.getInt("maxvalue")) {
            changeType = ModifyTypeEnum.DOWN_GRADE.getValue();
        }
        return changeType;
    }

    private static String buildLogDescription(String changeType, String description, DynamicObject newLevel, BigDecimal curScore, BigDecimal newScore, List<String> subScoreRuleNameList) {
        String subScore = curScore.subtract(newScore).stripTrailingZeros().toPlainString();
        String subScoreRuleString = String.join((CharSequence)",", subScoreRuleNameList);
        if (ModifyTypeEnum.DOWN_GRADE.getValue().equals(changeType)) {
            return String.format(ResManager.loadKDString((String)"%1$s\uff0c\u6263\u5206\u9879\uff1a%2$s\uff0c\u4fe1\u7528\u7b49\u7ea7\u964d\u81f3%3$s\uff0c\u4fe1\u7528\u5206\u6570\u6263%4$s\u5206", (String)"CreditServiceHelper_0", (String)"fi-fircm-business", (Object[])new Object[0]), description, subScoreRuleString, newLevel.getString("name"), subScore);
        }
        return String.format(ResManager.loadKDString((String)"%1$s\uff0c\u6263\u5206\u9879\uff1a%2$s\uff0c\u4fe1\u7528\u5206\u6570\u6263%3$s\u5206", (String)"CreditServiceHelper_1", (String)"fi-fircm-business", (Object[])new Object[0]), description, subScoreRuleString, subScore);
    }

    private static void updateUserCreditFiles(DynamicObject userArchive, BigDecimal newScore, DynamicObject newLevel) {
        userArchive.set("creditvalue", (Object)newScore);
        userArchive.set("creditlevel", (Object)newLevel);
        int curUnqualTotalNum = userArchive.getInt("unqualifiedtotalnum");
        userArchive.set("unqualifiedtotalnum", (Object)(curUnqualTotalNum + 1));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{userArchive});
    }

    private static DynamicObject getUserCreditFile(long userId) {
        CreditFilesService filesService = CreditFilesServiceFactory.newInstance();
        DynamicObject userArchive = filesService.getCreditFile(userId);
        if (userArchive != null) {
            return userArchive;
        }
        DynamicObject defaultLevel = CreditLevelSerivceFactory.newInstance().getDefaultLevel();
        if (defaultLevel == null) {
            return null;
        }
        return filesService.initCreditFile(userId, defaultLevel);
    }

    private static SubScoreRulePojo getSubScoreRuleInfo(List<DynamicObject> enableSubScoreRule) {
        BigDecimal subScore = BigDecimal.ZERO;
        DynamicObject subLevel = null;
        ArrayList<String> subScoreRuleNames = new ArrayList<String>(10);
        for (DynamicObject subScoreRule : enableSubScoreRule) {
            if (subScoreRule.getBoolean("flag")) {
                DynamicObject level = subScoreRule.getDynamicObject("sublevel");
                if (subLevel == null) {
                    subLevel = level;
                } else if (subLevel.getInt("maxvalue") > level.getInt("maxvalue")) {
                    subLevel = level;
                }
            } else {
                subScore = subScore.add(subScoreRule.getBigDecimal("subscore"));
            }
            subScoreRuleNames.add(subScoreRule.getString("name"));
        }
        return new SubScoreRulePojo(subScore, subLevel, subScoreRuleNames);
    }

    public static void writeModifyLog(CreditPointDTO dto, String changeType, String source, DynamicObject oldLevel, DynamicObject newLevel, BigDecimal oldScore, BigDecimal newScore, String description) {
        Long orgID = UserServiceHelper.getUserMainOrgId((long)dto.getUserId());
        Long companyId = (Long)OrgServiceHelper.getCompanyfromOrg((Object)orgID).get("id");
        DynamicObject modifyLog = BusinessDataServiceHelper.newDynamicObject((String)"task_creditmodifylog");
        modifyLog.set("raiser", (Object)dto.getUserId());
        modifyLog.set("dept", (Object)orgID);
        modifyLog.set("company", (Object)companyId);
        modifyLog.set("modifytype", (Object)changeType);
        modifyLog.set("modifysource", (Object)source);
        modifyLog.set("oldlevel", (Object)oldLevel.getString("name"));
        modifyLog.set("newlevel", (Object)newLevel.getString("name"));
        modifyLog.set("oldgrade", (Object)oldScore);
        modifyLog.set("newgrade", (Object)newScore);
        modifyLog.set("changedscore", (Object)newScore.subtract(oldScore));
        modifyLog.set("description", (Object)description);
        modifyLog.set("modifydate", (Object)new Date());
        modifyLog.set("enable", (Object)Character.valueOf('1'));
        modifyLog.set("billentity", (Object)dto.getBillNumber());
        modifyLog.set("billid", (Object)dto.getBillId());
        modifyLog.set("billno", (Object)dto.getBillNo());
        modifyLog.set("taskid", (Object)dto.getHisTaskId());
        Object[] returnResult = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{modifyLog});
        if (returnResult == null || returnResult.length == 0) {
            ErrorCode errorCode = new ErrorCode("fi.ssc.credit_1", ResManager.loadKDString((String)"\u4fdd\u5b58\u4fe1\u7528\u53d8\u66f4\u65e5\u5fd7\u5931\u8d25\u3002", (String)"CreditServiceHelper_3", (String)"fi-fircm-business", (Object[])new Object[0]));
            throw new KDBizException(errorCode, returnResult);
        }
    }

    public static List<Long> querySubScoreRuleIdsByBillNumAndType(String billNum, String type) {
        boolean creditArgContainBillNum = CreditPlusAndMinusPointsHelper.validateCreditParameter(billNum);
        if (!creditArgContainBillNum) {
            return new ArrayList<Long>();
        }
        List<Long> subScoreRuleIds = CreditServiceHelper.querySubScoreDisquery(billNum);
        if (subScoreRuleIds == null || subScoreRuleIds.size() == 0) {
            return subScoreRuleIds;
        }
        return CreditServiceHelper.querySubScoreRuleIds(type, subScoreRuleIds);
    }

    private static List<Long> querySubScoreRuleIds(String type, List<Long> subScoreRuleIds) {
        QFilter idFil = new QFilter("id", "in", subScoreRuleIds);
        QFilter typeFil = new QFilter("type", "ftlike", (Object)type);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        Map subScoreRuleIdMap = BusinessDataServiceHelper.loadFromCache((String)"fircm_subscorerule", (String)"id", (QFilter[])new QFilter[]{idFil, typeFil, enableFilter});
        return subScoreRuleIdMap.values().stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
    }

    private static List<Long> querySubScoreDisquery(String billNum) {
        QFilter billNoFilter = new QFilter("taskbillid", "=", (Object)billNum);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        Map disqueryMap = BusinessDataServiceHelper.loadFromCache((String)"fircm_subscoredisquery", (String)"subscoreruleid.id", (QFilter[])new QFilter[]{billNoFilter, enableFilter});
        List<Long> subScoreRuleIds = disqueryMap.values().stream().map(dy -> Long.valueOf(dy.getString("subscoreruleid.id"))).collect(Collectors.toList());
        return subScoreRuleIds;
    }

    public static boolean isConfigCreditArg(String billType) {
        QFilter ableFilter = new QFilter("status", "=", (Object)"C");
        ableFilter.and(new QFilter("enable", "=", (Object)"1"));
        QFilter billTypeFilter = new QFilter("bizbill", "=", (Object)billType);
        return QueryServiceHelper.exists((String)"fircm_creditarg", (QFilter[])new QFilter[]{ableFilter, billTypeFilter});
    }

    public static void insertCreditModLogOfZero(String creditPointDTOStr, String sourceType, String description) {
        CreditPointDTO dto = (CreditPointDTO)SerializationUtils.fromJsonString((String)creditPointDTOStr, CreditPointDTO.class);
        log.info("the parameter before updateCreditPoints, " + dto);
        if (dto == null || !ModifySourceEnum.isInclude((String)sourceType)) {
            log.error(String.format("the parameter verification failure, dto:{%s}, sourceType:{%s}", dto, sourceType));
            return;
        }
        if (!CreditPlusAndMinusPointsHelper.processCommonValidation(dto)) {
            log.error("bill not in fircm_creditarg");
            return;
        }
        DynamicObject userArchive = CreditServiceHelper.getUserCreditFile(dto.getUserId());
        if (userArchive == null) {
            log.error("insertCreditModLogOfZero failed. defaultLevel is null");
            return;
        }
        BigDecimal curScore = userArchive.getBigDecimal("creditvalue");
        DynamicObject curLevel = userArchive.getDynamicObject("creditlevel");
        String logDescription = String.format(ResManager.loadKDString((String)"%1$s\uff0c\u4fe1\u7528\u5206\u6570\u6263%2$s\u5206", (String)"CreditServiceHelper_2", (String)"fi-fircm-business", (Object[])new Object[0]), description, "0");
        CreditServiceHelper.writeModifyLog(dto, ModifyTypeEnum.MINUS_POINTS.getValue(), sourceType, curLevel, curLevel, curScore, curScore, logDescription);
    }

    public static DynamicObject queryCreditSettingByOrgId(Long orgId) {
        QFilter orgFilter = new QFilter("createorg", "=", (Object)orgId);
        QFilter privateCtrlStrategy = new QFilter("ctrlstrategy", "=", (Object)"7");
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        Long pkId = 0L;
        DynamicObject privateDynamicObject = BusinessDataServiceHelper.loadSingle((String)"my_creditsetting", (String)"fid", (QFilter[])new QFilter[]{orgFilter, privateCtrlStrategy, enable});
        if (privateDynamicObject != null) {
            pkId = privateDynamicObject.getLong("id");
            return CreditServiceHelper.queryCreditSettingByFid(pkId);
        }
        IBaseDataService baseDataService = (IBaseDataService)ServiceFactory.getService(IBaseDataService.class);
        QFilter useOrgFilter = baseDataService.getBaseDataFilter("my_creditsetting", orgId);
        QFilter notPrivateFilter = new QFilter("ctrlstrategy", "!=", (Object)"7");
        DynamicObject[] results = BusinessDataServiceHelper.load((String)"my_creditsetting", (String)"fid,ctrlstrategy", (QFilter[])new QFilter[]{useOrgFilter, notPrivateFilter, enable}, (String)"createtime desc");
        Long firstPublicSettingId = 0L;
        for (DynamicObject dynamicObject : results) {
            String ctrlStrategy = dynamicObject.getString("ctrlstrategy");
            if (!"5".equals(ctrlStrategy)) {
                pkId = dynamicObject.getLong("id");
                return CreditServiceHelper.queryCreditSettingByFid(pkId);
            }
            if (firstPublicSettingId != 0L) continue;
            firstPublicSettingId = dynamicObject.getLong("id");
            break;
        }
        if ((pkId = firstPublicSettingId) == 0L) {
            return null;
        }
        return CreditServiceHelper.queryCreditSettingByFid(pkId);
    }

    private static DynamicObject queryCreditSettingByFid(Long fid) {
        return BusinessDataServiceHelper.loadSingle((Object)fid, (String)"my_creditsetting");
    }

    public static int updateWfCConfByFormNum(String formNum) {
        String appNumber = FormMetadataCache.getFormConfig((String)formNum).getBizAppNumber();
        QFilter typeFilter = new QFilter("type", "=", (Object)"global");
        QFilter keyFilter = new QFilter("key", "=", (Object)"extraApprovalPlugins");
        DynamicObject wfConfValue = BusinessDataServiceHelper.loadSingle((String)"wf_confcenter", (String)"id,value", (QFilter[])new QFilter[]{typeFilter, keyFilter});
        if (wfConfValue == null) {
            return 0;
        }
        String valueStr = wfConfValue.getString("value");
        JSONObject valueMap = JSONObject.parseObject((String)valueStr);
        Map entryMap = (Map)valueMap.get("creditcontrol");
        String appids = String.valueOf(entryMap.get("appids"));
        if (appids.toLowerCase().contains(appNumber.toLowerCase())) {
            return 2;
        }
        String regex = "(?<=appids\":\").*?(?=\"})";
        String newValue = valueStr.replaceAll(regex, appids + "," + appNumber);
        wfConfValue.set("value", (Object)newValue);
        SaveServiceHelper.update((DynamicObject)wfConfValue);
        return 1;
    }

    public static Long queryCreditArgAppObj(String billType, String billId) {
        String appObj = CreditServiceHelper.getCreditArgAppObj(billType);
        if (StringUtils.isEmpty((String)appObj)) {
            return null;
        }
        return CreditServiceHelper.queryBizBillUserId(billType, billId, appObj);
    }

    private static String getCreditArgAppObj(String billType) {
        QFilter commonFilter = new QFilter("status", "!=", (Object)Character.valueOf('D'));
        QFilter enableFilter = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        QFilter billFilter = new QFilter("bizbill", "=", (Object)billType);
        QFilter[] filters = new QFilter[]{commonFilter, enableFilter, billFilter};
        DynamicObject creditArgDyn = BusinessDataServiceHelper.loadSingle((String)"fircm_creditarg", (String)"appobj", (QFilter[])filters);
        return Optional.ofNullable(creditArgDyn).map(crfeditArg -> crfeditArg.getString("appobj")).orElse(null);
    }

    private static Long queryBizBillUserId(String billType, String billId, String appObj) {
        long billIdL;
        try {
            billIdL = Long.parseLong(billId);
        }
        catch (NumberFormatException e) {
            log.error("transfer billId error,only support long type billId:" + billId);
            return -1L;
        }
        DynamicObject dynObj = BusinessDataServiceHelper.loadSingle((String)billType, (String)appObj, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)billIdL)});
        return Optional.ofNullable(dynObj).map(obj -> obj.getDynamicObject(appObj)).map(user -> user.getLong("id")).orElse(-1L);
    }
}

