/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fircm.business.helper;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.fircm.business.helper.pojo.CreditSettingDTO;
import kd.fi.fircm.enums.CtrlStrategyEnum;

public class CreditSettingHelper {
    public static CreditSettingDTO getCreditSettingInfo(long orgId, String creditType) {
        QFilter qfilter = BaseDataServiceHelper.getBaseDataFilter((String)"fircm_creditsetting", (Long)orgId);
        Map map = BusinessDataServiceHelper.loadFromCache((String)"fircm_creditsetting", (String)"createtime,ctrlstrategy,attentionpoint,entryentity.creditlevel,entryentity.sign", (QFilter[])qfilter.toArray());
        DynamicObject[] results = map.values().toArray(new DynamicObject[0]);
        if (results.length <= 0) {
            return new CreditSettingDTO();
        }
        DynamicObject result = null;
        boolean isAllocate = false;
        ArrayList<DynamicObject> allocatedArr = new ArrayList<DynamicObject>(results.length);
        ArrayList<DynamicObject> sharedArr = new ArrayList<DynamicObject>(results.length);
        for (DynamicObject dy_ : results) {
            String ctrlStrategy = dy_.getString("ctrlstrategy");
            if (StringUtils.equals((CharSequence)CtrlStrategyEnum.PRIVATIZATION.getValue(), (CharSequence)ctrlStrategy)) {
                result = dy_;
                break;
            }
            if (StringUtils.equals((CharSequence)CtrlStrategyEnum.ALLOCATION_STEP_BY_STEP.getValue(), (CharSequence)ctrlStrategy) || StringUtils.equals((CharSequence)CtrlStrategyEnum.ALLOCATION_FREE.getValue(), (CharSequence)ctrlStrategy)) {
                allocatedArr.add(dy_);
                isAllocate = true;
                continue;
            }
            if ((isAllocate || !StringUtils.equals((CharSequence)CtrlStrategyEnum.GLOBAL_SHARED.getValue(), (CharSequence)ctrlStrategy)) && !StringUtils.equals((CharSequence)CtrlStrategyEnum.GLOBAL_SHARED_SCOPE.getValue(), (CharSequence)ctrlStrategy)) continue;
            sharedArr.add(dy_);
        }
        if (result != null) {
            return CreditSettingHelper.createCreditSettingDTO(result, creditType);
        }
        if (!CollectionUtils.isEmpty(allocatedArr)) {
            return CreditSettingHelper.filterDataByPriority(creditType, allocatedArr);
        }
        if (!CollectionUtils.isEmpty(sharedArr)) {
            return CreditSettingHelper.filterDataByPriority(creditType, sharedArr);
        }
        return new CreditSettingDTO();
    }

    private static CreditSettingDTO filterDataByPriority(String creditType, List<DynamicObject> allocatedArr) {
        List currentArr = allocatedArr.stream().sorted(Comparator.comparing(dy -> dy.getDate("createtime"), Comparator.reverseOrder())).collect(Collectors.toList());
        return CreditSettingHelper.createCreditSettingDTO((DynamicObject)currentArr.get(0), creditType);
    }

    private static CreditSettingDTO createCreditSettingDTO(DynamicObject dy, String creditType) {
        DynamicObjectCollection entryEntity = dy.getDynamicObjectCollection("entryentity");
        List dys = entryEntity.stream().filter(dy_ -> StringUtils.equals((CharSequence)dy_.getString("creditlevel.number"), (CharSequence)creditType)).collect(Collectors.toList());
        DynamicObject current = (DynamicObject)dys.get(0);
        String sign = current.getString("sign");
        String attentionPoint = dy.getString("attentionpoint");
        return new CreditSettingDTO(sign, attentionPoint);
    }
}

