/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fircm.business.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.ext.fircm.dto.ApproveTaskResult;
import kd.bos.ext.fircm.dto.WorkFlowNodeCreditRecordDto;
import kd.bos.ext.fircm.enums.WorkFlowAuditTypeEnum;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fircm.business.helper.CreditServiceHelper;

public class WorkFlowCreditHelper {
    private static final Log log = LogFactory.getLog(WorkFlowCreditHelper.class);
    private static final String WF_HITASKINST = "wf_hitaskinst";
    private static final String WF_HIVARINST = "wf_hivarinst";
    private static final String VARNAME_CREDIT = "creditscorerule";
    private static final String VARNAME_AUDITTYPE = "audittype";

    public static String handleCreditScoreWhenWFNodeLeave(Map<String, String> handleBizData) {
        List flowCSSInfo;
        boolean creditNode;
        if (handleBizData == null) {
            return null;
        }
        String flowElementType = handleBizData.get("flowElementType");
        boolean bl = creditNode = "AuditTask".equalsIgnoreCase(flowElementType) || "YunzhijiaTask".equalsIgnoreCase(flowElementType);
        if (!creditNode) {
            return null;
        }
        String entityNumber = handleBizData.get("entityNumber");
        boolean configCreditArg = CreditServiceHelper.isConfigCreditArg(entityNumber);
        if (!configCreditArg) {
            return null;
        }
        List<ApproveTaskResult> approveTaskResultList = WorkFlowCreditHelper.getThisNodeApproveResult(handleBizData);
        if (approveTaskResultList.isEmpty()) {
            return null;
        }
        WorkFlowNodeCreditRecordDto nowNodeCSSInfoDto = new WorkFlowNodeCreditRecordDto(handleBizData.get("flowElementId"), handleBizData.get("flowElementName"), approveTaskResultList);
        String flowCSSInfoStr = handleBizData.get("creditSubScoreInfoStr");
        if (flowCSSInfoStr == null || flowCSSInfoStr.isEmpty()) {
            flowCSSInfo = Collections.singletonList(nowNodeCSSInfoDto);
        } else {
            flowCSSInfo = SerializationUtils.fromJsonStringToList((String)flowCSSInfoStr, WorkFlowNodeCreditRecordDto.class);
            flowCSSInfo.removeIf(item -> item.getFlowNodeId().equals(nowNodeCSSInfoDto.getFlowNodeId()));
            flowCSSInfo.add(nowNodeCSSInfoDto);
        }
        return SerializationUtils.toJsonString(flowCSSInfo);
    }

    private static List<ApproveTaskResult> getThisNodeApproveResult(Map<String, String> handleBizData) {
        ArrayList<ApproveTaskResult> approveTaskResultList = new ArrayList<ApproveTaskResult>();
        String flowType = handleBizData.get("flowElementType");
        if ("YunzhijiaTask".equalsIgnoreCase(flowType)) {
            String currentTaskIdStr = handleBizData.get("currentTaskId");
            if (currentTaskIdStr == null || "0".equals(currentTaskIdStr)) {
                return approveTaskResultList;
            }
            Long currentTaskId = Long.valueOf(currentTaskIdStr);
            QFilter parentFilter = new QFilter("parenttaskid", "=", (Object)currentTaskId);
            DynamicObjectCollection childTasks = QueryServiceHelper.query((String)WF_HITASKINST, (String)"id,assignee", (QFilter[])parentFilter.toArray());
            if (childTasks.size() < 1) {
                return approveTaskResultList;
            }
            Map<Long, String> taskApproverMap = childTasks.stream().collect(Collectors.toMap(ct -> ct.getLong("id"), ct -> ct.getString("assignee")));
            QFilter varFilter = new QFilter("taskid", "in", taskApproverMap.keySet());
            varFilter.and(new QFilter("name", "in", (Object)new String[]{VARNAME_CREDIT, VARNAME_AUDITTYPE}));
            DynamicObjectCollection variables = QueryServiceHelper.query((String)WF_HIVARINST, (String)"taskid,name,textvalue", (QFilter[])varFilter.toArray());
            Map<String, String> taskVarMap = variables.stream().collect(Collectors.toMap(var -> var.getString("taskid") + "_" + var.getString("name"), var -> var.getString("textvalue"), (v1, v2) -> v2));
            for (Map.Entry<Long, String> taskApprover : taskApproverMap.entrySet()) {
                String creditRuleVar;
                String auditTypeVar;
                Long taskId = taskApprover.getKey();
                String approver = taskApprover.getValue();
                ApproveTaskResult approveTaskResult = WorkFlowCreditHelper.buildApproveTaskResult(approver, auditTypeVar = taskVarMap.get(taskId + "_" + VARNAME_AUDITTYPE), creditRuleVar = taskVarMap.get(taskId + "_" + VARNAME_CREDIT));
                if (approveTaskResult == null) continue;
                approveTaskResultList.add(approveTaskResult);
            }
        } else {
            String auditType;
            String creditScoreRule;
            if (handleBizData.get("creditScoreRule") != null) {
                creditScoreRule = handleBizData.get("creditScoreRule");
                auditType = handleBizData.get("auditType");
            } else {
                creditScoreRule = "0";
                String handleWayObj = handleBizData.get("handleWay");
                if (handleWayObj != null) {
                    auditType = handleWayObj;
                } else {
                    log.info("CreditApprovalNodeLeaveListener appear abnormal case\uff1adidn't get this node's auditType");
                    auditType = "";
                }
            }
            ApproveTaskResult approveTaskResult = WorkFlowCreditHelper.buildApproveTaskResult(null, auditType, creditScoreRule);
            if (approveTaskResult != null) {
                approveTaskResultList.add(approveTaskResult);
            }
        }
        return approveTaskResultList;
    }

    private static ApproveTaskResult buildApproveTaskResult(String approver, String auditType, String creditScoreRule) {
        if (StringUtils.isEmpty((String)auditType) || StringUtils.isEmpty((String)creditScoreRule)) {
            return null;
        }
        WorkFlowAuditTypeEnum auditTypeEnum = WorkFlowAuditTypeEnum.getValue((String)auditType);
        if (auditTypeEnum == null || WorkFlowAuditTypeEnum.TERMINATE == auditTypeEnum || WorkFlowAuditTypeEnum.BATCHAGREE == auditTypeEnum || WorkFlowAuditTypeEnum.AGREEAPI == auditTypeEnum) {
            return null;
        }
        List<String> creditSIdsStr = Arrays.asList(creditScoreRule.split(","));
        List creditSIds = creditSIdsStr.stream().map(Long::valueOf).collect(Collectors.toList());
        String resultDescription = auditTypeEnum.getDescription();
        if (approver != null) {
            resultDescription = approver + resultDescription;
        }
        return new ApproveTaskResult(creditSIds, auditType, resultDescription);
    }
}

