/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fircm.business.service.credit.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fircm.business.factory.credit.CreditLevelSerivceFactory;
import kd.fi.fircm.business.service.credit.CreditChangeRuleService;
import kd.fi.fircm.business.service.credit.CreditLevelSerivce;

public class CreditChangeRuleServiceImpl
implements CreditChangeRuleService {
    private QFilter enableFil = new QFilter("enable", "=", (Object)Character.valueOf('1'));

    @Override
    public Map<String, BigDecimal> getScoreChangedLimit() {
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>(2);
        qfilters.add(this.enableFil);
        String selFields = "id,addscoreper,subscorelimit";
        DynamicObject dynObj = QueryServiceHelper.queryOne((String)"task_creditscorelimit", (String)selFields, (QFilter[])qfilters.toArray(new QFilter[qfilters.size()]));
        HashMap<String, BigDecimal> scoreLimitMap = new HashMap<String, BigDecimal>(2);
        if (dynObj != null) {
            scoreLimitMap.put("addscoreper", dynObj.getBigDecimal("addscoreper"));
            scoreLimitMap.put("subscorelimit", dynObj.getBigDecimal("subscorelimit"));
        }
        return scoreLimitMap;
    }

    @Override
    public boolean initScoreChangedLimitIfNotExist() {
        if (!QueryServiceHelper.exists((String)"task_creditscorelimit", (QFilter[])new QFilter[]{this.enableFil})) {
            long userId = RequestContext.get().getCurrUserId();
            CreditLevelSerivce levelService = CreditLevelSerivceFactory.newInstance();
            Map<String, Integer> scoreRange = levelService.getCreditScoreRange();
            int max = scoreRange.get("max");
            Date now = new Date();
            DynamicObject dynObj = BusinessDataServiceHelper.newDynamicObject((String)"task_creditscorelimit");
            dynObj.set("creator", (Object)userId);
            dynObj.set("createtime", (Object)now);
            dynObj.set("status", (Object)"C");
            dynObj.set("enable", (Object)Character.valueOf('1'));
            dynObj.set("subscorelimit", (Object)BigDecimal.valueOf(max));
            dynObj.set("modifier", (Object)userId);
            dynObj.set("modifytime", (Object)now);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynObj});
            return true;
        }
        return false;
    }

    @Override
    public DynamicObject[] getCommonRule() {
        String selFields = "id,correctmonth,approvenum,addscore,levelstart,levelend,flag";
        return BusinessDataServiceHelper.load((String)"task_credit_commonrule", (String)selFields, (QFilter[])new QFilter[]{this.enableFil});
    }

    @Override
    public DynamicObject[] getCreditByWithdrawal() {
        String selFields = "id,withdrawal,subscore,sublevel,flag";
        return BusinessDataServiceHelper.load((String)"task_creditbywithdrawal", (String)selFields, (QFilter[])new QFilter[]{this.enableFil});
    }

    @Override
    public DynamicObjectCollection getCreditByBreakRule() {
        String selFields = "id,name,subscore";
        return QueryServiceHelper.query((String)"task_creditbybreakrule", (String)selFields, (QFilter[])new QFilter[]{this.enableFil});
    }

    @Override
    public DynamicObject[] getCreditByQuality() {
        String selFields = "id,qualitycheck,subscore";
        return BusinessDataServiceHelper.load((String)"task_creditbyquality", (String)selFields, (QFilter[])new QFilter[]{this.enableFil});
    }

    @Override
    public DynamicObjectCollection getCreditByImage() {
        String selFields = "id,outdatenum,subscore";
        return QueryServiceHelper.query((String)"task_creditbyimagenew", (String)selFields, (QFilter[])new QFilter[]{this.enableFil}, (String)"outdatenum desc");
    }
}

