/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fircm.business.service.credit.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.fircm.business.helper.CreditModifyLogServiceHelper;
import kd.fi.fircm.business.service.credit.CreditFilesService;

public class CreditFilesServiceImpl
implements CreditFilesService {
    private static final Log log = LogFactory.getLog(CreditFilesServiceImpl.class);
    private String selectFileds = "id,user,creditlevel,creditvalue,bonuspointnum,unqualifiedtotalnum";

    @Override
    public DynamicObject getCreditFile(Long userId) {
        if (userId > 0L) {
            QFilter userFil = new QFilter("user", "=", (Object)userId);
            QFilter statusFilter = new QFilter("status", "!=", (Object)Character.valueOf('D'));
            return BusinessDataServiceHelper.loadSingle((String)"task_creditfiles", (String)this.selectFileds, (QFilter[])new QFilter[]{userFil, statusFilter});
        }
        return null;
    }

    @Override
    public Map<Long, DynamicObject> getCreditFiles(List<Long> userIds) {
        if (userIds.size() > 0) {
            QFilter userFil = new QFilter("user", "in", userIds);
            QFilter statusFilter = new QFilter("status", "!=", (Object)Character.valueOf('D'));
            DynamicObject[] creditFiles = BusinessDataServiceHelper.load((String)"task_creditfiles", (String)this.selectFileds, (QFilter[])new QFilter[]{userFil, statusFilter});
            HashMap<Long, DynamicObject> dataMap = new HashMap<Long, DynamicObject>(16);
            for (int i = 0; i < creditFiles.length; ++i) {
                DynamicObject creditFile = creditFiles[i];
                dataMap.put(creditFile.getLong("user.id"), creditFile);
            }
            return dataMap;
        }
        return null;
    }

    @Override
    public DynamicObject initCreditFile(Long userId, DynamicObject defaultLevel) {
        if (defaultLevel == null) {
            return null;
        }
        DynamicObject creditFile = BusinessDataServiceHelper.newDynamicObject((String)"task_creditfiles");
        creditFile.set("user", (Object)userId);
        creditFile.set("creditlevel", defaultLevel.get("id"));
        creditFile.set("creditvalue", defaultLevel.get("defaultvalue"));
        creditFile.set("enable", (Object)Character.valueOf('1'));
        creditFile.set("status", (Object)Character.valueOf('C'));
        Date date = new Date();
        creditFile.set("createtime", (Object)date);
        creditFile.set("modifytime", (Object)date);
        Long orgId = UserServiceHelper.getUserMainOrgId((long)userId);
        creditFile.set("dept", (Object)orgId);
        Long companyId = (Long)OrgServiceHelper.getCompanyfromOrg((Object)orgId).get("id");
        creditFile.set("company", (Object)companyId);
        DynamicObject creditLog = CreditModifyLogServiceHelper.initCreditModifyLog(userId, companyId, orgId, defaultLevel.getString("name"), defaultLevel.getBigDecimal("defaultvalue"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{creditFile});
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{creditLog});
        return this.getCreditFile(userId);
    }
}

