/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fircm.business.service.credit.impl;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.fircm.business.service.credit.CreditLevelSerivce;
import kd.fi.fircm.task.util.ObjectCloneUtil;

public class CreditLevelServiceImpl
implements CreditLevelSerivce {
    private DynamicObject[] levels;

    @Override
    public DynamicObject[] getAllCreditLevel() {
        if (this.levels != null) {
            return this.getLevelCopyValue();
        }
        QFilter[] qfilters = new QFilter[]{new QFilter("status", "!=", (Object)Character.valueOf('D'))};
        String entityName = "task_creditlevel";
        String selectProps = "id, name, minvalue, maxvalue, defaultvalue, defaultlevel";
        String orderBy = "maxvalue asc";
        this.levels = BusinessDataServiceHelper.load((String)entityName, (String)selectProps, (QFilter[])qfilters, (String)orderBy);
        return this.getLevelCopyValue();
    }

    @Override
    public Map<String, Integer> getCreditScoreRange() {
        HashMap<String, Integer> scoreRange = new HashMap<String, Integer>(2);
        DynamicObject[] credLevels = this.getAllCreditLevel();
        if (credLevels != null && credLevels.length > 0) {
            scoreRange.put("min", credLevels[0].getInt("minvalue"));
            scoreRange.put("max", credLevels[credLevels.length - 1].getInt("maxvalue"));
        } else {
            scoreRange.put("min", 0);
            scoreRange.put("max", 100);
        }
        return scoreRange;
    }

    @Override
    public DynamicObject getCreditLevel(BigDecimal score) {
        if (score == null) {
            return null;
        }
        DynamicObject[] credLevels = this.getAllCreditLevel();
        Integer maxRange = this.getCreditScoreRange().get("max");
        for (DynamicObject dynObj : credLevels) {
            int result1 = score.compareTo(dynObj.getBigDecimal("minvalue"));
            int result2 = score.compareTo(dynObj.getBigDecimal("maxvalue"));
            int result3 = score.compareTo(BigDecimal.valueOf(maxRange.intValue()));
            if (result1 >= 0 && result2 < 0) {
                return dynObj;
            }
            if (result2 != 0 || result3 != 0) continue;
            return dynObj;
        }
        return null;
    }

    @Override
    public DynamicObject getDefaultLevel() {
        DynamicObject[] credLevels;
        for (DynamicObject dynObj : credLevels = this.getAllCreditLevel()) {
            if (!"true".equals(dynObj.getString("defaultlevel"))) continue;
            return dynObj;
        }
        return null;
    }

    @Override
    public DynamicObject getCreditLevel(Long id) {
        DynamicObject[] credLevels;
        for (DynamicObject dynObj : credLevels = this.getAllCreditLevel()) {
            if (id.longValue() != dynObj.getLong("id")) continue;
            return dynObj;
        }
        return null;
    }

    private DynamicObject[] getLevelCopyValue() {
        return (DynamicObject[])ObjectCloneUtil.cloneObject((Object)this.levels);
    }
}

