/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fircm.business.service.credit.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fircm.business.service.credit.ICreditWebApiService;

public class CreditWebApiServiceImpl
implements ICreditWebApiService {
    private static final Log log = LogFactory.getLog(CreditWebApiServiceImpl.class);

    @Override
    public Map<String, Object> queryCreditInfoByUserId(Map<String, Object> params) {
        Long userId = (Long)this.getRequestParam(params, "userId", Long.class);
        Boolean isFullInfo = (Boolean)this.getRequestParam(params, "isFullInfo", Boolean.class);
        DynamicObject creditFile = this.getCreditFile(userId);
        if (creditFile == null) {
            return new HashMap<String, Object>(0);
        }
        HashMap<String, Object> crditInfoMap = new HashMap<String, Object>(10);
        this.buildCreditFileInfo(crditInfoMap, creditFile);
        if (isFullInfo.booleanValue()) {
            this.buildCreditLogInfo(userId, crditInfoMap);
        }
        return crditInfoMap;
    }

    private <T> T getRequestParam(Map<String, Object> params, String key, Class clazz) {
        Object obj = params.get(key);
        if (obj == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"CreditWebApiServiceImpl_0", (String)"fi-fircm-business", (Object[])new Object[0]), key));
        }
        String objStr = obj.toString();
        try {
            if (Long.class.equals((Object)clazz)) {
                Long longTypeValue = Long.valueOf(objStr);
                return (T)longTypeValue;
            }
            Boolean booleanTypeValue = Boolean.parseBoolean(objStr);
            return (T)booleanTypeValue;
        }
        catch (Exception e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u53c2\u6570\u7c7b\u578b\u5f02\u5e38", (String)"CreditWebApiServiceImpl_1", (String)"fi-fircm-business", (Object[])new Object[0]), key));
        }
    }

    private void buildCreditFileInfo(Map<String, Object> crditInfoMap, DynamicObject creditFile) {
        crditInfoMap.put("userid", creditFile.get("user.id"));
        crditInfoMap.put("levelid", creditFile.get("creditlevel.id"));
        crditInfoMap.put("levelname", creditFile.get("creditlevel.name"));
        crditInfoMap.put("score", creditFile.get("creditvalue"));
    }

    private DynamicObject getCreditFile(Long userId) {
        QFilter filter = new QFilter("user", "=", (Object)userId);
        QFilter statusFilter = new QFilter("status", "!=", (Object)Character.valueOf('D'));
        QFilter[] filters = new QFilter[]{filter, statusFilter};
        DynamicObject creditFile = QueryServiceHelper.queryOne((String)"task_creditfiles", (String)"user.id,creditlevel.id,creditlevel.name,creditvalue", (QFilter[])filters);
        return creditFile;
    }

    private void buildCreditLogInfo(Long userId, Map<String, Object> crditInfoMap) {
        String algoKey = CreditWebApiServiceImpl.class + ".buildCreditLogInfo()";
        QFilter filter = new QFilter("raiser", "=", (Object)userId);
        QFilter statusFilter = new QFilter("status", "!=", (Object)Character.valueOf('D'));
        QFilter[] filters = new QFilter[]{filter, statusFilter};
        String selectFields = "id,changedscore,modifydate,modifysource,description";
        ArrayList creditLogInfoList = new ArrayList();
        try (DataSet creditLog = QueryServiceHelper.queryDataSet((String)algoKey, (String)"task_creditmodifylog", (String)selectFields, (QFilter[])filters, null);){
            while (creditLog.hasNext()) {
                Row row = creditLog.next();
                HashMap<String, Object> logInfo = new HashMap<String, Object>();
                logInfo.put("id", row.get("id"));
                logInfo.put("changedscore", row.get("changedscore"));
                logInfo.put("changetime", row.get("modifydate"));
                logInfo.put("source", row.get("modifysource"));
                logInfo.put("desc", row.get("description"));
                creditLogInfoList.add(logInfo);
            }
        }
        if (!CollectionUtils.isEmpty(creditLogInfoList)) {
            crditInfoMap.put("changerecord", creditLogInfoList);
        }
    }
}

