/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fircm.creditupdate;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.fircm.business.factory.credit.CreditFilesServiceFactory;
import kd.fi.fircm.business.factory.credit.CreditLevelSerivceFactory;
import kd.fi.fircm.business.helper.CreditModifyLogServiceHelper;
import kd.fi.fircm.business.service.credit.CreditFilesService;
import kd.fi.fircm.business.service.credit.CreditLevelSerivce;
import kd.fi.fircm.common.UserChangeTypeEnum;
import kd.fi.fircm.task.util.TaskParamControlUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class CreditFilesUpdateTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(CreditFilesUpdateTask.class);
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String UPDATE_SQL = "update t_tk_creditfiles set forgfield = ?, forg = ? where fuser = ?";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        if (!this.isExistCreditFiles()) {
            log.info(((Object)((Object)this)).getClass() + " creditFiles data not exist");
            return;
        }
        String lastExecTime = this.getLastExecTime();
        HashMap<Long, Map<String, Object>> updateUserInfoMap = new HashMap<Long, Map<String, Object>>(8);
        HashSet<Long> addUserIdSet = new HashSet<Long>(8);
        HashSet<Long> deleteUserIdSet = new HashSet<Long>(8);
        this.getUserChangeInfo(lastExecTime, updateUserInfoMap, addUserIdSet, deleteUserIdSet);
        this.initUserCreditFile(addUserIdSet);
        this.updateUserCreditFileInfo(updateUserInfoMap);
        this.discardUserCreditFile(deleteUserIdSet);
        this.writeBackExecTime();
    }

    private void updateUserCreditFileByOrgChanged(String lastExecTime) {
        List<Long> changedAdminOrgIdList = this.getChangedAdminOrgInfo(lastExecTime);
        if (changedAdminOrgIdList == null || changedAdminOrgIdList.size() == 0) {
            return;
        }
        log.info("\u672c\u6b21\u53d8\u52a8\u7684\u7ec4\u7ec7\u6709" + changedAdminOrgIdList.size() + "\u4e2a");
        QFilter deptFilter = new QFilter("dept", "in", changedAdminOrgIdList);
        QFilter companyFilter = new QFilter("company", "in", changedAdminOrgIdList);
        DynamicObjectCollection creditFiles = QueryServiceHelper.query((String)"task_creditfiles", (String)"id,dept,company,user", (QFilter[])new QFilter[]{deptFilter.or(companyFilter)});
        if (creditFiles != null && creditFiles.size() > 0) {
            log.info("\u7ec4\u7ec7\u53d8\u52a8\u5bfc\u81f4\u7528\u6237\u4fe1\u7528\u6863\u6848\u9700\u8981\u53d8\u52a8\u7684\u4eba\u6570\uff1a" + creditFiles.size());
            List userIdList = creditFiles.stream().map(dynamicObject -> dynamicObject.getLong("user")).collect(Collectors.toList());
            List userMainOrgIds = UserServiceHelper.getUserMainOrgId(userIdList);
            Map userCompanyMap = UserServiceHelper.getCompanyByUserIds(userIdList);
            HashMap userMainOrgMap = new HashMap(userIdList.size());
            for (Object map : userMainOrgIds) {
                userMainOrgMap.putAll(map);
            }
            ArrayList<Object[]> updateParams = new ArrayList<Object[]>(userIdList.size());
            for (Long userId : userIdList) {
                Long userCompany;
                Long userMainOrg = (Long)userMainOrgMap.get(userId);
                if (ObjectUtils.anyNull((Object[])new Object[]{userMainOrg, userCompany = (Long)userCompanyMap.get(userId), userId})) {
                    log.info(userId + "\u7684\u4e3b\u804c\u90e8\u95e8\u6216\u4e3b\u804c\u90e8\u95e8\u6240\u5728\u516c\u53f8\u4e3a\u7a7a\uff0cmainOrg = {}, userCompany = {}", (Object)userMainOrg, (Object)userCompany);
                    continue;
                }
                Object[] param = new Object[]{userMainOrgMap.get(userId), userCompanyMap.get(userId), userId};
                updateParams.add(param);
            }
            if (!updateParams.isEmpty()) {
                log.info("\u6267\u884c\u66f4\u65b0\u7684\u6570\u636e\u4e2a\u6570\uff1a" + updateParams.size());
                try (TXHandle h = TX.requiresNew((String)"fi-fircm-updateUserCreditFileInfoByOrgChange");){
                    try {
                        DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)UPDATE_SQL, updateParams);
                    }
                    catch (Throwable e) {
                        h.markRollback();
                        log.error(((Object)((Object)this)).getClass() + " error ", e);
                    }
                }
            }
        }
    }

    private List<Long> getChangedAdminOrgInfo(String lastExecTime) {
        Date lastExecDate = null;
        try {
            lastExecDate = this.dateFormat.parse(lastExecTime);
        }
        catch (Exception e) {
            log.error(lastExecTime + "\u8f6cDate\u5f02\u5e38\uff1a" + e.getMessage());
        }
        if (lastExecDate == null) {
            log.warn("\u4e0a\u6b21\u6267\u884c\u65f6\u95f4\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u7ec4\u7ec7\u66f4\u65b0\u7684\u5904\u7406");
            return null;
        }
        QFilter modifyTimeFilter = new QFilter("modifytime", ">=", (Object)lastExecDate);
        QFilter adminOrgFilter = new QFilter("fisadministrative", "=", (Object)"1");
        DynamicObjectCollection modifiedAdminOrgList = QueryServiceHelper.query((String)"bos_adminorg", (String)"id", (QFilter[])new QFilter[]{modifyTimeFilter, adminOrgFilter});
        if (modifiedAdminOrgList == null || modifiedAdminOrgList.size() == 0) {
            log.info("\u672a\u53d1\u73b0\u53d8\u66f4\u7684\u7ec4\u7ec7\u3002");
            return null;
        }
        return modifiedAdminOrgList.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
    }

    private void getUserChangeInfo(String lastExecTime, Map<Long, Map<String, Object>> updateUserInfoMap, Set<Long> addUserIdSet, Set<Long> deleteUserIdSet) {
        List userChangeInfos = UserServiceHelper.getUserChangeInfos((String)lastExecTime, (boolean)false, (boolean)true);
        StringBuilder sb = new StringBuilder("ssc_creditboard_userInfoMap: ");
        int i = 0;
        for (Map userMap : userChangeInfos) {
            Long userId = (Long)userMap.get("id");
            String type = (String)userMap.get("type");
            if (i < 100) {
                sb.append(userId).append(',').append(type).append(';');
            }
            if (UserChangeTypeEnum.ADD.getType().equals(type)) {
                addUserIdSet.add(userId);
            } else if (UserChangeTypeEnum.UPDATE.getType().equals(type)) {
                updateUserInfoMap.put(userId, userMap);
            } else if (UserChangeTypeEnum.DELETE.getType().equals(type)) {
                deleteUserIdSet.add(userId);
            }
            ++i;
        }
        log.warn(sb.toString());
    }

    private void discardUserCreditFile(Set<Long> deleteUserIdSet) {
        if (CollectionUtils.isEmpty(deleteUserIdSet)) {
            return;
        }
        try (TXHandle h = TX.requiresNew((String)"fi-fircm-batchDiscardUserCreditFile");){
            try {
                this.batchDiscardUserCreditFile(deleteUserIdSet);
            }
            catch (Throwable e) {
                h.markRollback();
                log.error(((Object)((Object)this)).getClass() + " error ", e);
            }
        }
    }

    private void batchDiscardUserCreditFile(Set<Long> deleteUserIdSet) {
        String selectField = "status";
        QFilter qfilter = new QFilter("enable", "=", (Object)"1");
        QFilter userFil = new QFilter("user", "in", deleteUserIdSet);
        QFilter statusFilter = new QFilter("status", "!=", (Object)Character.valueOf('D'));
        DynamicObject[] creditFiles = BusinessDataServiceHelper.load((String)"task_creditfiles", (String)selectField, (QFilter[])new QFilter[]{qfilter, userFil, statusFilter});
        if (creditFiles == null || creditFiles.length == 0) {
            return;
        }
        for (DynamicObject creditFile : creditFiles) {
            creditFile.set("status", (Object)Character.valueOf('D'));
        }
        SaveServiceHelper.update((DynamicObject[])creditFiles);
    }

    private void initUserCreditFile(Set<Long> addUserIdSet) {
        if (CollectionUtils.isEmpty(addUserIdSet)) {
            return;
        }
        try (TXHandle h = TX.requiresNew((String)"fi-fircm-batchInitUserCreditFile");){
            try {
                this.batchInitUserCreditFile(addUserIdSet);
            }
            catch (Throwable e) {
                h.markRollback();
                log.error(((Object)((Object)this)).getClass() + " error ", e);
            }
        }
    }

    private void batchInitUserCreditFile(Set<Long> addUserIdSet) {
        CreditLevelSerivce creditLevelSerivce;
        DynamicObject defaultLevel;
        CreditFilesService creditFilesService = CreditFilesServiceFactory.newInstance();
        Map existCreditFiles = creditFilesService.getCreditFiles(new ArrayList<Long>(addUserIdSet));
        if (!CollectionUtils.isEmpty((Map)existCreditFiles)) {
            Set existUserIdSet = existCreditFiles.keySet();
            log.error("credit file already exist, existUserIdSet = " + existUserIdSet);
            addUserIdSet.removeAll(existUserIdSet);
        }
        if ((defaultLevel = (creditLevelSerivce = CreditLevelSerivceFactory.newInstance()).getDefaultLevel()) == null) {
            return;
        }
        ArrayList<DynamicObject> addCreditFileList = new ArrayList<DynamicObject>(8);
        ArrayList<DynamicObject> addCreditLogList = new ArrayList<DynamicObject>(8);
        for (Long userId : addUserIdSet) {
            DynamicObject creditFile = BusinessDataServiceHelper.newDynamicObject((String)"task_creditfiles");
            creditFile.set("user", (Object)userId);
            creditFile.set("creditlevel", defaultLevel.get("id"));
            creditFile.set("creditvalue", defaultLevel.get("defaultvalue"));
            creditFile.set("enable", (Object)Character.valueOf('1'));
            creditFile.set("status", (Object)Character.valueOf('C'));
            Date date = new Date();
            creditFile.set("createtime", (Object)date);
            creditFile.set("modifytime", (Object)date);
            Long orgId = UserServiceHelper.getUserMainOrgId((long)userId);
            creditFile.set("dept", (Object)orgId);
            Long companyId = (Long)OrgServiceHelper.getCompanyfromOrg((Object)orgId).get("id");
            creditFile.set("company", (Object)companyId);
            DynamicObject creditLog = CreditModifyLogServiceHelper.initCreditModifyLog((Long)userId, (Long)companyId, (Long)orgId, (String)defaultLevel.getString("name"), (BigDecimal)defaultLevel.getBigDecimal("defaultvalue"));
            addCreditFileList.add(creditFile);
            addCreditLogList.add(creditLog);
            if (addCreditFileList.size() != 1000) continue;
            SaveServiceHelper.save((DynamicObject[])addCreditFileList.toArray(new DynamicObject[1000]));
            SaveServiceHelper.save((DynamicObject[])addCreditLogList.toArray(new DynamicObject[1000]));
            addCreditFileList.clear();
            addCreditLogList.clear();
        }
        if (addCreditFileList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])addCreditFileList.toArray(new DynamicObject[addCreditFileList.size()]));
        }
        if (addCreditLogList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])addCreditLogList.toArray(new DynamicObject[addCreditLogList.size()]));
        }
    }

    private void updateUserCreditFileInfo(Map<Long, Map<String, Object>> updateUserInfoMap) {
        List<Object[]> paramList = this.buildParamList(updateUserInfoMap);
        if (CollectionUtils.isEmpty(paramList)) {
            log.info(((Object)((Object)this)).getClass() + " No user information to update");
        }
        try (TXHandle h = TX.requiresNew((String)"fi-fircm-updateUserCreditFileInfo");){
            try {
                DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)UPDATE_SQL, paramList);
            }
            catch (Throwable e) {
                h.markRollback();
                log.error(((Object)((Object)this)).getClass() + " error ", e);
                if (h != null) {
                    if (var4_4 != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable) {
                            var4_4.addSuppressed(throwable);
                        }
                    } else {
                        h.close();
                    }
                }
                return;
            }
        }
    }

    private boolean isExistCreditFiles() {
        QFilter statusFilter = new QFilter("status", "!=", (Object)Character.valueOf('D'));
        return QueryServiceHelper.exists((String)"task_creditfiles", (QFilter[])new QFilter[]{statusFilter});
    }

    private String getLastExecTime() {
        AppParam param = new AppParam("1ZH12M=M8H7O", "15", Long.valueOf(OrgUnitServiceHelper.getRootOrgId()), Long.valueOf(0L));
        String execTimeStr = null;
        Object params = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param, (String)"creditfilesexectime");
        if (params instanceof Date) {
            execTimeStr = this.dateFormat.format(params);
        } else if (params instanceof String) {
            execTimeStr = (String)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param, (String)"creditfilesexectime");
        }
        if (StringUtils.isEmpty((CharSequence)execTimeStr)) {
            log.error("system parameter \"creditfilesexectime\" not exist or is empty");
            return this.getCreditFileExecTimeFromTask();
        }
        try {
            Date lastExecTime = this.dateFormat.parse(execTimeStr);
            return this.dateFormat.format(lastExecTime);
        }
        catch (ParseException e) {
            log.error("system parameter \"creditfilesexectime\" parse error", (Throwable)e);
            return this.getDefaultExecTime();
        }
    }

    private String getCreditFileExecTimeFromTask() {
        String execTimeStr = TaskParamControlUtil.querySscParam((String)"creditFilesExecTime");
        if (StringUtils.isEmpty((CharSequence)execTimeStr)) {
            log.error("task parameter \"creditfilesexectime\" not exist or is empty");
            return this.getDefaultExecTime();
        }
        try {
            Date execTime = this.dateFormat.parse(execTimeStr);
            return this.dateFormat.format(execTime);
        }
        catch (ParseException e) {
            log.error("task parameter \"creditfilesexectime\" parse error", (Throwable)e);
            return this.getDefaultExecTime();
        }
    }

    private String getDefaultExecTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, calendar.get(5) - 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return this.dateFormat.format(calendar.getTime());
    }

    private List<Object[]> buildParamList(Map<Long, Map<String, Object>> userInfoMap) {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(8);
        if (userInfoMap.size() > 0) {
            for (Map.Entry<Long, Map<String, Object>> entry : userInfoMap.entrySet()) {
                Object[] paramArr = new Object[3];
                Map<String, Object> tempMap = entry.getValue();
                paramArr[0] = tempMap.get("dptId");
                if (paramArr[0] == null) {
                    log.warn(String.format("%s dptId is empty.", entry.getKey()));
                    paramArr[0] = 0L;
                }
                paramArr[1] = tempMap.get("companyId");
                if (paramArr[1] == null) {
                    log.warn(String.format("%s companyId is empty.", entry.getKey()));
                    paramArr[1] = 0L;
                }
                paramArr[2] = entry.getKey();
                paramList.add(paramArr);
            }
        }
        return paramList;
    }

    private void writeBackExecTime() {
        HashMap<String, Date> params = new HashMap<String, Date>(2);
        params.put("creditfilesexectime", new Date());
        SystemParamServiceHelper.saveAppParameter((String)"1ZH12M=M8H7O", (String)"15", (Long)OrgUnitServiceHelper.getRootOrgId(), (Long)0L, params);
    }
}

