/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fircm.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fircm.business.factory.credit.CreditLevelSerivceFactory;
import kd.fi.fircm.business.helper.CreditModifyLogServiceHelper;
import kd.fi.fircm.business.service.credit.CreditLevelSerivce;

public class CreditfilesEditPlugin
extends AbstractBillPlugIn
implements ClickListener,
BeforeF7SelectListener {
    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"save"});
        this.addClickListeners(new String[]{"bar_searchchangelog"});
        this.initControlState();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit level = (BasedataEdit)this.getControl("creditlevel");
        level.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    private void initControlState() {
        FormShowParameter param = this.getView().getFormShowParameter();
        Map map = param.getCustomParams();
        String fromwhere = String.valueOf(map.get("fromwhere"));
        String pageId = String.valueOf(map.get("pageid"));
        if ("tasklist".equals(fromwhere)) {
            IFormView parentView = this.getView().getViewNoPlugin(pageId);
            String appid = parentView.getFormShowParameter().getAppId();
            if ("ssc".equalsIgnoreCase(appid)) {
                Object adminTaskFlag = parentView.getParentView().getFormShowParameter().getCustomParam("ismanagepage");
                if (adminTaskFlag != null && "ismanagepage".equalsIgnoreCase(adminTaskFlag.toString())) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"save"});
                } else {
                    param.setStatus(OperationStatus.EDIT);
                }
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"save"});
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        boolean hasPermission;
        String opeKey;
        super.beforeDoOperation(e);
        Object source = e.getSource();
        if (source instanceof Save) {
            boolean hasPermission2;
            String opeKey2 = ((Save)source).getOperateKey();
            if ("save".equals(opeKey2) && !(hasPermission2 = this.checkSavePermission())) {
                e.setCancel(true);
            }
        } else if (source instanceof Donothing && "donothing_changelog".equals(opeKey = ((Donothing)source).getOperateKey()) && !(hasPermission = this.checkChangeLogPermission())) {
            e.setCancel(true);
        }
    }

    private boolean checkSavePermission() {
        String appId;
        Long userId = RequestContext.get().getCurrUserId();
        boolean hasPermission = PermissionServiceHelper.checkPermission((Long)userId, (String)(appId = AppMetadataCache.getAppInfo((String)"fircm").getId()), (String)"fircm_creditfile_treelist", (String)"0=KX5+QVF5+R");
        if (!hasPermission) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u4fe1\u7528\u6863\u6848\u5217\u8868\u201d\u7684\u201c\u4fdd\u5b58\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CreditfilesEditPlugin_1", (String)"fi-fircm-formplugin", (Object[])new Object[0]));
        }
        return hasPermission;
    }

    private boolean checkChangeLogPermission() {
        String appId;
        Long userId = RequestContext.get().getCurrUserId();
        boolean hasPermission = PermissionServiceHelper.checkPermission((Long)userId, (String)(appId = AppMetadataCache.getAppInfo((String)"fircm").getId()), (String)"fircm_creditfile_treelist", (String)"1FJ194L33FM6");
        if (!hasPermission) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u4fe1\u7528\u6863\u6848\u5217\u8868\u201d\u7684\u201c\u53d8\u66f4\u8bb0\u5f55\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CreditfilesListPlugin_14", (String)"fi-fircm-formplugin", (Object[])new Object[0]));
        }
        return hasPermission;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] cd = e.getChangeSet();
        if (cd[0].getNewValue() == null) {
            return;
        }
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if ("creditlevel".equals(key)) {
            DynamicObject level = (DynamicObject)cd[0].getNewValue();
            BigDecimal defaultvalue = level.getBigDecimal("defaultvalue");
            model.beginInit();
            model.setValue("creditvalue", (Object)defaultvalue);
            model.endInit();
            view.updateView("creditvalue");
        } else if ("creditvalue".equals(key)) {
            CreditLevelSerivce serivce = CreditLevelSerivceFactory.newInstance();
            Map scoreRange = serivce.getCreditScoreRange();
            int min = (Integer)scoreRange.get("min");
            int max = (Integer)scoreRange.get("max");
            BigDecimal inputVal = (BigDecimal)cd[0].getNewValue();
            if (inputVal.compareTo(BigDecimal.valueOf(min)) < 0 || inputVal.compareTo(BigDecimal.valueOf(max)) > 0) {
                model.beginInit();
                model.setValue("creditvalue", cd[0].getOldValue());
                model.endInit();
                view.updateView("creditvalue");
                String tips = ResManager.loadKDString((String)"\u4fe1\u7528\u5206\u6570\u8303\u56f4\u4e3a[%1$s,%2$s]\u3002", (String)"CreditfilesEditPlugin_0", (String)"fi-fircm-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(String.format(tips, min, max));
                return;
            }
            DynamicObject creditLevel = serivce.getCreditLevel(inputVal);
            model.beginInit();
            model.setValue("creditlevel", (Object)creditLevel);
            model.endInit();
            view.updateView("creditlevel");
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        BasedataEdit baseData = (BasedataEdit)e.getSource();
        String key = baseData.getKey();
        if ("creditlevel".equals(key)) {
            QFilter sscidFil = new QFilter("enable", "=", (Object)"1");
            ListShowParameter showParam = (ListShowParameter)e.getFormShowParameter();
            showParam.getListFilterParameter().setFilter(sscidFil);
        }
    }

    public void afterBindData(EventObject e) {
        boolean hasPermission;
        DynamicObject user;
        super.afterBindData(e);
        DynamicObject creditlevel = (DynamicObject)this.getModel().getValue("creditlevel");
        this.getPageCache().put("oldScore", this.getModel().getValue("creditvalue").toString());
        if (creditlevel != null) {
            this.getPageCache().put("oldLevel", creditlevel.getString("id"));
            this.getPageCache().put("oldLevelName", creditlevel.getString("name"));
        }
        if ((user = (DynamicObject)this.getModel().getValue("user")) == null) {
            return;
        }
        DynamicObject org = null;
        long userid = (Long)user.get("id");
        long orgid = UserServiceHelper.getUserMainOrgId((long)userid);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bos_org");
        if (orgid != 0L) {
            org = BusinessDataServiceHelper.loadSingle((Object)orgid, (DynamicObjectType)type);
        }
        Image applierPic = (Image)this.getControl("applierpic");
        Map userAvatarPathMap = UserServiceHelper.getUserAvatarPath(Collections.singletonList(userid), (boolean)true);
        String imgURL = (String)userAvatarPathMap.get(userid);
        if (StringUtils.isBlank((String)imgURL)) {
            applierPic.setUrl("/images/pc/emotion/default_person_82_82.png");
        } else {
            applierPic.setUrl(imgURL);
        }
        ((Label)this.getControl("applierv")).setText(user.getString("name"));
        ((Label)this.getControl("orgv")).setText(org == null ? null : org.getString("name"));
        ((Label)this.getControl("telv")).setText(user.getString("phone"));
        String job = UserServiceHelper.getUserMainJob((long)userid);
        ((Label)this.getControl("applierpositionv")).setText(job);
        this.getModel().setValue("mulilangtextfield", null);
        Long userId = RequestContext.get().getCurrUserId();
        String appId = AppMetadataCache.getAppInfo((String)"fircm").getId();
        boolean hasSavePermission = PermissionServiceHelper.checkPermission((Long)userId, (String)appId, (String)"fircm_creditfile_treelist", (String)"0=KX5+QVF5+R");
        if (!hasSavePermission) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"flexpanelap9"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"save"});
        }
        if (!(hasPermission = PermissionServiceHelper.checkPermission((Long)userId, (String)appId, (String)"fircm_creditfile_treelist", (String)"1FJ194L33FM6"))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_searchchangelog"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        OperationResult opResult;
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if ("save".equals(key)) {
            OperationResult opResult2 = e.getOperationResult();
            if (opResult2.isSuccess()) {
                DynamicObject newLevel = (DynamicObject)this.getModel().getValue("creditlevel");
                BigDecimal newScore = (BigDecimal)this.getModel().getValue("creditvalue");
                DynamicObject user = (DynamicObject)this.getModel().getValue("user");
                BigDecimal oldScore = this.getPageCache().get("oldScore") == null ? null : new BigDecimal(this.getPageCache().get("oldScore"));
                Long oldLevelId = Long.valueOf(this.getPageCache().get("oldLevel"));
                char type = this.judgeType(newLevel.getLong("id"), oldLevelId, newScore, oldScore);
                if (type == '0') {
                    return;
                }
                String mulilangtextfield = String.valueOf(this.getModel().getValue("mulilangtextfield"));
                String desciption = StringUtils.isNull((String)mulilangtextfield) ? "" : mulilangtextfield;
                HashMap<String, Object> params = new HashMap<String, Object>(10);
                params.put("raiser", user.getLong("id"));
                params.put("modifytype", Character.valueOf(type));
                params.put("modifysource", Character.valueOf('1'));
                params.put("oldlevel", this.getPageCache().get("oldLevelName"));
                params.put("newlevel", newLevel.getString("name"));
                params.put("oldgrade", oldScore);
                params.put("newgrade", newScore);
                params.put("description", desciption);
                CreditModifyLogServiceHelper.writeModifyLog(params);
            }
        } else if ("donothing_changelog".equals(key) && (opResult = e.getOperationResult()).isSuccess()) {
            this.openCreditChangeLogForm();
        }
    }

    private char judgeType(Long newLevel, Long oldLevel, BigDecimal newScore, BigDecimal oldScore) {
        if (newLevel == null || oldLevel == null || newScore == null || oldScore == null) {
            return '0';
        }
        if (newScore.compareTo(oldScore) < 0) {
            return newLevel.compareTo(oldLevel) == 0 ? (char)'4' : '2';
        }
        if (newScore.compareTo(oldScore) > 0) {
            return newLevel.compareTo(oldLevel) == 0 ? (char)'3' : '1';
        }
        return '0';
    }

    private void openCreditChangeLogForm() {
        DynamicObject user = (DynamicObject)this.getModel().getValue("user");
        Long userid = user.getLong("id");
        QFilter userFil = new QFilter("raiser", "=", (Object)userid);
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("task_creditmodifyrecord");
        showParameter.setFormId("bos_list");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(userFil);
        showParameter.getListFilterParameter().setQFilters(qFilters);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setShowClose(false);
        showParameter.setShowFilter(false);
        showParameter.setShowQuickFilter(false);
        showParameter.setHasRight(true);
        showParameter.setShowTitle(false);
        showParameter.setCustomParam("Creditfiles", (Object)"CreditfilesEdit");
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String mulilangtextfield = this.getModel().getDataEntity().getLocaleString("mulilangtextfield").getLocaleValue();
        if (StringUtils.isEmpty((String)mulilangtextfield)) {
            e.setCheckDataChange(Boolean.FALSE.booleanValue());
        }
    }
}

