/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fircm.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.listop.ExportList;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.fircm.business.factory.credit.CreditLevelSerivceFactory;
import kd.fi.fircm.business.service.credit.CreditLevelSerivce;

public class CreditfilesListPlugin
extends AbstractListPlugin
implements ClickListener,
ItemClickListener {
    private static final Log log = LogFactory.getLog(CreditfilesListPlugin.class);
    private static final String CREDIT_FILE_LIST = "fircm_creditfile_treelist";

    public void initialize() {
        super.initialize();
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("bar_changeloglist".equals(itemKey)) {
            // empty if block
        }
    }

    private void changeLogList() {
        ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
        int size = selectedRows.size();
        if (size == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8981\u67e5\u770b\u53d8\u66f4\u8bb0\u5f55\u7684\u7528\u6237\u3002", (String)"CreditfilesListPlugin_12", (String)"fi-fircm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (size > 1000) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6570\u636e\u8d85\u8fc71000\u884c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"CreditfilesListPlugin_13", (String)"fi-fircm-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<Long> creditFilesIds = new ArrayList<Long>(8);
        for (ListSelectedRow row : selectedRows) {
            creditFilesIds.add((Long)row.getPrimaryKeyValue());
        }
        DynamicObjectCollection creditFilesList = this.getCreditFiles(creditFilesIds);
        if (CollectionUtils.isEmpty((Collection)creditFilesList)) {
            return;
        }
        ArrayList<Long> userIds = new ArrayList<Long>(8);
        ArrayList<String> userNumbers = new ArrayList<String>(8);
        for (DynamicObject dynObj : creditFilesList) {
            userIds.add(dynObj.getLong("userid"));
            userNumbers.add(dynObj.getString("usernumber"));
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>(8);
        paramMap.put("userid", userIds);
        paramMap.put("usernumber", userNumbers);
        paramMap.put("Creditfiles", "creditfileslist_btn");
        this.openCreditChangeLogForm(paramMap);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        boolean hasPermission;
        String opeKey;
        super.beforeDoOperation(e);
        Object source = e.getSource();
        if (source instanceof Donothing) {
            boolean hasPermission2;
            String opeKey2 = ((Donothing)source).getOperateKey();
            if ("donothing_initialization".equals(opeKey2)) {
                String userId = RequestContext.get().getUserId();
                try {
                    boolean checkResult = PermissionServiceHelper.checkPermission((Long)Long.parseLong(userId), (String)"fircm", (String)CREDIT_FILE_LIST, (String)"0K6+MBJG6TZL");
                    if (!checkResult) {
                        e.setCancel(true);
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u4fe1\u7528\u6863\u6848\u5217\u8868\u201d\u7684\u201c\u521d\u59cb\u5316\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CreditfilesListPlugin_10", (String)"fi-fircm-formplugin", (Object[])new Object[0]));
                    }
                }
                catch (Exception error) {
                    e.setCancel(true);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u4fe1\u7528\u6863\u6848\u5217\u8868\u201d\u7684\u201c\u521d\u59cb\u5316\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CreditfilesListPlugin_10", (String)"fi-fircm-formplugin", (Object[])new Object[0]));
                }
            } else if ("donothing_changeloglist".equals(opeKey2) && !(hasPermission2 = this.checkChangeLogPermission())) {
                e.setCancel(true);
            }
        } else if (source instanceof ExportList && "exportlistbyselectfields".equals(opeKey = ((ExportList)source).getOperateKey()) && !(hasPermission = this.checkExportPermission())) {
            e.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if (e.getOperationResult() != null && e.getOperationResult().isSuccess()) {
            if ("donothing_initialization".equals(key)) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("callBackId", (IFormPlugin)this);
                QFilter statusFilter = new QFilter("status", "!=", (Object)Character.valueOf('D'));
                if (!QueryServiceHelper.exists((String)"task_creditfiles", (QFilter[])new QFilter[]{statusFilter})) {
                    this.getPageCache().put("prompt", "2");
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u4fe1\u7528\u6863\u6848\uff0c\u5c06\u4f1a\u521d\u59cb\u5316\u6240\u6709\u7528\u6237\u4fe1\u7528\u6570\u636e\uff0c\u786e\u8ba4\u8981\u521d\u59cb\u5316\u5417\uff1f", (String)"CreditfilesListPlugin_0", (String)"fi-fircm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBacks);
                } else {
                    if (this.getPageCache().get("prompt") == null) {
                        this.getPageCache().put("prompt", "0");
                    }
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u4fe1\u7528\u6863\u6848\uff0c\u5c06\u4f1a\u521d\u59cb\u5316\u6240\u6709\u7528\u6237\u4fe1\u7528\u6570\u636e\uff0c\u786e\u8ba4\u8981\u521d\u59cb\u5316\u5417\uff1f", (String)"CreditfilesListPlugin_0", (String)"fi-fircm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBacks);
                }
            } else if ("donothing_changeloglist".equals(key)) {
                this.changeLogList();
            }
        }
    }

    private boolean checkChangeLogPermission() {
        String appId;
        Long userId = RequestContext.get().getCurrUserId();
        boolean hasPermission = PermissionServiceHelper.checkPermission((Long)userId, (String)(appId = AppMetadataCache.getAppInfo((String)"fircm").getId()), (String)CREDIT_FILE_LIST, (String)"1FJ194L33FM6");
        if (!hasPermission) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u4fe1\u7528\u6863\u6848\u5217\u8868\u201d\u7684\u201c\u53d8\u66f4\u8bb0\u5f55\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CreditfilesListPlugin_14", (String)"fi-fircm-formplugin", (Object[])new Object[0]));
        }
        return hasPermission;
    }

    private boolean checkExportPermission() {
        String appId;
        Long userId = RequestContext.get().getCurrUserId();
        boolean hasPermission = PermissionServiceHelper.checkPermission((Long)userId, (String)(appId = AppMetadataCache.getAppInfo((String)"fircm").getId()), (String)CREDIT_FILE_LIST, (String)"4730fc9f000004ae");
        if (!hasPermission) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u4fe1\u7528\u6863\u6848\u5217\u8868\u201d\u7684\u201c\u5f15\u51fa\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CreditfilesListPlugin_15", (String)"fi-fircm-formplugin", (Object[])new Object[0]));
        }
        return hasPermission;
    }

    private DynamicObjectCollection getCreditFiles(List<Long> creditFileIds) {
        String selectFields = "id, user.id userid, user.name username,user.number usernumber";
        QFilter filter = new QFilter("id", "in", creditFileIds);
        QFilter statusFilter = new QFilter("status", "!=", (Object)Character.valueOf('D'));
        return QueryServiceHelper.query((String)"task_creditfiles", (String)selectFields, (QFilter[])new QFilter[]{filter, statusFilter}, null);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        int result = e.getResult().getValue();
        if (result == MessageBoxResult.Yes.getValue()) {
            if (Long.parseLong(this.getPageCache().get("prompt")) != 2L) {
                this.getPageCache().put("prompt", Long.parseLong(this.getPageCache().get("prompt")) + 1L + "");
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("callBackId", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u4fe1\u7528\u6863\u6848\uff0c\u5c06\u4f1a\u521d\u59cb\u5316\u6240\u6709\u7528\u6237\u4fe1\u7528\u6570\u636e\uff0c\u786e\u8ba4\u8981\u521d\u59cb\u5316\u5417\uff1f", (String)"CreditfilesListPlugin_0", (String)"fi-fircm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBacks);
            } else {
                boolean initResult = this.initialization();
                if (initResult) {
                    this.getView().updateView();
                }
                this.getPageCache().put("prompt", "0");
            }
        } else {
            this.getPageCache().put("prompt", "0");
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String name = args.getHyperLinkClickEvent().getFieldName();
        if ("user_name".equals(name)) {
            return;
        }
        int rowIndex = args.getHyperLinkClickEvent().getRowIndex();
        ListSelectedRowCollection selectedRows = ((BillList)this.getView().getControl("billlistap")).getSelectedRows();
        Long rowId = this.getSelectRowId(selectedRows, rowIndex);
        DynamicObject creditFile = this.getCreditFileObj(rowId);
        if (creditFile == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6863\u6848\u4e0d\u5b58\u5728\u3002", (String)"CreditfilesListPlugin_2", (String)"fi-fircm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        String userNumber = creditFile.getString("user.number");
        long userid = creditFile.getLong("user.id");
        long deptid = creditFile.getLong("dept.id");
        HashMap<String, Object> paramMap = new HashMap<String, Object>(8);
        if ("unqualifiedtotalnum".equalsIgnoreCase(name)) {
            paramMap.put("modifytype", Arrays.asList("2", "4"));
            paramMap.put("modifysource", Arrays.asList("2", "3", "4"));
        } else {
            paramMap.put("modifytype", Arrays.asList("1", "3"));
            paramMap.put("modifysource", Collections.singletonList("2"));
        }
        paramMap.put("raiser", userid);
        paramMap.put("dept", deptid);
        paramMap.put("Creditfiles", "creditfilesList_link");
        paramMap.put("usernumber", userNumber);
        this.openCreditChangeLogForm(paramMap);
        args.setCancel(true);
    }

    private boolean initialization() {
        IFormView view = this.getView();
        CreditLevelSerivce service = CreditLevelSerivceFactory.newInstance();
        DynamicObject defaultLevel = service.getDefaultLevel();
        if (defaultLevel == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u4fe1\u7528\u7b49\u7ea7\u4e2d\u914d\u7f6e\u9ed8\u8ba4\u7b49\u7ea7\u3002", (String)"CreditfilesListPlugin_3", (String)"fi-fircm-formplugin", (Object[])new Object[0]));
            return false;
        }
        boolean initResult = true;
        try (TXHandle h = TX.requiresNew((String)"ssc_credit_init");){
            try {
                this.updateCreditModifyLog();
                this.initCreditFiles(defaultLevel);
            }
            catch (Throwable e) {
                h.markRollback();
                view.showConfirm(ResManager.loadKDString((String)"\u4fe1\u7528\u6863\u6848\u521d\u59cb\u5316\u5f02\u5e38\uff0c\u8bf7\u91cd\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CreditfilesListPlugin_7", (String)"fi-fircm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
                log.error(" creditfile initialization failed: ", e);
                initResult = false;
            }
        }
        return initResult;
    }

    private void initCreditFiles(DynamicObject defaultLevel) {
        QFilter statusFilter = new QFilter("status", "!=", (Object)Character.valueOf('D'));
        DeleteServiceHelper.delete((String)"task_creditfiles", (QFilter[])new QFilter[]{statusFilter});
        QFilter partJobFil = new QFilter("entryentity.ispartjob", "=", (Object)Boolean.FALSE);
        QFilter enableFil = new QFilter("enable", "=", (Object)Boolean.TRUE);
        String algoKey = ((Object)((Object)this)).getClass() + ".getAllUsersOfOrg()";
        try (DataSet userDSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"bos_user", (String)"id,entryentity.dpt dpt", (QFilter[])new QFilter[]{partJobFil, enableFil}, null);){
            HashMap<Long, Set<Long>> orgUserMap = new HashMap<Long, Set<Long>>(8);
            if (!userDSet.hasNext()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u4e2d\u6ca1\u6709\u4e3b\u804c\u4eba\u5458\u3002", (String)"CreditfilesListPlugin_11", (String)"fi-fircm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            }
            for (Row row : userDSet) {
                Long userId = row.getLong("id");
                Long dptId = row.getLong("dpt");
                HashSet<Long> userIds = (HashSet<Long>)orgUserMap.get(dptId);
                if (CollectionUtils.isEmpty((Collection)userIds)) {
                    userIds = new HashSet<Long>(128);
                    userIds.add(userId);
                    orgUserMap.put(dptId, userIds);
                    continue;
                }
                userIds.add(userId);
                if (userIds.size() != 1000) continue;
                this.createCreditFiles(defaultLevel, userIds, dptId);
                userIds.clear();
            }
            if (!CollectionUtils.isEmpty(orgUserMap)) {
                this.createCreditFiles(defaultLevel, orgUserMap);
            }
        }
    }

    private void createCreditFiles(DynamicObject defaultLevel, Set<Long> userIds, Long deptId) {
        log.error(((Object)((Object)this)).getClass().getName() + " start createCreditFiles by userIds");
        ArrayList<DynamicObject> creditFiles = new ArrayList<DynamicObject>(128);
        ArrayList<DynamicObject> creditLogs = new ArrayList<DynamicObject>(128);
        Map companysOfUsers = UserServiceHelper.getCompanyByUserIds(new ArrayList<Long>(userIds));
        for (Long userId : userIds) {
            DynamicObject creditFile = this.buildCreditFile(userId, deptId, defaultLevel, (Long)companysOfUsers.get(userId));
            DynamicObject creditLog = this.buildCreditModifyLog(userId, deptId, defaultLevel.getString("name"), defaultLevel.getBigDecimal("defaultvalue"), (Long)companysOfUsers.get(userId));
            creditFiles.add(creditFile);
            creditLogs.add(creditLog);
        }
        if (creditFiles.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])creditFiles.toArray(new DynamicObject[0]));
        }
        if (creditLogs.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])creditLogs.toArray(new DynamicObject[0]));
        }
        log.error(((Object)((Object)this)).getClass().getName() + " end createCreditFiles by userIds");
    }

    private void createCreditFiles(DynamicObject defaultLevel, Map<Long, Set<Long>> orgUserMap) {
        ArrayList<DynamicObject> creditFiles = new ArrayList<DynamicObject>(128);
        ArrayList<DynamicObject> creditLogs = new ArrayList<DynamicObject>(128);
        String levelName = defaultLevel.getString("name");
        BigDecimal defaultVal = defaultLevel.getBigDecimal("defaultvalue");
        for (Map.Entry<Long, Set<Long>> entry : orgUserMap.entrySet()) {
            Long dptId = entry.getKey();
            Set<Long> userIds = entry.getValue();
            if (CollectionUtils.isEmpty(userIds)) continue;
            Map companysOfUsers = UserServiceHelper.getCompanyByUserIds(new ArrayList<Long>(userIds));
            for (Long userId : userIds) {
                DynamicObject creditFile = this.buildCreditFile(userId, dptId, defaultLevel, (Long)companysOfUsers.get(userId));
                DynamicObject creditLog = this.buildCreditModifyLog(userId, dptId, levelName, defaultVal, (Long)companysOfUsers.get(userId));
                creditFiles.add(creditFile);
                creditLogs.add(creditLog);
                if (creditFiles.size() != 1000) continue;
                SaveServiceHelper.save((DynamicObject[])creditFiles.toArray(new DynamicObject[1000]));
                SaveServiceHelper.save((DynamicObject[])creditLogs.toArray(new DynamicObject[1000]));
                creditFiles.clear();
                creditLogs.clear();
            }
        }
        if (creditFiles.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])creditFiles.toArray(new DynamicObject[creditFiles.size()]));
        }
        if (creditLogs.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])creditLogs.toArray(new DynamicObject[creditLogs.size()]));
        }
    }

    private void openCreditChangeLogForm(Map<String, Object> paramMap) {
        ListShowParameter listShowParam = new ListShowParameter();
        listShowParam.setBillFormId("task_creditmodifylog");
        listShowParam.setFormId("bos_list");
        listShowParam.setCustomParams(paramMap);
        listShowParam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)listShowParam);
    }

    private Long getSelectRowId(ListSelectedRowCollection selectedRows, int rowIndex) {
        for (int i = 0; i < selectedRows.size(); ++i) {
            ListSelectedRow listSelectedRow = selectedRows.get(i);
            int rowKey = listSelectedRow.getRowKey();
            if (rowIndex != rowKey) continue;
            return Long.valueOf(selectedRows.get(i).getPrimaryKeyValue() + "");
        }
        return 0L;
    }

    private DynamicObject getCreditFileObj(Long id) {
        QFilter filter = new QFilter("id", "=", (Object)id);
        QFilter statusFilter = new QFilter("status", "!=", (Object)Character.valueOf('D'));
        return QueryServiceHelper.queryOne((String)"task_creditfiles", (String)"id,user.name,user.id,user.number,dept.id,dept.name,company.id,company.name", (QFilter[])new QFilter[]{filter, statusFilter});
    }

    private DynamicObject buildCreditFile(Long userId, Long deptId, DynamicObject defaultLevel, Long companyId) {
        DynamicObject creditFile = BusinessDataServiceHelper.newDynamicObject((String)"task_creditfiles");
        creditFile.set("user", (Object)userId);
        creditFile.set("creditlevel", defaultLevel.get("id"));
        creditFile.set("creditvalue", defaultLevel.get("defaultvalue"));
        creditFile.set("enable", (Object)Character.valueOf('1'));
        creditFile.set("status", (Object)Character.valueOf('C'));
        Date date = new Date();
        creditFile.set("createtime", (Object)date);
        creditFile.set("modifytime", (Object)date);
        creditFile.set("dept", (Object)deptId);
        creditFile.set("company", (Object)companyId);
        return creditFile;
    }

    private DynamicObject buildCreditModifyLog(Long userId, Long deptId, String newLevel, BigDecimal newScore, Long companyId) {
        DynamicObject modifyLog = BusinessDataServiceHelper.newDynamicObject((String)"task_creditmodifylog");
        modifyLog.set("raiser", (Object)userId);
        modifyLog.set("enable", (Object)Character.valueOf('1'));
        modifyLog.set("status", (Object)Character.valueOf('C'));
        modifyLog.set("company", (Object)companyId);
        modifyLog.set("dept", (Object)deptId);
        modifyLog.set("modifytype", (Object)"");
        modifyLog.set("modifysource", (Object)"0");
        modifyLog.set("newlevel", (Object)newLevel);
        modifyLog.set("newgrade", (Object)newScore);
        modifyLog.set("changedscore", (Object)newScore.subtract(BigDecimal.ZERO));
        modifyLog.set("billtopic", (Object)"");
        String logDesc = ResManager.loadKDString((String)"\u521d\u59cb\u5316(%1$s\u4fee\u6539)", (String)"CreditfilesListPlugin_5", (String)"fi-fircm-formplugin", (Object[])new Object[0]);
        modifyLog.set("description", (Object)String.format(logDesc, RequestContext.get().getUserName()));
        modifyLog.set("modifydate", (Object)new Date());
        return modifyLog;
    }

    private void updateCreditModifyLog() {
        String sql = "update t_tk_creditmodifylog set fstatus = 'D' where fstatus != 'D'";
        DB.execute((DBRoute)DBRoute.of((String)"ssc"), (String)sql, (Object[])new Object[0]);
    }
}

