/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fircm.formplugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.org.model.OrgTreeSearchParam;
import kd.bos.org.utils.OrgTreeUtils;
import kd.bos.org.utils.OrgViewUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.sec.user.utils.UserOperationUtils;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.fircm.task.util.FircmLicenseUtil;

public class CreditfilesTreeListPlugin
extends StandardTreeListPlugin
implements ListRowClickListener {
    private static final Log log = LogFactory.getLog(CreditfilesTreeListPlugin.class);
    private static final String NO_ORG = "noOrg";
    private String NODE_NAME_UNKNOWN = ResManager.loadKDString((String)"\u672a\u5206\u914d\u90e8\u95e8", (String)"CreditfilesTreeListPlugin_0", (String)"bos-sec-user", (Object[])new Object[0]);

    public void preOpenForm(PreOpenFormEventArgs e) {
        FircmLicenseUtil.checkGroupLicense((PreOpenFormEventArgs)e);
    }

    public void initializeTree(EventObject e) {
        OrgTreeParam param = new OrgTreeParam();
        TreeNode root = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)param);
        if (root == null) {
            param.setId(0L);
            root = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)param);
        }
        this.initRootNode(root);
    }

    private void initRootNode(TreeNode root) {
        if (root == null) {
            return;
        }
        root.setChildren(new ArrayList(0));
        this.getTreeModel().setRoot(root);
        String rootId = root.getId();
        this.getTreeModel().setCurrentNodeId((Object)rootId);
    }

    public void refreshNode(RefreshNodeEvent e) {
        String nodeId = e.getNodeId().toString();
        if (!NO_ORG.equalsIgnoreCase(nodeId)) {
            boolean isRootNode = nodeId.equals(this.getTreeModel().getRoot().getId());
            OrgTreeParam param = new OrgTreeParam();
            param.setId(Long.parseLong(nodeId));
            param.setIncludeFreeze(false);
            param.setOrgRangeList(UserOperationUtils.getAdminChargeOrgs((ListShowParameter)((ListShowParameter)this.getView().getFormShowParameter()), (IPageCache)this.getPageCache()));
            List treeNodes = OrgUnitServiceHelper.getTreeChildren((OrgTreeParam)param);
            if (isRootNode) {
                TreeNode noOrgNode = new TreeNode(nodeId, NO_ORG, this.NODE_NAME_UNKNOWN, false);
                treeNodes.add(noOrgNode);
            }
            e.setChildNodes(treeNodes);
        }
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        e.setCancel(true);
        String nodeId = e.getNodeId().toString();
        QFilter treeListFilter = null;
        if (NO_ORG.equals(nodeId)) {
            treeListFilter = new QFilter("dept", "=", (Object)0);
        } else {
            long orgId = Long.parseLong(nodeId);
            if (Boolean.parseBoolean(this.getModel().getValue("chkincludechild").toString())) {
                if (OrgUnitServiceHelper.getRootOrgId() != orgId) {
                    treeListFilter = this.getNotRootNodeFilter(orgId);
                }
            } else {
                treeListFilter = new QFilter("dept", "=", (Object)orgId);
            }
        }
        if (treeListFilter != null) {
            e.addQFilter(treeListFilter);
        }
    }

    private QFilter getNotRootNodeFilter(long orgId) {
        ArrayList<Long> orgIds = new ArrayList<Long>(1);
        orgIds.add(orgId);
        List orgIncludeSubs = OrgViewUtils.getSubOrgIdIncludeGrand((String)"01", orgIds, (boolean)true, (QFilter)null);
        if (Objects.isNull(orgIncludeSubs)) {
            orgIncludeSubs = Collections.emptyList();
        }
        QFilter treeListFilter = new QFilter("dept", "in", orgIncludeSubs);
        return treeListFilter;
    }

    public void search(SearchEnterEvent evt) {
        if (StringUtils.isBlank((CharSequence)evt.getText())) {
            return;
        }
        OrgTreeSearchParam searchParam = new OrgTreeSearchParam(evt.getText(), (ListView)this.getView(), "01");
        searchParam.setClickNode(true);
        OrgTreeUtils.searchFromLazyOrgTree((OrgTreeSearchParam)searchParam);
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String nodeId = e.getNodeId().toString();
        if (this.getNode(nodeId) != null) {
            this.treeListView.getTreeView().queryTreeNodeChildren(e.getParentNodeId().toString(), nodeId);
        }
    }

    private TreeNode getNode(Object nodeId) {
        return OrgTreeUtils.getNode((Object)nodeId, (ITreeModel)this.getTreeModel());
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.getQFilters().add(new QFilter("status", "!=", (Object)Character.valueOf('D')));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        TreeView tv;
        Map focusMap;
        String proName = e.getProperty().getName();
        if ("chkincludechild".equals(proName) && (focusMap = (tv = this.treeListView.getTreeView()).getTreeState().getFocusNode()) != null) {
            tv.treeNodeClick(String.valueOf(focusMap.get("parentid")), String.valueOf(focusMap.get("id")));
        }
    }
}

