/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fircm.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.fircm.business.helper.CreditServiceHelper;

public class MyCreditEquityPlugin
extends AbstractFormPlugin {
    private static final String MAIN_ORG_CREDIT_SETTING = "mainOrgCreditSetting";
    private static final String EQUITY_LEVEL_NUMBER = "curLevelNumber";
    private static final String EQUITY_AREA = "equityarea";
    private static final String EQUITY_REMARK_TEXT = "equityremark";
    private static final String EQUITY_ENTRY_ENTITY = "equityentryentity";
    private static final String ATTENTION_POINT = "attentionpoint";
    private static final String ORG_NAME = "orgName";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{ATTENTION_POINT});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        long currUserId = RequestContext.get().getCurrUserId();
        long mainOrgId = UserServiceHelper.getUserMainOrgId((long)currUserId);
        String equityLevelNumber = this.getPageCache().get(EQUITY_LEVEL_NUMBER);
        if (kd.bos.util.StringUtils.isNotEmpty((String)equityLevelNumber)) {
            DynamicObject orgCreditSetting = CreditServiceHelper.queryCreditSettingByOrgId((Long)mainOrgId);
            if (orgCreditSetting != null) {
                this.setEquityRemark(equityLevelNumber, orgCreditSetting);
            } else {
                this.setEquityAreaHiddenAndShowTips(true);
            }
        } else {
            this.setEquityAreaHiddenAndShowTips(false);
        }
    }

    private void setEquityRemark(String equityLevelNumber, DynamicObject orgCreditSetting) {
        Map<String, List<String>> equityGroup = this.groupEquityRemarkByLevel(orgCreditSetting);
        this.getPageCache().put(MAIN_ORG_CREDIT_SETTING, SerializationUtils.toJsonString(equityGroup));
        this.getPageCache().put(ATTENTION_POINT, orgCreditSetting.getString(ATTENTION_POINT));
        this.getPageCache().put(ORG_NAME, orgCreditSetting.getDynamicObject("createOrg").getString("name"));
        if (equityGroup.containsKey(equityLevelNumber)) {
            DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity(EQUITY_ENTRY_ENTITY);
            DynamicObjectType dynamicObjectType = dynamicObjectCollection.getDynamicObjectType();
            for (String equityRemark : equityGroup.get(equityLevelNumber)) {
                DynamicObject dynamicObject = new DynamicObject(dynamicObjectType);
                dynamicObject.set(EQUITY_REMARK_TEXT, (Object)equityRemark);
                dynamicObjectCollection.add((Object)dynamicObject);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        String key = ctl.getKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)ATTENTION_POINT)) {
            String attentionPoint = this.getPageCache().get(ATTENTION_POINT);
            if (kd.bos.util.StringUtils.isBlank((String)attentionPoint)) {
                String orgName = this.getPageCache().get(ORG_NAME);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u672a\u914d\u7f6e\u6ce8\u610f\u4e8b\u9879\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MyCreditEquityPlugin_2", (String)"fi-fircm-formplugin", (Object[])new Object[0]), orgName));
            } else {
                FormShowParameter equityRemarkFormParameter = new FormShowParameter();
                equityRemarkFormParameter.setFormId("credit_attentionpoint");
                equityRemarkFormParameter.getOpenStyle().setShowType(ShowType.Modal);
                equityRemarkFormParameter.setCustomParam("attentionPoint", (Object)attentionPoint);
                equityRemarkFormParameter.setCaption(ResManager.loadKDString((String)"\u6ce8\u610f\u4e8b\u9879", (String)"MyCreditEquityPlugin_1", (String)"fi-fircm-formplugin", (Object[])new Object[0]));
                this.getView().showForm(equityRemarkFormParameter);
            }
        }
    }

    private Map<String, List<String>> groupEquityRemarkByLevel(DynamicObject orgCreditSetting) {
        DynamicObjectCollection equitySettingCollection = orgCreditSetting.getDynamicObjectCollection("entryentity");
        HashMap<String, List<String>> equityLevelMap = new HashMap<String, List<String>>();
        for (DynamicObject equitySetting : equitySettingCollection) {
            DynamicObject equityLevelDynamic = equitySetting.getDynamicObject("equitylevel");
            String equityLevel = equityLevelDynamic.getString("number");
            List<String> curLevelEquityRemark = null;
            if (equityLevelMap.containsKey(equityLevel)) {
                curLevelEquityRemark = (List)equityLevelMap.get(equityLevel);
            } else {
                curLevelEquityRemark = new ArrayList();
                equityLevelMap.put(equityLevel, curLevelEquityRemark);
            }
            curLevelEquityRemark.add(equitySetting.getString(EQUITY_REMARK_TEXT));
        }
        return equityLevelMap;
    }

    private void setEquityAreaHiddenAndShowTips(boolean hasCreditLevel) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{EQUITY_AREA});
        if (hasCreditLevel) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u4fe1\u7528\u7b49\u7ea7\u6743\u76ca\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MyCreditEquityPlugin_0", (String)"fi-fircm-formplugin", (Object[])new Object[0]));
        }
    }
}

