/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fircm.formplugin;

import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.FilterContainerInitListener;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.control.events.SearchClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.form.IFormController;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class MyCreditListPlugin
extends AbstractFormPlugin
implements FilterContainerInitListener,
SearchClickListener,
HyperLinkClickListener {
    private static final String BILLLISTAP = "billlistap";
    private static final String ENTITY_CREDITMODIFYLOG = "task_creditmodifylog";
    private static final String KEY_REFRESH = "refresh";
    private static final String KEY_ALLEGE = "allege";
    private static final String KEY_ALLEGERECORD = "allegerecord";
    private static final String[] legalArray = new String[]{"2", "3", "4", "5"};

    public void initialize() {
        super.initialize();
        FilterContainer fc = (FilterContainer)this.getControl("filtercontainerap");
        fc.setBillFormId(ENTITY_CREDITMODIFYLOG);
        fc.setEntityId(ENTITY_CREDITMODIFYLOG);
        fc.addFilterContainerInitListener((FilterContainerInitListener)this);
        fc.addSearchClickListener((SearchClickListener)this);
        fc.setNeedShareScheme(false);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        billList.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        Tips newTips = filterContainer.getCtlTips();
        newTips.setContent(ResManager.getLocaleString((String)"\u7528\u6237\u53ef\u67e5\u770b\u81ea\u5df1\u7684\u4fe1\u7528\u4fe1\u606f\uff0c\u5305\u62ec\u4fe1\u7528\u7b49\u7ea7\u3001\u4fe1\u7528\u5206\u3001\u4ee5\u53ca\u4e3b\u804c\u4f4d\u7ec4\u7ec7\u914d\u7f6e\u7684\u201c\u6211\u7684\u6743\u76ca\u201d\u548c\u201c\u6ce8\u610f\u4e8b\u9879\u201d\u3002\u7528\u6237\u4e5f\u53ef\u5bf9\u6709\u5f02\u8bae\u4fe1\u7528\u53d8\u66f4\u65e5\u5fd7\u53d1\u8d77\u7533\u8bc9\u3002", (String)"MyCreditListPlugin_4", (String)"fi-fircm-formplugin"));
        filterContainer.setCtlTips(newTips);
    }

    public void filterContainerInit(FilterContainerInitEvent evt) {
        this.setPreFilter();
        List schemeFilterColumns = evt.getSchemeFilterColumns();
        schemeFilterColumns.removeIf(f -> f.getFieldName().equals("dept.name"));
        List fastFilterColumns = evt.getFastFilterColumns();
        fastFilterColumns.removeIf(f -> f.getFieldName().equals("raiser.name") || f.getFieldName().equals("raiser.number"));
        FilterColumn billNoFilter = new FilterColumn("billno");
        LocaleString billNoLoStr = EntityMetadataCache.getDataEntityType((String)ENTITY_CREDITMODIFYLOG).getProperty("billno").getDisplayName();
        billNoFilter.setCaption(billNoLoStr);
        fastFilterColumns.add(billNoFilter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)KEY_ALLEGE)) {
            List<Object> selectedRowKeys = this.getSelectedRowKeys();
            if (!this.verSelectedCount(selectedRowKeys.size(), true)) {
                args.setCancel(true);
                return;
            }
            Long creditModifyLog = (Long)selectedRowKeys.get(0);
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)creditModifyLog, (String)ENTITY_CREDITMODIFYLOG);
            if (dynamicObject != null) {
                String status = dynamicObject.getString("status");
                if (status.equalsIgnoreCase("D")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7528\u6237\u4fe1\u7528\u6863\u6848\u5df2\u91cd\u65b0\u521d\u59cb\u5316\uff0c\u8be5\u4fe1\u7528\u53d8\u66f4\u65e5\u5fd7\u5df2\u4f5c\u5e9f\uff0c\u65e0\u6cd5\u7533\u8bc9\u3002", (String)"MyCreditListPlugin_6", (String)"fi-fircm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                String modifySource = dynamicObject.getString("modifysource");
                List<String> legalList = Arrays.asList(legalArray);
                if (!legalList.contains(modifySource)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u53d8\u66f4\u6765\u6e90\u4e3a\u5ba1\u6838\u3001\u5f71\u50cf\u8d85\u671f\u3001\u5171\u4eab\u8d28\u68c0\u4efb\u52a1\u3001\u4fe1\u7528\u7533\u8bc9\u7684\u4fe1\u7528\u53d8\u66f4\u65e5\u5fd7\u8fdb\u884c\u7533\u8bc9\u3002", (String)"MyCreditListPlugin_7", (String)"fi-fircm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                QFilter modifyLogFilter = new QFilter("creditmodifylogid", "=", (Object)creditModifyLog);
                QFilter statusFilter = new QFilter("billstatus", "in", (Object)new String[]{"B", "C"});
                boolean hasAppealingData = QueryServiceHelper.exists((String)"fircm_creditappeal", (QFilter[])new QFilter[]{modifyLogFilter, statusFilter});
                if (hasAppealingData) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5173\u8054\u4fe1\u7528\u53d8\u66f4\u65e5\u5fd7\u5df2\u53d1\u8d77\u4fe1\u7528\u7533\u8bc9\uff0c\u8bf7\u67e5\u770b\u7533\u8bc9\u8bb0\u5f55\u3002", (String)"MyCreditListPlugin_5", (String)"fi-fircm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
            }
        }
        super.beforeDoOperation(args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getOperationResult() != null && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            switch (afterDoOperationEventArgs.getOperateKey()) {
                case "refresh": {
                    this.refreshOp();
                    break;
                }
                case "allege": {
                    this.allegeOp();
                    break;
                }
                case "allegerecord": {
                    this.allegeRecordOp();
                    break;
                }
            }
        }
    }

    public void click(SearchClickEvent evt) {
        BillList list = (BillList)this.getControl(BILLLISTAP);
        List clientQFilter = evt.getFilterParameter().getQFilters();
        clientQFilter.addAll(list.getClientQueryFilterParameter().getQFilters());
        list.setClientQueryFilterParameter(new FilterParameter(clientQFilter, null));
        list.setQueryFilterParameter(new FilterParameter(evt.getFastQFilters(), null));
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        if (billList != null) {
            billList.clearSelection();
            billList.refresh();
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent args) {
        String fieldName = args.getFieldName();
        if (StringUtils.equals((CharSequence)"billno", (CharSequence)fieldName)) {
            int rowIndex = args.getRowIndex();
            ListSelectedRowCollection selectedRows = ((BillList)this.getView().getControl(BILLLISTAP)).getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)selectedRows)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u5fd7\u3002", (String)"MyCreditListPlugin_0", (String)"fi-fircm-formplugin", (Object[])new Object[0]));
                return;
            }
            Long rowID = this.getSelectRowId(selectedRows, rowIndex);
            if (rowID == null || rowID == 0L) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u65e5\u5fd7\u3002", (String)"MyCreditListPlugin_1", (String)"fi-fircm-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject logObj = this.getCreditModifyLog(rowID);
            if (logObj == null) {
                return;
            }
            String pkId = logObj.getString("billid");
            Long pkIdLong = 0L;
            try {
                pkIdLong = Long.valueOf(pkId);
            }
            catch (NumberFormatException e) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u67e5\u770b\u5f02\u6784\u7cfb\u7edf\u5355\u636e\u3002", (String)"MyCreditListPlugin_8", (String)"fi-fircm-formplugin", (Object[])new Object[0]));
                return;
            }
            String billEntity = logObj.getString("billentity").trim();
            BillShowParameter parameter = new BillShowParameter();
            parameter.setStatus(OperationStatus.VIEW);
            parameter.setBillStatus(BillOperationStatus.AUDIT);
            parameter.setHasRight(true);
            parameter.setPkId((Object)pkIdLong);
            parameter.setFormId(billEntity);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.addCustPlugin("kd.bos.ext.fircm.formplugin.CreditHideBillMenuPlugin");
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    private Long getSelectRowId(ListSelectedRowCollection selectedRows, int rowIndex) {
        for (int i = 0; i < selectedRows.size(); ++i) {
            ListSelectedRow listSelectedRow = selectedRows.get(i);
            int rowKey = listSelectedRow.getRowKey();
            if (rowIndex != rowKey) continue;
            return Long.valueOf(selectedRows.get(i).getPrimaryKeyValue().toString());
        }
        return null;
    }

    private DynamicObject getCreditModifyLog(Long rowID) {
        QFilter filter = new QFilter("id", "=", (Object)rowID);
        DynamicObject loObj = QueryServiceHelper.queryOne((String)ENTITY_CREDITMODIFYLOG, (String)"billtopic,billentity,billid", (QFilter[])new QFilter[]{filter});
        if (loObj == null) {
            return null;
        }
        return loObj;
    }

    private void setPreFilter() {
        BillList list = (BillList)this.getControl(BILLLISTAP);
        long currUserId = RequestContext.get().getCurrUserId();
        QFilter preQFilter = new QFilter("raiser.id", "=", (Object)currUserId);
        QFilter statusFilter = new QFilter("status", "!=", (Object)"D");
        preQFilter.and(statusFilter);
        list.setClientQueryFilterParameter(new FilterParameter(preQFilter, null));
    }

    private void refreshOp() {
        IFormController formController;
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        if (billList != null) {
            billList.clearSelection();
            billList.refresh();
        }
        if ((formController = (IFormController)this.getView().getService(IFormController.class)) != null) {
            formController.loadData();
        }
    }

    private void allegeOp() {
        List<Object> selectedRowKeys = this.getSelectedRowKeys();
        if (!this.verSelectedCount(selectedRowKeys.size(), true)) {
            return;
        }
        BillShowParameter parameter = new BillShowParameter();
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setHasRight(true);
        parameter.setFormId("fircm_creditappeal");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setCustomParam("creditLogId", (Object)selectedRowKeys.get(0).toString());
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void allegeRecordOp() {
        List<Object> selectedRowKeys = this.getSelectedRowKeys();
        if (!this.verSelectedCount(selectedRowKeys.size(), false)) {
            return;
        }
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId("fircm_creditappeal");
        listShowParameter.setFormId("bos_list");
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.setLookUp(false);
        listShowParameter.setCustomParam("openInMyCredit", (Object)Boolean.TRUE);
        QFilter filter = new QFilter("creditmodifylogid", "in", selectedRowKeys);
        listShowParameter.getListFilterParameter().setFilter(filter);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private List<Object> getSelectedRowKeys() {
        ListSelectedRowCollection selected = ((BillList)this.getControl(BILLLISTAP)).getSelectedRows();
        Object[] primaryKeyValues = selected.getPrimaryKeyValues();
        return Arrays.asList(primaryKeyValues);
    }

    private boolean verSelectedCount(int size, boolean onlyOne) {
        IFormView view = this.getView();
        if (size == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"MyCreditListPlugin_2", (String)"fi-fircm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (size > 1 && onlyOne) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"MyCreditListPlugin_3", (String)"fi-fircm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

