/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fircm.formplugin;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.chart.ChartType;
import kd.bos.form.chart.GaugeChart;
import kd.bos.form.chart.GaugeSeries;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.fi.fircm.business.factory.credit.CreditLevelSerivceFactory;
import kd.fi.fircm.business.helper.CreditServiceHelper;
import kd.fi.fircm.business.service.credit.CreditLevelSerivce;

public class MyCreditScoreDisplayPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final String KEY_SCOREANDRIGHT = "flexpanelap_display";
    private static final String KEY_LEVEL = "labelap_level";
    private static final String KEY_SCORE = "labelap_score";
    private static final String GAUGECHARTAP = "gaugechartap";
    private static final String CACHEKEY_CURSCORE = "curScore";
    private static final String CACHEKEY_CURLEVELNAME = "curLevelName";
    private static final String CACHEKEY_CURLEVELNO = "curLevelNumber";
    private static final String CACHEKEY_CURLEVELMAXVALUE = "curLevelMaxValue";
    private static final String EQUITY_REMARK = "equity_remark";

    public void afterCreateNewData(EventObject e) {
        long currUserId = RequestContext.get().getCurrUserId();
        DynamicObject creditFile = CreditServiceHelper.queryCreditFileByBillInfo((long)currUserId);
        if (creditFile != null) {
            BigDecimal curScore = creditFile.getBigDecimal("creditvalue");
            DynamicObject curLevel = creditFile.getDynamicObject("creditlevel");
            String curLevelName = curLevel.getString("name");
            String curLevelNumber = curLevel.getString("number");
            BigDecimal curLevelMaxValue = curLevel.getBigDecimal("maxvalue");
            this.getPageCache().put(CACHEKEY_CURSCORE, curScore.toString());
            this.getPageCache().put(CACHEKEY_CURLEVELNAME, curLevelName);
            this.getPageCache().put(CACHEKEY_CURLEVELNO, curLevelNumber);
            this.getPageCache().put(CACHEKEY_CURLEVELMAXVALUE, curLevelMaxValue.toString());
        }
    }

    public void afterBindData(EventObject e) {
        IFormView view = this.getView();
        CreditLevelSerivce service = CreditLevelSerivceFactory.newInstance();
        String curScoreStr = this.getPageCache().get(CACHEKEY_CURSCORE);
        if (curScoreStr == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u4fe1\u7528\u7b49\u7ea7\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MyCreditScoreDisplayPlugin_0", (String)"fi-fircm-formplugin", (Object[])new Object[0]));
            view.setVisible(Boolean.valueOf(false), new String[]{KEY_SCOREANDRIGHT});
            return;
        }
        BigDecimal curScore = new BigDecimal(curScoreStr);
        Map scoreRange = service.getCreditScoreRange();
        BigDecimal curLevelMaxValue = new BigDecimal(this.getPageCache().get(CACHEKEY_CURLEVELMAXVALUE));
        Label levelLab = (Label)this.getControl(KEY_LEVEL);
        Label scoreLab = (Label)this.getControl(KEY_SCORE);
        HashMap<String, String> nextLevelMap = new HashMap<String, String>(2);
        if (curLevelMaxValue.compareTo(new BigDecimal((Integer)scoreRange.get("max"))) == 0) {
            scoreLab.setText(ResManager.loadKDString((String)"\u5df2\u8fbe\u5230\u6700\u5927\u4fe1\u7528\u7b49\u7ea7", (String)"MyCreditScoreDisplayPlugin_4", (String)"fi-fircm-formplugin", (Object[])new Object[0]));
            nextLevelMap.put("levelLabName", this.getPageCache().get(CACHEKEY_CURLEVELNAME));
            nextLevelMap.put("levelLabNumber", this.getPageCache().get(CACHEKEY_CURLEVELNO));
            levelLab.setText((String)nextLevelMap.get("levelLabName"));
        } else {
            String levelUpNeedScore = curLevelMaxValue.subtract(curScore).setScale(1, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString();
            scoreLab.setText(String.format(ResManager.loadKDString((String)"\u8fd8\u5dee%s\u5206\u53ef\u5347\u7ea7\u4e3a", (String)"MyCreditScoreDisplayPlugin_1", (String)"fi-fircm-formplugin", (Object[])new Object[0]), levelUpNeedScore));
            DynamicObject nextLevel = service.getCreditLevel(curLevelMaxValue);
            nextLevelMap.put("levelLabName", nextLevel.getString("name"));
            nextLevelMap.put("levelLabNumber", nextLevel.getString("number"));
            levelLab.setText((String)nextLevelMap.get("levelLabName"));
        }
        this.getPageCache().put(nextLevelMap);
        this.initDashboard(curScore, this.getPageCache().get(CACHEKEY_CURLEVELNAME), scoreRange);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_LEVEL});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String clickKey = c.getKey();
        IFormView view = this.getView();
        if (KEY_LEVEL.equalsIgnoreCase(clickKey)) {
            if (this.getPageCache().get("mainOrgCreditSetting") == null) {
                view.showTipNotification(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u4fe1\u7528\u7b49\u7ea7\u6743\u76ca\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MyCreditScoreDisplayPlugin_3", (String)"fi-fircm-formplugin", (Object[])new Object[0]));
            } else {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId(EQUITY_REMARK);
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setCaption(String.format(ResManager.loadKDString((String)"%s\u7684\u6743\u76ca", (String)"MyCreditScoreDisplayPlugin_2", (String)"fi-fircm-formplugin", (Object[])new Object[0]), this.getPageCache().get("levelLabName")));
                showParameter.setCustomParam("equityLevelNumber", (Object)this.getPageCache().get("levelLabNumber"));
                this.getView().showForm(showParameter);
            }
        }
    }

    private void initDashboard(BigDecimal creditScore, String creditLevelName, Map<String, Integer> scoreRange) {
        GaugeChart chart = (GaugeChart)this.getControl(GAUGECHARTAP);
        GaugeSeries gaugeSeries = chart.createSeries("gauge");
        gaugeSeries.setType(ChartType.gauge);
        gaugeSeries.setPropValue("startAngle", (Object)"180");
        gaugeSeries.setPropValue("endAngle", (Object)"0");
        gaugeSeries.setPropValue("min", (Object)scoreRange.get("min"));
        gaugeSeries.setPropValue("max", (Object)scoreRange.get("max"));
        gaugeSeries.setPropValue("radius", (Object)"150%");
        Object[] cen = new Object[]{"50%", "90%"};
        gaugeSeries.setPropValue("center", (Object)cen);
        gaugeSeries.setPropValue("pointer", null);
        HashMap<String, Object> itemStyleMap = new HashMap<String, Object>();
        itemStyleMap.put("color", "#5582f3");
        itemStyleMap.put("shadowColor", "rgba(0,138,255,0.45)");
        itemStyleMap.put("shadowBlur", 10);
        itemStyleMap.put("shadowOffsetX", 2);
        itemStyleMap.put("shadowOffsetY", 2);
        gaugeSeries.setPropValue("itemStyle", itemStyleMap);
        HashMap axLineMap = new HashMap();
        HashMap<String, Integer> styleMap = new HashMap<String, Integer>();
        styleMap.put("width", 6);
        Object[][] lineColor = new Object[][]{{scoreRange.get("max"), "#5582f3"}};
        axLineMap.put("lineStyle", styleMap);
        gaugeSeries.setPropValue("axisLine", axLineMap);
        HashMap<String, Comparable<Boolean>> progressMap = new HashMap<String, Comparable<Boolean>>();
        progressMap.put("show", Boolean.valueOf(true));
        progressMap.put("roundCap", Boolean.valueOf(true));
        progressMap.put("width", Integer.valueOf(18));
        gaugeSeries.setPropValue("progress", progressMap);
        HashMap<String, Serializable> splitLineMap = new HashMap<String, Serializable>();
        splitLineMap.put("length", Integer.valueOf(14));
        HashMap<String, Object> sLStyleMap = new HashMap<String, Object>();
        sLStyleMap.put("width", 3);
        sLStyleMap.put("color", "auto");
        splitLineMap.put("lineStyle", sLStyleMap);
        gaugeSeries.setPropValue("splitLine", splitLineMap);
        HashMap<String, Serializable> axisTicMap = new HashMap<String, Serializable>();
        axisTicMap.put("length", Integer.valueOf(10));
        HashMap<String, Object> sTStyleMap = new HashMap<String, Object>();
        sTStyleMap.put("width", 2);
        sTStyleMap.put("color", "auto");
        axisTicMap.put("lineStyle", sTStyleMap);
        gaugeSeries.setPropValue("axisTick", axisTicMap);
        HashMap<String, Object> axisLabelMap = new HashMap<String, Object>();
        axisLabelMap.put("distance", 3);
        axisLabelMap.put("fontSize", 10);
        axisLabelMap.put("color", "#999");
        gaugeSeries.setPropValue("axisLabel", axisLabelMap);
        HashMap<String, Object> detailMap = new HashMap<String, Object>();
        detailMap.put("formatter", String.format(ResManager.loadKDString((String)"%s\u5206", (String)"MyCreditScoreDisplayPlugin_5", (String)"fi-fircm-formplugin", (Object[])new Object[0]), "{value}"));
        detailMap.put("fontSize", 22);
        Object[] dataLo = new Object[]{0, "0%"};
        detailMap.put("offsetCenter", dataLo);
        gaugeSeries.setDetail(detailMap);
        HashMap<String, Object[]> titleMap = new HashMap<String, Object[]>();
        Object[] titleLo = new Object[]{0, "-22%"};
        titleMap.put("offsetCenter", titleLo);
        gaugeSeries.setPropValue("title", titleMap);
        ItemValue itemValue = new ItemValue(creditLevelName, (Number)creditScore);
        ItemValue[] itemValues = new ItemValue[]{itemValue};
        gaugeSeries.setData(itemValues);
        chart.refresh();
    }
}

