/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fircm.formplugin;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fircm.business.helper.CreditServiceHelper;

public class TaskCretditControlPlugin
extends AbstractBillPlugIn
implements ClickListener {
    private Log log = LogFactory.getLog(TaskCretditControlPlugin.class);

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"txttasklevel"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map<String, Object> params = this.getCustomParams();
        String userid = String.valueOf(params.get("userid"));
        if (!StringUtils.isEmpty((String)userid) && !"null".equals(userid)) {
            this.initCreditInfo(Long.parseLong(userid));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("txttasklevel".equals(key)) {
            Map<String, Object> params = this.getCustomParams();
            String userid = String.valueOf(params.get("userid"));
            IFormView view = this.getView();
            TaskCretditControlPlugin.showCreditFilesForm(view, userid);
        }
    }

    private void initCreditInfo(long userId) {
        DynamicObject userArchive = CreditServiceHelper.queryCreditLevelByUserId((Long)userId);
        if (userArchive != null) {
            String curLevName = userArchive.getString("creditlevel.name");
            BigDecimal curLevScoreBG = userArchive.getBigDecimal("creditvalue").setScale(1, 5);
            String creditInfo = String.format(ResManager.loadKDString((String)"%1$s %2$s\u5206", (String)"TaskCretditControlPlugin_0", (String)"fi-fircm-formplugin", (Object[])new Object[0]), curLevName, curLevScoreBG);
            Label creditLevel = (Label)this.getControl("txttasklevel");
            creditLevel.setText(creditInfo);
        }
    }

    private Map<String, Object> getCustomParams() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        return paramMap;
    }

    private static void showCreditFilesForm(IFormView view, String userId) {
        if (StringUtils.isEmpty((String)userId)) {
            view.showMessage(String.format(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u7f16\u53f7 %s \u7684\u4fe1\u7528\u6863\u6848\u3002", (String)"TaskCretditControlPlugin_1", (String)"fi-fircm-formplugin", (Object[])new Object[0]), userId));
        } else {
            String id = TaskCretditControlPlugin.getCreditFilesID(userId);
            if (StringUtils.isBlank((String)id)) {
                view.showMessage(String.format(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u7f16\u53f7 %s \u7684\u4fe1\u7528\u6863\u6848\u3002", (String)"TaskCretditControlPlugin_1", (String)"fi-fircm-formplugin", (Object[])new Object[0]), userId));
            } else {
                BillShowParameter parameter = new BillShowParameter();
                parameter.setFormId("task_creditfiles");
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setCaption(ResManager.loadKDString((String)"\u4fe1\u7528\u6863\u6848", (String)"TaskCretditControlPlugin_2", (String)"fi-fircm-formplugin", (Object[])new Object[0]));
                parameter.setStatus(OperationStatus.VIEW);
                parameter.setPkId((Object)id);
                parameter.setHasRight(true);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("fromwhere", "tasklist");
                map.put("pageid", view.getPageId());
                parameter.setCustomParams(map);
                view.showForm((FormShowParameter)parameter);
            }
        }
    }

    public static String getCreditFilesID(String userId) {
        QFilter filter = new QFilter("user", "=", (Object)userId);
        QFilter statusFilter = new QFilter("status", "!=", (Object)Character.valueOf('D'));
        QFilter[] filters = new QFilter[]{filter, statusFilter};
        DynamicObject user = QueryServiceHelper.queryOne((String)"task_creditfiles", (String)"id,user.name,user.id", (QFilter[])filters);
        return user == null ? null : user.getString("id");
    }
}

