/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fircm.formplugin.creditappeal;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.fircm.business.factory.credit.CreditLevelSerivceFactory;
import kd.fi.fircm.business.helper.CreditServiceHelper;
import kd.fi.fircm.business.service.credit.CreditLevelSerivce;
import kd.fi.fircm.enums.ModifySourceEnum;
import kd.fi.fircm.enums.ModifyTypeEnum;

public class CreditAppealEditPlugin
extends AbstractBillPlugIn
implements HyperLinkClickListener {
    private static final String CREDIT_LOG_ID = "creditLogId";
    private static final String SAVE_CREDIT_LOG_ID = "creditmodifylogid";
    private static final String TITLE_PANEL = "titlepanel";
    private static final String COMPANY = "company";
    private static final String ORG = "org";
    private static final String POSITION = "position";
    private static final String DEFAULT_HEADER_URL = "/images/pc/emotion/default_person_82_82.png";
    private static final String BOS_USER = "bos_user";
    private static final String HEADER_IMAGE = "applierpic";
    private static final String APPLY_USER_NAME = "applierv";
    private static final String TEL = "telv";
    private static final String SUBMIT_BUTTON = "bar_submit";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String BILLID = "billid";
    private static final String BILL_ENTITY = "billentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{SUBMIT_BUTTON});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String creditLogId = (String)customParams.get(CREDIT_LOG_ID);
        this.initBaseInfo(true);
        this.initCreditUpdateLog(creditLogId);
        this.getModel().setValue(SAVE_CREDIT_LOG_ID, (Object)creditLogId);
        super.afterCreateNewData(e);
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.initBaseInfo(false);
        String creditLogId = String.valueOf(this.getModel().getValue(SAVE_CREDIT_LOG_ID));
        this.initCreditUpdateLog(creditLogId);
        String appId = this.getView().getFormShowParameter().getAppId();
        if ("fircm".equals(appId)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_save", SUBMIT_BUTTON});
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        BigDecimal saveScore;
        super.beforeClosed(e);
        boolean needShowTips = true;
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (!"A".equals(billStatus)) {
            e.setCheckDataChange(false);
            return;
        }
        String pageCachedScore = this.getPageCache().get("applyaddscore");
        BigDecimal bigDecimal = (BigDecimal)this.getModel().getValue("applyaddscore");
        if (bigDecimal == null && pageCachedScore == null) {
            needShowTips = false;
        } else if (bigDecimal != null && pageCachedScore != null && (saveScore = new BigDecimal(pageCachedScore)).compareTo(bigDecimal) == 0) {
            needShowTips = false;
        }
        if (!needShowTips) {
            String pageCachedReason = this.getPageCache().get("appealreason");
            String currReason = (String)this.getModel().getValue("appealreason");
            if (pageCachedReason == null && currReason == null) {
                needShowTips = false;
            } else if (pageCachedReason != null && currReason != null) {
                needShowTips = !pageCachedReason.equals(currReason);
            }
        }
        e.setCheckDataChange(needShowTips);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"submit")) {
            Long creditModifyLog = (Long)this.getModel().getValue(SAVE_CREDIT_LOG_ID);
            QFilter modifyLogFilter = new QFilter(SAVE_CREDIT_LOG_ID, "=", (Object)creditModifyLog);
            QFilter statusFilter = new QFilter("billstatus", "in", (Object)new String[]{"B", "C"});
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"fircm_creditappeal", (String)"fid", (QFilter[])new QFilter[]{modifyLogFilter, statusFilter});
            if (dynamicObject != null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5173\u8054\u4fe1\u7528\u53d8\u66f4\u65e5\u5fd7\u5df2\u53d1\u8d77\u4fe1\u7528\u7533\u8bc9\uff0c\u8bf7\u67e5\u770b\u7533\u8bc9\u8bb0\u5f55\u3002", (String)"CreditAppealEditPlugin_1", (String)"fi-fircm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"save")) {
            this.saveScoreAndReason();
        }
        super.beforeDoOperation(args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String currAppealCreditLogId;
        super.afterDoOperation(afterDoOperationEventArgs);
        String operationKey = afterDoOperationEventArgs.getOperateKey();
        if ((StringUtils.equals((CharSequence)operationKey, (CharSequence)"submit") || StringUtils.equals((CharSequence)operationKey, (CharSequence)"unsubmit") || StringUtils.equals((CharSequence)operationKey, (CharSequence)"save")) && StringUtils.isNotBlank((CharSequence)(currAppealCreditLogId = String.valueOf(this.getModel().getValue(SAVE_CREDIT_LOG_ID))))) {
            this.initCreditUpdateLog(currAppealCreditLogId);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String operationKey = evt.getOperationKey();
        if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"submit") || StringUtils.equals((CharSequence)operationKey, (CharSequence)"save")) {
            BigDecimal currApplyAddCreditScore;
            CreditLevelSerivce service = CreditLevelSerivceFactory.newInstance();
            Map scoreRange = service.getCreditScoreRange();
            BigDecimal curScore = this.getUserCurScore();
            BigDecimal maxScore = new BigDecimal((Integer)scoreRange.get("max"));
            BigDecimal minScore = new BigDecimal((Integer)scoreRange.get("min"));
            BigDecimal maxCanApplyScore = maxScore.subtract(curScore);
            if (maxCanApplyScore.compareTo(currApplyAddCreditScore = new BigDecimal(this.getModel().getDataEntity().getString("applyaddscore"))) < 0) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4fe1\u7528\u5206\u6570\u8303\u56f4\u662f[%1$s,%2$s]\uff0c\u53ef\u7533\u8bc9\u4fe1\u7528\u52a0\u5206\u8303\u56f4\u4e3a\uff1a(0,%3$s]\u3002", (String)"CreditAppealEditPlugin_2", (String)"fi-fircm-formplugin", (Object[])new Object[0]), minScore, maxScore, maxCanApplyScore));
                evt.setCancel(true);
            }
            this.getModel().setValue("auditscore", (Object)currApplyAddCreditScore);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String clickFieldName = hyperLinkClickEvent.getFieldName();
        if ("changebillnumber".equals(clickFieldName)) {
            BillShowParameter parameter = new BillShowParameter();
            parameter.setStatus(OperationStatus.VIEW);
            parameter.setBillStatus(BillOperationStatus.AUDIT);
            parameter.setHasRight(true);
            String pkId = this.getPageCache().get(BILLID);
            Long pkIdLong = 0L;
            try {
                pkIdLong = Long.valueOf(pkId);
            }
            catch (NumberFormatException e) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u67e5\u770b\u5f02\u6784\u7cfb\u7edf\u5355\u636e\u3002", (String)"CreditAppealEditPlugin_4", (String)"fi-fircm-formplugin", (Object[])new Object[0]));
                return;
            }
            parameter.setPkId((Object)pkIdLong);
            parameter.setFormId(this.getPageCache().get(BILL_ENTITY));
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.addCustPlugin("kd.bos.ext.fircm.formplugin.CreditHideBillMenuPlugin");
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    private void initBaseInfo(boolean newFlag) {
        IDataModel model = this.getModel();
        BillView view = (BillView)this.getView();
        long currUserId = this.getUserId(newFlag);
        DynamicObject currUserInfo = BusinessDataServiceHelper.loadSingleFromCache((Object)currUserId, (String)BOS_USER);
        long mainOrgId = UserServiceHelper.getUserMainOrgId((long)currUserId);
        if (mainOrgId <= 0L) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u63d0\u5355\u4eba\u9700\u8981\u4e3b\u804c\u4f4d\u624d\u80fd\u63d0\u5355\uff0c\u8bf7\u5230\u7cfb\u7edf\u4e91\u2014\u57fa\u7840\u670d\u52a1\u2014\u4eba\u5458\u5904\u8bbe\u7f6e", (String)"CreditAppealEditPlugin_0", (String)"fi-fircm-formplugin", (Object[])new Object[0]));
            view.setVisible(Boolean.FALSE, new String[]{TITLE_PANEL});
            return;
        }
        if (newFlag) {
            model.setValue(ORG, (Object)mainOrgId);
            String position = UserServiceHelper.getUserMainJob((long)currUserId);
            model.setValue(POSITION, (Object)position);
            Map companyInfo = OrgUnitServiceHelper.getCompanyfromOrg((Long)mainOrgId);
            model.setValue(COMPANY, companyInfo.get("id"));
        }
        Image applierPic = (Image)this.getControl(HEADER_IMAGE);
        applierPic.setUrl(this.getUserHeader(currUserId));
        Label applierv = (Label)this.getControl(APPLY_USER_NAME);
        applierv.setText(currUserInfo.getString("name"));
        Label telv = (Label)this.getControl(TEL);
        telv.setText(currUserInfo.getString("phone").replaceAll("(\\d{3})\\d*(\\d{2})", "$1****$2"));
        this.saveScoreAndReason();
    }

    private void initCreditUpdateLog(String creditLogId) {
        DynamicObject dynamicObject = null;
        try {
            dynamicObject = BusinessDataServiceHelper.loadSingle((Object)creditLogId, (String)"task_creditmodifylog");
        }
        catch (KDException e) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fe1\u7528\u7533\u8bc9\u5355\u5173\u8054\u7684\u4fe1\u7528\u53d8\u66f4\u65e5\u5fd7\u6570\u636e\u518d\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"CreditAppealEditPlugin_3", (String)"fi-fircm-formplugin", (Object[])new Object[0]));
        }
        if (dynamicObject == null) {
            return;
        }
        this.getPageCache().put(BILLID, dynamicObject.getString(BILLID));
        this.getPageCache().put(BILL_ENTITY, dynamicObject.getString(BILL_ENTITY).trim());
        if (this.getModel().getEntryRowCount(ENTRY_ENTITY) == 0) {
            this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, 1);
        }
        this.getModel().setValue("changetime", dynamicObject.get("modifydate"), 0);
        this.getModel().setValue("changetype", (Object)ModifyTypeEnum.getDesc((String)dynamicObject.getString("modifytype")), 0);
        this.getModel().setValue("changesource", (Object)ModifySourceEnum.getDesc((String)dynamicObject.getString("modifysource")), 0);
        this.getModel().setValue("changescore", dynamicObject.get("changedscore"), 0);
        this.getModel().setValue("oldlevel", dynamicObject.get("oldlevel"), 0);
        this.getModel().setValue("oldscore", dynamicObject.get("oldgrade"), 0);
        this.getModel().setValue("newlevel", dynamicObject.get("newlevel"), 0);
        this.getModel().setValue("newscore", dynamicObject.get("newgrade"), 0);
        this.getModel().setValue("changebillnumber", dynamicObject.get("billno"), 0);
        this.getModel().setValue("changedesc", dynamicObject.get("description"), 0);
    }

    private String getUserHeader(Long userId) {
        Map userAvatarPathMap = UserServiceHelper.getUserAvatarPath(Collections.singletonList(userId), (boolean)true);
        String imgURL = (String)userAvatarPathMap.get(userId);
        return StringUtils.isNotBlank((CharSequence)imgURL) ? imgURL : DEFAULT_HEADER_URL;
    }

    private Long getUserId(boolean newFlag) {
        if (newFlag) {
            return RequestContext.get().getCurrUserId();
        }
        return (Long)this.getModel().getDataEntity().getDynamicObject("creator").get("id");
    }

    private BigDecimal getUserCurScore() {
        long userId = (Long)this.getModel().getDataEntity().getDynamicObject("creator").get("id");
        DynamicObject creditFile = CreditServiceHelper.queryCreditFileByBillInfo((long)userId);
        BigDecimal curScore = creditFile.getBigDecimal("creditvalue");
        return curScore;
    }

    private void saveScoreAndReason() {
        Object reason;
        Object score = this.getModel().getValue("applyaddscore");
        if (score != null) {
            this.getPageCache().put("applyaddscore", String.valueOf(score));
        }
        if ((reason = this.getModel().getValue("appealreason")) != null) {
            this.getPageCache().put("appealreason", String.valueOf(reason));
        }
    }
}

