/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fircm.formplugin.creditappeal;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.fi.fircm.utils.ViewFlowchartUtil;

public class CreditAppealListPlugin
extends AbstractListPlugin {
    private static final String NEXT_AUDITOR = "nextauditor";

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if (NEXT_AUDITOR.equals(fieldName)) {
            args.setCancel(true);
            ListSelectedRow selectedRowInfo = ((BillList)this.getControl("billlistap")).getCurrentSelectedRowInfo();
            Long billId = Long.parseLong(String.valueOf(selectedRowInfo.getPrimaryKeyValue()));
            ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
            String pageId = listShowParameter.getPageId();
            WorkflowServiceHelper.viewFlowchart((String)pageId, (Object)billId);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                if (rows.isEmpty()) {
                    return rows;
                }
                ArrayList ids = new ArrayList();
                rows.forEach(v -> ids.add(String.valueOf(v.getPkValue())));
                if (ids.size() > 0) {
                    CreditAppealListPlugin.this.setNextAuditor(rows, ids);
                }
                return rows;
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams;
        String appId = this.getView().getFormShowParameter().getAppId();
        if ("fircm".equals(appId)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tblsubmit", "baritemap2"});
        }
        if ((customParams = this.getView().getFormShowParameter().getCustomParams()).containsKey("openInMyCredit")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"filtercontainerap"});
        }
        super.afterCreateNewData(e);
    }

    private void setNextAuditor(DynamicObjectCollection collection, List<String> ids) {
        Map nextAuditorMap = ViewFlowchartUtil.getNextAuditor(ids);
        collection.forEach(v -> {
            String id = String.valueOf(v.getPkValue());
            v.set(NEXT_AUDITOR, (Object)(nextAuditorMap.get(id) == null ? "" : nextAuditorMap.get(id)));
        });
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        String appId = this.getView().getFormShowParameter().getAppId();
        if (!"fircm".equals(appId)) {
            List qFilters = e.getQFilters();
            Long currUserId = RequestContext.get().getCurrUserId();
            QFilter createUserFilter = new QFilter("creator", "=", (Object)currUserId);
            qFilters.add(createUserFilter);
        }
    }
}

