/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fircm.formplugin.creditarg;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.property.UserProp;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.fi.fircm.business.helper.CreditServiceHelper;

public class CreditArgEditPlugin
extends AbstractBillPlugIn {
    private static final String COMBO_APPOBJ = "appobj";
    public static final String TEXT_APPOBJ_NAME = "appobjname";
    private static final String CACHE_COMBO_MAP = "comboMap";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setComboItems();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        DynamicObject bizBill;
        super.afterDoOperation(afterDoOperationEventArgs);
        IDataModel model = this.getModel();
        if (afterDoOperationEventArgs.getOperationResult() != null && afterDoOperationEventArgs.getOperationResult().isSuccess() && "save".equalsIgnoreCase(afterDoOperationEventArgs.getOperateKey()) && (bizBill = (DynamicObject)model.getValue("bizbill")) != null) {
            CreditServiceHelper.updateWfCConfByFormNum((String)bizBill.getString("number"));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String appObjNum;
        super.beforeDoOperation(args);
        Object source = args.getSource();
        IDataModel model = this.getModel();
        if (source instanceof Save && StringUtils.isNotEmpty((CharSequence)(appObjNum = (String)model.getValue(COMBO_APPOBJ)))) {
            String comboJson = this.getView().getPageCache().get(CACHE_COMBO_MAP);
            Map comboItemMap = (Map)JSONObject.parseObject((String)comboJson, Map.class);
            model.setValue(TEXT_APPOBJ_NAME, comboItemMap.get(appObjNum));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if ("bizbill".equals(propertyName)) {
            this.setComboItems();
        }
    }

    private void setComboItems() {
        IDataModel model = this.getModel();
        DynamicObject bizbillDyn = (DynamicObject)model.getValue("bizbill");
        if (bizbillDyn == null) {
            return;
        }
        String bizBillNum = bizbillDyn.getString("number");
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)bizBillNum);
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        HashMap<String, String> comboItemMap = new HashMap<String, String>();
        for (IDataEntityProperty prop : properties) {
            if (!(prop instanceof UserProp)) continue;
            ComboItem comboItem = new ComboItem();
            LocaleString displayName = prop.getDisplayName();
            String propName = prop.getName();
            comboItem.setCaption(displayName);
            comboItem.setValue(propName);
            comboItemMap.put(propName, displayName.getLocaleValue());
            comboItems.add(comboItem);
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl(COMBO_APPOBJ);
        comboEdit.setComboItems(comboItems);
        this.getView().getPageCache().put(CACHE_COMBO_MAP, JSONObject.toJSONString(comboItemMap));
    }
}

