/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fircm.formplugin.creditarg;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Delete;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fircm.task.util.FircmLicenseUtil;

public class CreditArgListPlugin
extends AbstractListPlugin {
    public void preOpenForm(PreOpenFormEventArgs e) {
        FircmLicenseUtil.checkGroupLicense((PreOpenFormEventArgs)e);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Delete) {
            this.relatedSubScoreRule(args);
        }
    }

    private void relatedSubScoreRule(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
        Map<String, String> billNums = this.getSelectBillNums(selectedRows);
        List<String> subScoreRuleDisquery = this.querySubscoreRuleDisquery(billNums);
        if (subScoreRuleDisquery == null || subScoreRuleDisquery.size() == 0) {
            return;
        }
        Set argNumList = subScoreRuleDisquery.stream().filter(taskBillId -> billNums.containsKey(taskBillId)).collect(Collectors.toSet());
        if (argNumList == null || argNumList.size() == 0) {
            return;
        }
        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\uff1a\u5b58\u5728\u5f15\u7528\u4e0d\u80fd\u88ab\u5220\u9664\uff0c\u201c\u5173\u8054\u5355\u636e\u67e5\u8be2\u201d\u7684\u5b57\u6bb5\u201c\u4e1a\u52a1\u5355\u636e\u201d\u5f15\u7528\u4e86\u6b64\u8d44\u6599\u6570\u636e\u3002", (String)"CreditArgListPlugin_0", (String)"fi-fircm-formplugin", (Object[])new Object[0]), StringUtils.join((Object[])argNumList.toArray(), (String)",")));
        args.setCancel(true);
    }

    private List<String> querySubscoreRuleDisquery(Map<String, String> billNames) {
        String selectField = "taskbillid";
        QFilter[] qFilters = new QFilter[]{new QFilter("taskbillid", "in", billNames.keySet())};
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"fircm_subscoredisquery", (String)selectField, (QFilter[])qFilters);
        return dynamicObjects.stream().map(dynamicObject -> dynamicObject.getString("taskbillid")).collect(Collectors.toList());
    }

    private Map<String, String> getSelectBillNums(ListSelectedRowCollection selectedRows) {
        List ids = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        String selectField = "number,bizbill.number";
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", ids)};
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"fircm_creditarg", (String)selectField, (QFilter[])qFilters);
        return dynamicObjectCollection.stream().collect(Collectors.toMap(obj -> obj.getString("bizbill.number"), obj -> obj.getString("number")));
    }
}

