/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fircm.formplugin.creditchangerule;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fircm.business.factory.credit.CreditLevelSerivceFactory;
import kd.fi.fircm.business.service.credit.CreditLevelSerivce;
import kd.fi.fircm.common.credit.CreditUpdateStatusUtil;
import kd.fi.fircm.formplugin.CreditChangeRuleAbstractFormPlugin;

public class CreditAddScoreRuleFormPlugin
extends CreditChangeRuleAbstractFormPlugin {
    @Override
    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit tx = (TextEdit)this.getControl("addscorestr");
        tx.addButtonClickListener((ClickListener)this);
        Toolbar tb = (Toolbar)this.getControl("toolbarap");
        tb.addItemClickListener((ItemClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initFormData();
        this.getModel().setDataChanged(false);
    }

    public void click(EventObject e) {
        super.click(e);
        String key = ((Control)e.getSource()).getKey();
        if ("addscorestr".equals(key)) {
            this.showCreditSettingForm();
        }
    }

    public void itemClick(ItemClickEvent e) {
        super.itemClick(e);
        String itemKey = e.getItemKey();
        if ("refresh".equals(itemKey)) {
            this.getView().updateView();
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        if ("setscorechange".equals(e.getActionId())) {
            IDataModel model = this.getModel();
            int rowIndex = model.getEntryCurrentRowIndex("entryentity");
            Map dataMap = (Map)returnData;
            model.setValue("addscore", dataMap.get("addscore"), rowIndex);
            model.setValue("levelstart", dataMap.get("levelstart"), rowIndex);
            model.setValue("levelend", dataMap.get("levelend"), rowIndex);
            boolean flag = (Boolean)dataMap.get("flag");
            String addScoreStr = this.buildAddScoreStr(!flag, dataMap.get("addscore"), (DynamicObject)dataMap.get("levelstart"), (DynamicObject)dataMap.get("levelend"));
            model.setValue("addscorestr", (Object)addScoreStr, rowIndex);
            model.setValue("flag", (Object)(!flag ? 1 : 0), rowIndex);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        IDataModel model = this.getModel();
        ChangeData changeData = e.getChangeSet()[0];
        if ("correctmonth".equals(propName) || "approvenum".equals(propName)) {
            int curIndex = model.getEntryCurrentRowIndex("entryentity");
            int months = (Integer)model.getValue("correctmonth", curIndex);
            int approveNum = (Integer)model.getValue("approvenum", curIndex);
            if (months == 0 || approveNum == 0) {
                return;
            }
            DynamicObjectCollection dynObjs = model.getEntryEntity("entryentity");
            for (int i = 0; i < dynObjs.size(); ++i) {
                DynamicObject dynObj = (DynamicObject)dynObjs.get(i);
                if (i == curIndex || months != dynObj.getInt("correctmonth") || approveNum != dynObj.getInt("approvenum")) continue;
                model.beginInit();
                model.setValue(propName, changeData.getOldValue(), curIndex);
                model.endInit();
                this.getView().updateView(propName, curIndex);
                String info = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5df2\u5b58\u5728\u76f8\u540c\u7684\u8fde\u7eed\u65e0\u5dee\u9519\u6708\u6570\u3001\u5468\u671f\u5185\u6700\u5c11\u5ba1\u6838\u901a\u8fc7\u5355\u6570\u3002", (String)"CreditAddScoreRuleFormPlugin_7", (String)"fi-fircm-formplugin", (Object[])new Object[0]), i + 1);
                this.getView().showTipNotification(info, Integer.valueOf(5000));
            }
        } else if ("addscoreper".equals(propName)) {
            this.getModel().setDataChanged(true);
        } else if ("addscorestr".equals(propName) && StringUtils.isEmpty((String)((String)changeData.getNewValue()))) {
            model.setValue("addscore", null);
            model.setValue("levelstart", null);
            model.setValue("levelend", null);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Donothing && "donothing_save".equals(key = ((Donothing)source).getOperateKey())) {
            boolean checkResult = this.checkData();
            boolean result = false;
            if (checkResult) {
                result = this.saveData();
            }
            if (!result) {
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        if ("donothing_disable".equals(key)) {
            this.updateStatus("0");
        } else if ("donothing_enable".equals(key)) {
            this.updateStatus("1");
        }
    }

    private void initFormData() {
        DynamicObject[] dynObjs;
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        QFilter statusFilter = new QFilter("status", "!=", (Object)Character.valueOf('D'));
        DynamicObject scoreLimit = BusinessDataServiceHelper.loadSingle((String)"task_creditscorelimit", (String)"id,addscoreper", (QFilter[])new QFilter[]{statusFilter});
        if (scoreLimit != null) {
            model.setValue("addscoreper", scoreLimit.get("addscoreper"));
            this.getView().updateView("addscoreper");
        }
        if ((dynObjs = BusinessDataServiceHelper.load((String)"task_credit_commonrule", (String)"id,correctmonth,approvenum,remark,enable,addscore,levelstart,levelend,flag", (QFilter[])new QFilter[]{statusFilter}, (String)"correctmonth,approvenum asc")) == null || dynObjs.length == 0) {
            return;
        }
        model.batchCreateNewEntryRow("entryentity", dynObjs.length);
        for (int i = 0; i < dynObjs.length; ++i) {
            DynamicObject dynObj = dynObjs[i];
            model.setValue("id", dynObj.get("id"), i);
            model.setValue("correctmonth", dynObj.get("correctmonth"), i);
            model.setValue("approvenum", dynObj.get("approvenum"), i);
            model.setValue("remark", dynObj.get("remark"), i);
            model.setValue("enable", dynObj.get("enable"), i);
            model.setValue("addscore", dynObj.get("addscore"), i);
            String addScoreStr = this.buildAddScoreStr(dynObj.getBoolean("flag"), dynObj.get("addscore"), dynObj.getDynamicObject("levelstart"), dynObj.getDynamicObject("levelend"));
            model.setValue("addscorestr", (Object)addScoreStr, i);
            model.setValue("levelstart", dynObj.get("levelstart"), i);
            model.setValue("levelend", dynObj.get("levelend"), i);
            model.setValue("flag", dynObj.get("flag"), i);
        }
        this.getView().updateView("entryentity");
    }

    private String buildAddScoreStr(boolean flag, Object addScore, DynamicObject levelStart, DynamicObject levelEnd) {
        String addScoreStr = null;
        if (!flag) {
            addScoreStr = String.format(ResManager.loadKDString((String)"\u52a0 %s \u5206", (String)"CreditAddScoreRuleFormPlugin_0", (String)"fi-fircm-formplugin", (Object[])new Object[0]), ((BigDecimal)addScore).stripTrailingZeros().toPlainString());
        } else if (levelStart != null && levelEnd != null) {
            addScoreStr = String.format(ResManager.loadKDString((String)"%1$s \u52a0\u5206\u81f3 %2$s", (String)"CreditAddScoreRuleFormPlugin_1", (String)"fi-fircm-formplugin", (Object[])new Object[0]), levelStart.getString("name"), levelEnd.getString("name"));
        }
        return addScoreStr;
    }

    private void showCreditSettingForm() {
        DynamicObject levelEnd;
        FormShowParameter showParam = new FormShowParameter();
        showParam.setFormId("task_creditscoresetting");
        showParam.getOpenStyle().setShowType(ShowType.Modal);
        IDataModel model = this.getModel();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("frompage", "add");
        paramMap.put("addscore", model.getValue("addscore"));
        DynamicObject levelStart = (DynamicObject)model.getValue("levelstart");
        if (levelStart != null) {
            paramMap.put("levelstart", levelStart.getPkValue());
        }
        if ((levelEnd = (DynamicObject)model.getValue("levelend")) != null) {
            paramMap.put("levelend", levelEnd.getPkValue());
        }
        paramMap.put("flag", model.getValue("flag"));
        showParam.setCustomParams(paramMap);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "setscorechange");
        showParam.setCloseCallBack(callBack);
        this.getView().showForm(showParam);
    }

    private boolean checkData() {
        IDataModel model = this.getModel();
        CreditLevelSerivce service = CreditLevelSerivceFactory.newInstance();
        Map scoreRange = service.getCreditScoreRange();
        int max = (Integer)scoreRange.get("max");
        BigDecimal addScorePer = (BigDecimal)model.getValue("addscoreper");
        if (addScorePer.compareTo(BigDecimal.ZERO) < 0 || addScorePer.compareTo(BigDecimal.valueOf(max)) > 0) {
            String info = String.format(ResManager.loadKDString((String)"\u6bcf\u5355\u65b0\u589e\u5206\u6570\u7684\u8303\u56f4\u4e3a[0, %s]\u3002", (String)"CreditAddScoreRuleFormPlugin_3", (String)"fi-fircm-formplugin", (Object[])new Object[0]), max);
            this.getView().showTipNotification(info);
            return false;
        }
        DynamicObjectCollection dynObjs = model.getEntryEntity("entryentity");
        StringBuilder info = new StringBuilder();
        for (int i = 0; i < dynObjs.size(); ++i) {
            String addScoreStr;
            int approveNum;
            DynamicObject dynObj = (DynamicObject)dynObjs.get(i);
            int months = (Integer)dynObj.get("correctmonth");
            if (months == 0) {
                String tempStr = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u8fde\u7eed\u65e0\u5dee\u9519\u6708\u6570\u7684\u503c\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"CreditAddScoreRuleFormPlugin_4", (String)"fi-fircm-formplugin", (Object[])new Object[0]), i + 1);
                info.append(tempStr);
            }
            if ((approveNum = ((Integer)dynObj.get("approvenum")).intValue()) == 0) {
                String tempStr = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5468\u671f\u5185\u6700\u5c11\u5ba1\u6838\u901a\u8fc7\u5355\u6570\u7684\u503c\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"CreditAddScoreRuleFormPlugin_5", (String)"fi-fircm-formplugin", (Object[])new Object[0]), i + 1);
                info.append(tempStr);
            }
            if (!StringUtils.isEmpty((String)(addScoreStr = (String)dynObj.get("addscorestr")))) continue;
            String tempStr = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u52a0\u5206\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"CreditAddScoreRuleFormPlugin_6", (String)"fi-fircm-formplugin", (Object[])new Object[0]), i + 1);
            info.append(tempStr);
        }
        if (info.length() > 0) {
            this.getView().showTipNotification(info.toString());
            return false;
        }
        return true;
    }

    private boolean saveData() {
        BigDecimal addScorePer = (BigDecimal)this.getModel().getValue("addscoreper");
        QFilter statusFilter = new QFilter("status", "!=", (Object)Character.valueOf('D'));
        String userId = RequestContext.get().getUserId();
        String selectProp = "id,createorg,addscoreper,enable,creator,modifier,modifytime";
        DynamicObject scoreLimit = BusinessDataServiceHelper.loadSingle((String)"task_creditscorelimit", (String)selectProp, (QFilter[])new QFilter[]{statusFilter});
        Date date = new Date();
        if (scoreLimit == null) {
            scoreLimit = BusinessDataServiceHelper.newDynamicObject((String)"task_creditscorelimit");
            scoreLimit.set("creator", (Object)Long.valueOf(userId));
            scoreLimit.set("createtime", (Object)date);
        }
        scoreLimit.set("addscoreper", (Object)addScorePer);
        scoreLimit.set("enable", (Object)Character.valueOf('1'));
        scoreLimit.set("modifier", (Object)Long.valueOf(userId));
        scoreLimit.set("modifytime", (Object)date);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{scoreLimit});
        DynamicObjectCollection dynObjs = this.getModel().getEntryEntity("entryentity");
        ArrayList<DynamicObject> commRules = new ArrayList<DynamicObject>(8);
        for (DynamicObject dynObj : dynObjs) {
            DynamicObject levelEnd;
            DynamicObject commRule = BusinessDataServiceHelper.newDynamicObject((String)"task_credit_commonrule");
            Long id = dynObj.getLong("id");
            if (id > 0L) {
                commRule.set("id", (Object)id);
            }
            commRule.set("createtime", (Object)date);
            commRule.set("modifytime", (Object)date);
            commRule.set("creator_id", (Object)Long.valueOf(userId));
            commRule.set("modifier_id", (Object)Long.valueOf(userId));
            commRule.set("status", (Object)"C");
            commRule.set("enable", dynObj.get("enable"));
            commRule.set("correctmonth", dynObj.get("correctmonth"));
            commRule.set("approvenum", dynObj.get("approvenum"));
            commRule.set("remark", dynObj.get("remark"));
            commRule.set("addscore", dynObj.get("addscore"));
            DynamicObject levelStart = dynObj.getDynamicObject("levelstart");
            if (levelStart != null) {
                commRule.set("levelstart_id", (Object)levelStart.getLong("id"));
            }
            if ((levelEnd = dynObj.getDynamicObject("levelend")) != null) {
                commRule.set("levelend_id", (Object)levelEnd.getLong("id"));
            }
            commRule.set("flag", dynObj.get("flag"));
            commRules.add(commRule);
        }
        DeleteServiceHelper.delete((String)"task_credit_commonrule", null);
        OperationResult opResult = OperationServiceHelper.executeOperate((String)"save", (String)"task_credit_commonrule", (DynamicObject[])commRules.toArray(new DynamicObject[0]), null);
        super.afterSaveOperation(opResult, "task_credit_commrulelist", this.getView());
        return opResult.isSuccess();
    }

    private void updateStatus(String opVal) {
        boolean isSuccess = CreditUpdateStatusUtil.updateStatus(this.getView(), this.getModel(), "task_credit_commonrule", "entryentity", opVal);
        if (isSuccess) {
            super.afterUpdateStatus(opVal, "task_credit_commrulelist", this.getView());
        }
    }
}

