/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fircm.formplugin.creditchangerule;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.fircm.business.factory.credit.CreditLevelSerivceFactory;
import kd.fi.fircm.business.service.credit.CreditLevelSerivce;
import kd.fi.fircm.common.credit.CreditUpdateStatusUtil;
import kd.fi.fircm.formplugin.CreditChangeRuleAbstractFormPlugin;

public class CreditByImageNewFormPlugin
extends CreditChangeRuleAbstractFormPlugin {
    private static final String IS_VALID = "valid";

    @Override
    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar tb = (Toolbar)this.getControl("toolbarap");
        tb.addItemClickListener((ItemClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initFormData();
        this.getModel().setDataChanged(false);
        this.getPageCache().put(IS_VALID, "true");
    }

    public void itemClick(ItemClickEvent e) {
        super.itemClick(e);
        String itemKey = e.getItemKey();
        if ("refresh".equals(itemKey)) {
            this.getView().updateView();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Donothing && "donothing_save".equals(key = ((Donothing)source).getOperateKey())) {
            boolean result = false;
            Boolean isValid = Boolean.parseBoolean(this.getPageCache().get(IS_VALID));
            if (!isValid.booleanValue()) {
                args.setCancel(true);
                return;
            }
            boolean checkResult = this.checkData();
            if (checkResult) {
                result = this.saveData();
            }
            if (!result) {
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        if ("donothing_disable".equals(key)) {
            this.updateStatus("0");
        } else if ("donothing_enable".equals(key)) {
            this.updateStatus("1");
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if ("outdatenum".equals(propName) || "subscore".equals(propName)) {
            int curIndex = model.getEntryCurrentRowIndex("entryentity");
            ChangeData[] changeSet = e.getChangeSet();
            Object newVal = changeSet[0].getNewValue();
            if ("outdatenum".equals(propName) ? (Integer)newVal == 0 : ((BigDecimal)newVal).compareTo(BigDecimal.ZERO) == 0) {
                return;
            }
            DynamicObjectCollection dynObjs = model.getEntryEntity("entryentity");
            if (!"subscore".equals(propName)) {
                ArrayList<Integer> outDateNums = new ArrayList<Integer>();
                for (int i = 0; i < dynObjs.size(); ++i) {
                    DynamicObject dynObj = (DynamicObject)dynObjs.get(i);
                    if (i != curIndex) {
                        outDateNums.add(dynObj.getInt("outdatenum"));
                        continue;
                    }
                    outDateNums.add(dynObj.getInt("outdatenum") + 1);
                }
                int index = outDateNums.indexOf(newVal);
                if (index >= 0) {
                    model.beginInit();
                    model.setValue("outdatenum", changeSet[0].getOldValue());
                    model.endInit();
                    view.updateView(propName, curIndex);
                    String info = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5df2\u5b58\u5728\u76f8\u540c\u7684\u5f71\u50cf\u672a\u4e0a\u4f20\u5929\u6570\u3002", (String)"CreditByImageNewFormPlugin_1", (String)"fi-fircm-formplugin", (Object[])new Object[0]), index + 1);
                    this.getView().showTipNotification(info);
                    this.getPageCache().put(IS_VALID, "false");
                    return;
                }
            }
            if (!this.propertyChangedCheck(curIndex, dynObjs)) {
                model.setValue("subscore", null, curIndex);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f71\u50cf\u672a\u4e0a\u4f20\u5929\u6570\u8d8a\u5927\uff0c\u8bbe\u7f6e\u7684\u51cf\u5206\u503c\u5e94\u8d8a\u5927\u3002", (String)"CreditByImageNewFormPlugin_2", (String)"fi-fircm-formplugin", (Object[])new Object[0]));
                this.getPageCache().put(IS_VALID, "false");
                return;
            }
        }
        this.getPageCache().put(IS_VALID, "true");
    }

    private boolean propertyChangedCheck(int curIndex, DynamicObjectCollection dynObjs) {
        DynamicObject nextRow;
        BigDecimal nextScore;
        DynamicObject lastRow;
        BigDecimal lastScore;
        DynamicObject curRow = (DynamicObject)dynObjs.get(curIndex);
        int days = curRow.getInt("outdatenum");
        BigDecimal score = curRow.getBigDecimal("subscore");
        if (days == 0 || score.compareTo(BigDecimal.ZERO) == 0) {
            return true;
        }
        DynamicObjectCollection dynObjsCopy = (DynamicObjectCollection)dynObjs.clone();
        dynObjsCopy.sort((p1, p2) -> p1.getInt("outdatenum") - p2.getInt("outdatenum"));
        int index = -1;
        for (int i = 0; i < dynObjsCopy.size(); ++i) {
            DynamicObject dynObj = (DynamicObject)dynObjsCopy.get(i);
            if (days != dynObj.getInt("outdatenum")) continue;
            index = i;
            break;
        }
        if (index > 0 && score.compareTo(lastScore = (lastRow = (DynamicObject)dynObjsCopy.get(index - 1)).getBigDecimal("subscore")) <= 0) {
            return false;
        }
        return index >= dynObjsCopy.size() - 1 || score.compareTo(nextScore = (nextRow = (DynamicObject)dynObjsCopy.get(index + 1)).getBigDecimal("subscore")) < 0;
    }

    private void initFormData() {
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        QFilter statusFilter = new QFilter("status", "!=", (Object)Character.valueOf('D'));
        DynamicObject[] dynObjs = BusinessDataServiceHelper.load((String)"task_creditbyimagenew", (String)"id,outdatenum,subscore,enable", (QFilter[])new QFilter[]{statusFilter}, (String)"outdatenum,subscore asc");
        if (dynObjs == null || dynObjs.length == 0) {
            return;
        }
        model.batchCreateNewEntryRow("entryentity", dynObjs.length);
        for (int i = 0; i < dynObjs.length; ++i) {
            DynamicObject dynObj = dynObjs[i];
            model.setValue("id", dynObj.get("id"), i);
            model.setValue("outdatenum", dynObj.get("outdatenum"), i);
            model.setValue("subscore", dynObj.get("subscore"), i);
            model.setValue("enable", dynObj.get("enable"), i);
        }
        this.getView().updateView("entryentity");
    }

    private boolean checkData() {
        DynamicObjectCollection dynObjs = this.getModel().getEntryEntity("entryentity");
        StringBuilder info = new StringBuilder();
        CreditLevelSerivce service = CreditLevelSerivceFactory.newInstance();
        Map scoreRange = service.getCreditScoreRange();
        int max = (Integer)scoreRange.get("max");
        for (int i = 0; i < dynObjs.size(); ++i) {
            String tempStr;
            BigDecimal subScore;
            DynamicObject dynObj = (DynamicObject)dynObjs.get(i);
            BigDecimal days = dynObj.getBigDecimal("outdatenum");
            if (days.compareTo(BigDecimal.ZERO) == 0) {
                String tempStr2 = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5f71\u50cf\u672a\u4e0a\u4f20\u5929\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"CreditByImageNewFormPlugin_0", (String)"fi-fircm-formplugin", (Object[])new Object[0]), i + 1);
                info.append(tempStr2);
            }
            if ((subScore = dynObj.getBigDecimal("subscore")).compareTo(BigDecimal.ZERO) == 0) {
                tempStr = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u51cf\u5206\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"CreditByImageNewFormPlugin_4", (String)"fi-fircm-formplugin", (Object[])new Object[0]), i + 1);
                info.append(tempStr);
                continue;
            }
            if (subScore.compareTo(BigDecimal.ZERO) >= 0 && subScore.compareTo(BigDecimal.valueOf(max)) <= 0) continue;
            tempStr = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u51cf\u5206\u503c\u7684\u8303\u56f4\u4e3a[0, %2$s]\u3002", (String)"CreditByImageNewFormPlugin_5", (String)"fi-fircm-formplugin", (Object[])new Object[0]), i + 1, max);
            info.append(tempStr);
        }
        if (info.length() > 0) {
            this.getView().showTipNotification(info.toString());
            return false;
        }
        return true;
    }

    private boolean saveData() {
        DynamicObjectCollection dynObjs = this.getModel().getEntryEntity("entryentity");
        ArrayList<DynamicObject> breakRules = new ArrayList<DynamicObject>(8);
        String userId = RequestContext.get().getUserId();
        for (DynamicObject dynObj : dynObjs) {
            DynamicObject breakRule = BusinessDataServiceHelper.newDynamicObject((String)"task_creditbyimagenew");
            Date date = new Date();
            Long id = dynObj.getLong("id");
            if (id > 0L) {
                breakRule.set("id", (Object)id);
            }
            breakRule.set("createtime", (Object)date);
            breakRule.set("modifytime", (Object)date);
            breakRule.set("creator_id", (Object)Long.valueOf(userId));
            breakRule.set("modifier_id", (Object)Long.valueOf(userId));
            breakRule.set("status", (Object)Character.valueOf('C'));
            breakRule.set("enable", dynObj.get("enable"));
            breakRule.set("subscore", dynObj.get("subscore"));
            breakRule.set("outdatenum", dynObj.get("outdatenum"));
            breakRules.add(breakRule);
        }
        DeleteServiceHelper.delete((String)"task_creditbyimagenew", null);
        OperationResult opResult = OperationServiceHelper.executeOperate((String)"save", (String)"task_creditbyimagenew", (DynamicObject[])breakRules.toArray(new DynamicObject[0]), null);
        super.afterSaveOperation(opResult, "task_creditbyimagenew_l", this.getView());
        return opResult.isSuccess();
    }

    private void updateStatus(String opVal) {
        boolean isSuccess = CreditUpdateStatusUtil.updateStatus(this.getView(), this.getModel(), "task_creditbyimagenew", "entryentity", opVal);
        if (isSuccess) {
            super.afterUpdateStatus(opVal, "task_creditbyimagenew_l", this.getView());
        }
    }
}

