/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fircm.formplugin.creditchangerule;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.fi.fircm.business.factory.credit.CreditLevelSerivceFactory;
import kd.fi.fircm.business.service.credit.CreditLevelSerivce;

public class CreditScoreSettingFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public static final String checkBoxScore = "checkbox_add";
    public static final String checkBoxLevel = "checkbox_add2";
    public static final String checkBoxSubScore = "checkbox_sub";
    public static final String checkBoxSubLevel = "checkbox_sub2";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        BasedataEdit start = (BasedataEdit)this.getControl("levelstart");
        BasedataEdit end = (BasedataEdit)this.getControl("levelend");
        BasedataEdit sub = (BasedataEdit)this.getControl("levelend_sub");
        start.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        end.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        sub.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        FormShowParameter showParam = this.getView().getFormShowParameter();
        Map paramMap = showParam.getCustomParams();
        String fromPage = (String)paramMap.get("frompage");
        boolean flag = (Boolean)paramMap.get("flag");
        if ("add".equals(fromPage)) {
            view.setFormTitle(new LocaleString(ResManager.loadKDString((String)"\u4fe1\u7528\u52a0\u5206\u8bbe\u7f6e", (String)"CreditScoreSettingFormPlugin_5", (String)"fi-fircm-formplugin", (Object[])new Object[0])));
            model.setValue("addscore", paramMap.get("addscore"));
            model.setValue("levelstart", paramMap.get("levelstart"));
            model.setValue("levelend", paramMap.get("levelend"));
            if (!flag) {
                model.setValue(checkBoxScore, (Object)Boolean.TRUE);
                view.setEnable(Boolean.FALSE, new String[]{"levelstart", "levelend"});
            } else {
                model.setValue(checkBoxLevel, (Object)Boolean.TRUE);
                view.setEnable(Boolean.FALSE, new String[]{"addscore"});
            }
            view.setVisible(Boolean.FALSE, new String[]{"subscoreflex", "subscoreflex2"});
        } else if ("sub".equals(fromPage)) {
            view.setFormTitle(new LocaleString(ResManager.loadKDString((String)"\u4fe1\u7528\u6263\u5206\u8bbe\u7f6e", (String)"CreditScoreSettingFormPlugin_6", (String)"fi-fircm-formplugin", (Object[])new Object[0])));
            model.setValue("subscore", paramMap.get("subscore"));
            model.setValue("levelend_sub", paramMap.get("sublevel"));
            if (!flag) {
                model.setValue(checkBoxSubScore, (Object)Boolean.TRUE);
                view.setEnable(Boolean.FALSE, new String[]{"levelend_sub"});
            } else {
                model.setValue(checkBoxSubLevel, (Object)Boolean.TRUE);
                view.setEnable(Boolean.FALSE, new String[]{"subscore"});
            }
            view.setVisible(Boolean.FALSE, new String[]{"addscoreflex", "addscoreflex2"});
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            IDataModel model = this.getModel();
            FormShowParameter showParam = this.getView().getFormShowParameter();
            String fromPage = (String)showParam.getCustomParam("frompage");
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            if ("add".equals(fromPage)) {
                boolean checkResult = this.checkData_Add(model, (Boolean)model.getValue(checkBoxScore));
                if (!checkResult) {
                    return;
                }
                dataMap.put("addscore", model.getValue("addscore"));
                dataMap.put("levelstart", model.getValue("levelstart"));
                dataMap.put("levelend", model.getValue("levelend"));
                dataMap.put("flag", model.getValue(checkBoxScore));
            } else if ("sub".equals(fromPage)) {
                boolean checkResult = this.checkData_Sub(model, (Boolean)model.getValue(checkBoxSubScore));
                if (!checkResult) {
                    return;
                }
                dataMap.put("subscore", model.getValue("subscore"));
                dataMap.put("sublevel", model.getValue("levelend_sub"));
                dataMap.put("flag", model.getValue(checkBoxSubScore));
            }
            this.getView().returnDataToParent(dataMap);
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataEntityProperty prop = e.getProperty();
        String name = prop.getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if (checkBoxScore.equals(name) || checkBoxLevel.equals(name) || checkBoxSubScore.equals(name) || checkBoxSubLevel.equals(name)) {
            this.setCheckBox(model, view, name, (Boolean)newValue);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        DynamicObject level;
        BasedataEdit baseData = (BasedataEdit)e.getSource();
        String key = baseData.getKey();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        if ("levelstart".equals(key)) {
            level = (DynamicObject)this.getModel().getValue("levelend");
            if (level != null) {
                QFilter filter = new QFilter("maxvalue", "<", level.get("maxvalue"));
                qFilters.add(filter);
            }
        } else if ("levelend".equals(key) && (level = (DynamicObject)this.getModel().getValue("levelstart")) != null) {
            QFilter filter = new QFilter("maxvalue", ">", level.get("maxvalue"));
            qFilters.add(filter);
        }
        ListShowParameter showParam = (ListShowParameter)e.getFormShowParameter();
        showParam.getListFilterParameter().setQFilters(qFilters);
    }

    private void setCheckBox(IDataModel model, IFormView view, String checkBoxName, boolean newValue) {
        String setCheckBox = null;
        model.beginInit();
        if (checkBoxScore.equals(checkBoxName)) {
            setCheckBox = checkBoxLevel;
            view.setEnable(Boolean.valueOf(!newValue), new String[]{"levelstart", "levelend"});
            view.setEnable(Boolean.valueOf(newValue), new String[]{"addscore"});
        } else if (checkBoxLevel.equals(checkBoxName)) {
            setCheckBox = checkBoxScore;
            view.setEnable(Boolean.valueOf(newValue), new String[]{"levelstart", "levelend"});
            view.setEnable(Boolean.valueOf(!newValue), new String[]{"addscore"});
        } else if (checkBoxSubScore.equals(checkBoxName)) {
            setCheckBox = checkBoxSubLevel;
            view.setEnable(Boolean.valueOf(!newValue), new String[]{"levelend_sub"});
            view.setEnable(Boolean.valueOf(newValue), new String[]{"subscore"});
        } else if (checkBoxSubLevel.equals(checkBoxName)) {
            setCheckBox = checkBoxSubScore;
            view.setEnable(Boolean.valueOf(newValue), new String[]{"levelend_sub"});
            view.setEnable(Boolean.valueOf(!newValue), new String[]{"subscore"});
        }
        model.setValue(setCheckBox, (Object)(!newValue ? 1 : 0));
        model.endInit();
        view.updateView(setCheckBox);
    }

    private boolean checkData_Add(IDataModel model, boolean checkBoxScoreVal) {
        CreditLevelSerivce service = CreditLevelSerivceFactory.newInstance();
        Map scoreRange = service.getCreditScoreRange();
        int max = (Integer)scoreRange.get("max");
        if (checkBoxScoreVal) {
            BigDecimal addScore = (BigDecimal)model.getValue("addscore");
            if (addScore.compareTo(BigDecimal.ZERO) == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u52a0\u5206\u503c\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"CreditScoreSettingFormPlugin_0", (String)"fi-fircm-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (addScore.compareTo(BigDecimal.ZERO) < 0 || addScore.compareTo(BigDecimal.valueOf(max)) > 0) {
                String info = String.format(ResManager.loadKDString((String)"\u52a0\u5206\u503c\u7684\u8303\u56f4\u4e3a[0, %s]\u3002", (String)"CreditScoreSettingFormPlugin_1", (String)"fi-fircm-formplugin", (Object[])new Object[0]), max);
                this.getView().showTipNotification(info);
                return false;
            }
        } else if (model.getValue("levelstart") == null || model.getValue("levelend") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fe1\u7528\u7b49\u7ea7\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"CreditScoreSettingFormPlugin_2", (String)"fi-fircm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkData_Sub(IDataModel model, boolean checkBoxScoreVal) {
        CreditLevelSerivce service = CreditLevelSerivceFactory.newInstance();
        Map scoreRange = service.getCreditScoreRange();
        int max = (Integer)scoreRange.get("max");
        if (checkBoxScoreVal) {
            BigDecimal addScore = (BigDecimal)model.getValue("subscore");
            if (addScore.compareTo(BigDecimal.ZERO) < 0 || addScore.compareTo(BigDecimal.valueOf(max)) > 0) {
                String info = String.format(ResManager.loadKDString((String)"\u51cf\u5206\u503c\u7684\u8303\u56f4\u4e3a[0, %s]\u3002", (String)"CreditScoreSettingFormPlugin_4", (String)"fi-fircm-formplugin", (Object[])new Object[0]), max);
                this.getView().showTipNotification(info);
                return false;
            }
        } else if (model.getValue("levelend_sub") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fe1\u7528\u7b49\u7ea7\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"CreditScoreSettingFormPlugin_2", (String)"fi-fircm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

