/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fircm.formplugin.creditconfig;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class MyCreditConfigEditPlugin
extends AbstractFormPlugin {
    private static final String RICH_TEXT = "richtexteditorap";
    private static final String ATTENTION_POINT = "attentionpoint";
    private static final String MY_CREDIT_SETTING = "my_creditsetting";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String EQUITY_LEVEL = "equitylevel";
    private static final String EQUITY_REMARK = "equityremark";

    public void afterBindData(EventObject e) {
        String attentionPoint = (String)this.getModel().getValue(ATTENTION_POINT);
        if (StringUtils.isEmpty((CharSequence)attentionPoint)) {
            return;
        }
        RichTextEditor richTextEditor = (RichTextEditor)this.getControl(RICH_TEXT);
        richTextEditor.setText(attentionPoint);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operationKey = formOperate.getOperateKey();
        if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"save")) {
            this.verifyEntryEntityIsNull(args);
            String number = (String)this.getModel().getValue("number");
            QFilter numberFilter = new QFilter("number", "=", (Object)number);
            boolean numberExist = QueryServiceHelper.exists((String)MY_CREDIT_SETTING, (QFilter[])new QFilter[]{numberFilter});
            if (!numberExist) {
                this.verifyOrgExistEnableSetting(args);
            }
            RichTextEditor richTextEditor = (RichTextEditor)this.getControl(RICH_TEXT);
            String text = richTextEditor.getText();
            this.getModel().setValue(ATTENTION_POINT, (Object)text);
            this.getModel().setValue("status", (Object)"C");
        }
    }

    private void verifyEntryEntityIsNull(BeforeDoOperationEventArgs args) {
        int rowCount = this.getModel().getEntryRowCount(ENTRY_ENTITY);
        if (rowCount == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4fe1\u7528\u7b49\u7ea7\u4e0e\u6743\u76ca\u8bf4\u660e\u3002", (String)"MyCreditConfigEditPlugin_1", (String)"fi-fircm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        } else {
            for (int i = 0; i < rowCount; ++i) {
                Object equityLevel = this.getModel().getValue(EQUITY_LEVEL, i);
                if (equityLevel == null) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5355\u636e\u4f53\u7b2c%s\u884c\u7684\u4fe1\u7528\u7b49\u7ea7\u3002", (String)"MyCreditConfigEditPlugin_2", (String)"fi-fircm-formplugin", (Object[])new Object[0]), i + 1));
                    args.setCancel(true);
                    return;
                }
                Object equityRemark = this.getModel().getValue(EQUITY_REMARK, i);
                if (equityRemark != null) continue;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5355\u636e\u4f53\u7b2c%s\u884c\u7684\u6743\u76ca\u8bf4\u660e\u3002", (String)"MyCreditConfigEditPlugin_3", (String)"fi-fircm-formplugin", (Object[])new Object[0]), i + 1));
                args.setCancel(true);
                return;
            }
        }
    }

    private void verifyOrgExistEnableSetting(BeforeDoOperationEventArgs args) {
        DynamicObject createOrg = (DynamicObject)this.getModel().getValue("createorg");
        String orgId = createOrg.getString("masterid");
        String orgName = createOrg.getString("name");
        QFilter orgFilter = new QFilter("createorg", "=", (Object)Long.valueOf(orgId));
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)MY_CREDIT_SETTING, (String)"number", (QFilter[])new QFilter[]{orgFilter, enableFilter});
        if (dynamicObject != null) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u5df2\u7ecf\u521b\u5efa\u53ef\u7528\u72b6\u6001\u7684\u6211\u7684\u4fe1\u7528\u914d\u7f6e\u3002", (String)"MyCreditConfigEditPlugin_0", (String)"fi-fircm-formplugin", (Object[])new Object[0]), orgName));
            args.setCancel(true);
        }
    }
}

