/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fircm.formplugin.creditlevel;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fircm.business.factory.credit.CreditChangeRuleServiceFactory;
import kd.fi.fircm.business.factory.credit.CreditLevelSerivceFactory;
import kd.fi.fircm.business.service.credit.CreditLevelSerivce;
import kd.fi.fircm.task.util.FircmLicenseUtil;

public class CreditLevelListPlugin
extends AbstractFormPlugin
implements ItemClickListener {
    private static final Log log = LogFactory.getLog(CreditLevelListPlugin.class);

    public void preOpenForm(PreOpenFormEventArgs e) {
        FircmLicenseUtil.checkGroupLicense((PreOpenFormEventArgs)e);
    }

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initFormData();
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if ("donothing_save".equals(key)) {
            IDataModel model = this.getModel();
            if (!this.checkData(model)) {
                return;
            }
            if (this.isChangedScoreRange() && this.isExistCreditFiles()) {
                ConfirmCallBackListener call = new ConfirmCallBackListener("scorerangechange");
                String info = ResManager.loadKDString((String)"\u4fe1\u7528\u5206\u6570\u8303\u56f4\u5c06\u6539\u53d8\uff0c\u9700\u8981\u5230\u4fe1\u7528\u6863\u6848\u8fdb\u884c\u521d\u59cb\u5316\u64cd\u4f5c\u624d\u80fd\u6b63\u5e38\u4f7f\u7528\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"CreditLevelListPlugin_19", (String)"fi-fircm-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(info, MessageBoxOptions.YesNo, call);
            } else {
                this.saveData(model);
            }
        } else if ("donothing_deleteline".equals(key)) {
            this.showDeleteConfirm();
        } else if ("donothing_scorerange".equals(key)) {
            this.setScoreRange();
        }
    }

    private void initFormData() {
        IDataModel model = this.getModel();
        model.deleteEntryData("creditlist");
        IPageCache pageCache = this.getPageCache();
        QFilter statusFilter = new QFilter("status", "!=", (Object)Character.valueOf('D'));
        DynamicObject[] creditLevels = BusinessDataServiceHelper.load((String)"task_creditlevel", (String)"id, number, name, maxvalue, minvalue, defaultlevel, defaultvalue, describe", (QFilter[])new QFilter[]{statusFilter}, (String)"maxvalue desc");
        int length = creditLevels.length;
        if (length != 0) {
            model.batchCreateNewEntryRow("creditlist", length);
        } else {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("maxval", "100");
            params.put("maxval_copy", "100");
            params.put("minval", "0");
            params.put("minval_copy", "0");
            pageCache.put(params);
        }
        TextEdit tx = (TextEdit)this.getControl("number");
        for (int i = 0; i < length; ++i) {
            model.beginInit();
            DynamicObject dyn = creditLevels[i];
            model.setValue("number", dyn.get("number"), i);
            model.setValue("name", dyn.get("name"), i);
            model.setValue("maxvalue", dyn.get("maxvalue"), i);
            if (i == 0) {
                pageCache.put("maxval", String.valueOf(dyn.getInt("maxvalue")));
                pageCache.put("maxval_copy", String.valueOf(dyn.getInt("maxvalue")));
            }
            model.setValue("minvalue", dyn.get("minvalue"), i);
            if (i == length - 1) {
                pageCache.put("minval", String.valueOf(dyn.getInt("minvalue")));
                pageCache.put("minval_copy", String.valueOf(dyn.getInt("minvalue")));
            }
            model.setValue("defaultlevel", dyn.get("defaultlevel"), i);
            model.setValue("defaultvalue", dyn.get("defaultvalue"), i);
            model.setValue("describe", dyn.get("describe"), i);
            model.setValue("crelevid", dyn.get("id"), i);
            model.endInit();
            tx.setEnable("number", false, i);
            this.getView().updateView("creditlist");
        }
        model.setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        int maxVal = Integer.parseInt(this.getPageCache().get("maxval"));
        DynamicObjectCollection dycn = model.getEntryEntity("creditlist");
        int curIndex = model.getEntryCurrentRowIndex("creditlist");
        ChangeData changeData = e.getChangeSet()[0];
        if ("number".equals(propName)) {
            if (this.checkRepeat(model, changeData, curIndex, "number")) {
                view.showTipNotification(ResManager.loadKDString((String)"\u4fe1\u7528\u7b49\u7ea7\u7f16\u7801\u4e0d\u5141\u8bb8\u91cd\u590d\u3002", (String)"CreditLevelListPlugin_0", (String)"fi-fircm-formplugin", (Object[])new Object[0]));
            }
        } else if ("name".equals(propName)) {
            if (this.checkRepeat(model, changeData, curIndex, "name")) {
                view.showTipNotification(ResManager.loadKDString((String)"\u4fe1\u7528\u7b49\u7ea7\u540d\u79f0\u4e0d\u5141\u8bb8\u91cd\u590d\u3002", (String)"CreditLevelListPlugin_1", (String)"fi-fircm-formplugin", (Object[])new Object[0]));
            }
        } else if ("minvalue".equals(propName) || "maxvalue".equals(propName)) {
            int minValue = (Integer)model.getValue("minvalue", curIndex);
            int maxValue = (Integer)model.getValue("maxvalue", curIndex);
            int defValue = ((BigDecimal)model.getValue("defaultvalue", curIndex)).intValue();
            if (minValue >= maxValue && maxValue != 0) {
                model.setValue(propName, changeData.getOldValue(), curIndex);
                if ("minvalue".equals(propName)) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u5206\u6570\u4e0b\u9650\u5e94\u5c0f\u4e8e\u5206\u6570\u4e0a\u9650\u3002", (String)"CreditLevelListPlugin_2", (String)"fi-fircm-formplugin", (Object[])new Object[0]));
                } else {
                    view.showTipNotification(ResManager.loadKDString((String)"\u5206\u6570\u4e0a\u9650\u5e94\u5927\u4e8e\u5206\u6570\u4e0b\u9650\u3002", (String)"CreditLevelListPlugin_3", (String)"fi-fircm-formplugin", (Object[])new Object[0]));
                }
                minValue = (Integer)model.getValue("minvalue", curIndex);
                maxValue = (Integer)model.getValue("maxvalue", curIndex);
            }
            if (minValue == 0 && maxValue == 0) {
                model.setValue("defaultvalue", (Object)BigDecimal.ZERO, curIndex);
            } else if ((defValue < minValue || defValue >= maxValue && maxValue <= maxVal) && maxValue != 0) {
                model.setValue("defaultvalue", (Object)BigDecimal.valueOf(maxValue - 1), curIndex);
            }
        } else if ("defaultlevel".equals(propName)) {
            boolean defLevel = (Boolean)model.getValue("defaultlevel", curIndex);
            if (defLevel) {
                for (int i = 0; i < dycn.size(); ++i) {
                    boolean temp = (Boolean)model.getValue("defaultlevel", i);
                    if (i == curIndex || !temp) continue;
                    model.setValue("defaultlevel", (Object)Boolean.FALSE, i);
                }
            }
        } else if ("defaultvalue".equals(propName)) {
            int curRowMin = (Integer)model.getValue("minvalue", curIndex);
            int curRowMax = (Integer)model.getValue("maxvalue", curIndex);
            int defValue = ((BigDecimal)model.getValue("defaultvalue", curIndex)).intValue();
            if (defValue < curRowMin || defValue > curRowMax || defValue == curRowMax && curRowMax != maxVal) {
                int newDefValue = curRowMax == maxVal ? maxVal : curRowMax - 1;
                model.setValue("defaultvalue", (Object)BigDecimal.valueOf(newDefValue), curIndex);
                view.showTipNotification(ResManager.loadKDString((String)"\u9ed8\u8ba4\u5206\u6570\u4e0d\u80fd\u8d85\u51fa\u8be5\u7b49\u7ea7\u7684\u5206\u6570\u8303\u56f4", (String)"CreditLevelListPlugin_4", (String)"fi-fircm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        RowDataEntity row = e.getRowDataEntities()[0];
        int rowIndex = row.getRowIndex();
        IDataModel model = this.getModel();
        if (rowIndex == 0) {
            int maxval = Integer.parseInt(this.getPageCache().get("maxval"));
            model.setValue("maxvalue", (Object)maxval, rowIndex);
        } else {
            int minval = Integer.parseInt(this.getPageCache().get("minval"));
            int lastMinVal = (Integer)model.getValue("minvalue", rowIndex - 1);
            if (lastMinVal > minval) {
                model.setValue("maxvalue", (Object)lastMinVal, rowIndex);
            }
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        int[] rowIndexs = e.getRowIndexs();
        String crelevid = (String)this.getModel().getValue("crelevid", rowIndexs[0]);
        if (StringUtils.isNotEmpty((String)crelevid)) {
            this.getPageCache().put("isDeleteRow", "true");
        }
    }

    private void showDeleteConfirm() {
        EntryGrid entry = (EntryGrid)this.getControl("creditlist");
        int[] selRows = entry.getSelectRows();
        if (selRows.length > 0) {
            ArrayList<Long> selIDs = new ArrayList<Long>();
            for (int i = 0; i < selRows.length; ++i) {
                String selID = (String)this.getModel().getValue("crelevid", selRows[i]);
                if (!StringUtils.isNotEmpty((String)selID)) continue;
                selIDs.add(Long.valueOf(selID));
            }
            if (this.checkReference(selIDs)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u4fe1\u7528\u7b49\u7ea7\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"CreditLevelListPlugin_5", (String)"fi-fircm-formplugin", (Object[])new Object[0]));
                return;
            }
            ConfirmCallBackListener confirm = new ConfirmCallBackListener("deleterow");
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u5220\u9664\u5417\uff1f", (String)"CreditLevelListPlugin_16", (String)"fi-fircm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirm);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"CreditLevelListPlugin_17", (String)"fi-fircm-formplugin", (Object[])new Object[0]));
        }
    }

    private void saveData(IDataModel model) {
        DynamicObjectCollection dync = model.getEntryEntity("creditlist");
        if (dync == null || dync.size() == 0) {
            return;
        }
        DynamicObject[] dAry = new DynamicObject[dync.size()];
        long userId = RequestContext.get().getCurrUserId();
        HashMap<Long, String> creditLevelNameMap = new HashMap<Long, String>();
        for (int i = 0; i < dync.size(); ++i) {
            DynamicObject dt = BusinessDataServiceHelper.newDynamicObject((String)"task_creditlevel");
            String id = ((DynamicObject)dync.get(i)).getString("crelevid");
            if (StringUtils.isNotEmpty((String)id)) {
                dt.set("id", (Object)Long.valueOf(id));
                creditLevelNameMap.put(Long.valueOf(id), ((DynamicObject)dync.get(i)).getString("name"));
            }
            dt.set("number", ((DynamicObject)dync.get(i)).get("number"));
            dt.set("name", ((DynamicObject)dync.get(i)).get("name"));
            dt.set("maxvalue", ((DynamicObject)dync.get(i)).get("maxvalue"));
            dt.set("minvalue", ((DynamicObject)dync.get(i)).get("minvalue"));
            dt.set("defaultlevel", ((DynamicObject)dync.get(i)).get("defaultlevel"));
            dt.set("defaultvalue", ((DynamicObject)dync.get(i)).get("defaultvalue"));
            dt.set("describe", ((DynamicObject)dync.get(i)).get("describe"));
            dt.set("createtime", (Object)new Date());
            dt.set("modifytime", (Object)new Date());
            dt.set("status", (Object)"C");
            dt.set("creator", (Object)userId);
            dt.set("modifier", (Object)userId);
            dt.set("enable", (Object)Character.valueOf('1'));
            dAry[i] = dt;
        }
        OperationResult operResult = null;
        try (TXHandle h = TX.requiresNew((String)"fircm_creditlevel");){
            try {
                DeleteServiceHelper.delete((String)"task_creditlevel", null);
                operResult = OperationServiceHelper.executeOperate((String)"save", (String)"task_creditlevel", (DynamicObject[])dAry, null);
            }
            catch (Throwable e) {
                h.markRollback();
                log.error(" save creditlevel error:  ", e);
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4fe1\u7528\u7b49\u7ea7\u4fdd\u5b58\u5931\u8d25:%1$s", (String)"CreditLevelListPlugin_8", (String)"fi-fircm-formplugin", (Object[])new Object[0]), e.getMessage()));
                if (h != null) {
                    if (var9_9 != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable) {
                            var9_9.addSuppressed(throwable);
                        }
                    } else {
                        h.close();
                    }
                }
                return;
            }
        }
        if (operResult.isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"CreditLevelListPlugin_6", (String)"fi-fircm-formplugin", (Object[])new Object[0]));
            this.getView().updateView();
            this.updateLevelOfCreditFiles();
            CreditChangeRuleServiceFactory.newInstance().initScoreChangedLimitIfNotExist();
            this.updateSubScoreRule(creditLevelNameMap);
        } else {
            this.getView().showTipNotification(operResult.getMessage());
        }
    }

    private void updateSubScoreRule(Map<Long, String> creditLevelNameMap) {
        QFilter levelFilters;
        QFilter flagFilters = new QFilter("flag", "=", (Object)Character.valueOf('1'));
        String selectField = "sublevel.id, subscorestr";
        QFilter statusFilters = new QFilter("status", "!=", (Object)Character.valueOf('D'));
        DynamicObject[] subScoreRules = BusinessDataServiceHelper.load((String)"fircm_subscorerule", (String)selectField, (QFilter[])new QFilter[]{statusFilters, levelFilters = new QFilter("sublevel.id", "in", creditLevelNameMap.keySet()), flagFilters});
        if (subScoreRules == null || subScoreRules.length == 0) {
            return;
        }
        for (int i = 0; i < subScoreRules.length; ++i) {
            DynamicObject subScoreRule = subScoreRules[i];
            String creditLevelName = creditLevelNameMap.get(subScoreRule.getLong("sublevel.id"));
            String subScoreStr = String.format(ResManager.loadKDString((String)"\u51cf\u5206\u81f3 %s", (String)"SubScoreRuleEditPlugin_1", (String)"fi-fircm-formplugin", (Object[])new Object[0]), creditLevelName);
            subScoreRule.set("subscorestr", (Object)subScoreStr);
        }
        SaveServiceHelper.update((DynamicObject[])subScoreRules);
    }

    private boolean checkData(IDataModel model) {
        DynamicObjectCollection dync = model.getEntryEntity("creditlist");
        if (dync == null || dync.size() == 0) {
            return false;
        }
        StringBuilder errMsg = new StringBuilder();
        boolean defLevelFlag = false;
        for (int i = 0; i < dync.size(); ++i) {
            String number = ((DynamicObject)dync.get(i)).getString("number");
            String name = ((DynamicObject)dync.get(i)).getString("name");
            if (StringUtils.isEmpty((String)number) && StringUtils.isEmpty((String)name)) {
                errMsg.append(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7b2c%s\u884c\u4fe1\u7528\u7b49\u7ea7\u7f16\u7801\u3001\u4fe1\u7528\u7b49\u7ea7\u540d\u79f0\u3002", (String)"CreditLevelListPlugin_11", (String)"fi-fircm-formplugin", (Object[])new Object[0]), i + 1));
                this.getView().showTipNotification(errMsg.toString());
                return false;
            }
            if (StringUtils.isEmpty((String)number)) {
                errMsg.append(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7b2c%s\u884c\u4fe1\u7528\u7b49\u7ea7\u7f16\u7801\u3002", (String)"CreditLevelListPlugin_22", (String)"fi-fircm-formplugin", (Object[])new Object[0]), i + 1));
            }
            if (StringUtils.isEmpty((String)name)) {
                errMsg.append(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7b2c%s\u884c\u4fe1\u7528\u7b49\u7ea7\u540d\u79f0\u3002", (String)"CreditLevelListPlugin_23", (String)"fi-fircm-formplugin", (Object[])new Object[0]), i + 1));
            }
            if (errMsg.length() > 0) {
                this.getView().showTipNotification(errMsg.toString());
                return false;
            }
            if (!((DynamicObject)dync.get(i)).getBoolean("defaultlevel")) continue;
            defLevelFlag = true;
        }
        boolean isPass = this.checkContinuity(model);
        if (!isPass) {
            return false;
        }
        if (!defLevelFlag) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6307\u5b9a\u4e00\u4e2a\u9ed8\u8ba4\u7b49\u7ea7\u3002", (String)"CreditLevelListPlugin_12", (String)"fi-fircm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkContinuity(IDataModel model) {
        DynamicObjectCollection levels = model.getEntryEntity("creditlist");
        int minVal = Integer.parseInt(this.getPageCache().get("minval"));
        int maxVal = Integer.parseInt(this.getPageCache().get("maxval"));
        int[] scoreInterval = new int[maxVal - minVal + 1];
        int size = levels.size();
        for (int j = 0; j < size; ++j) {
            int levelMax;
            int levelMin = (Integer)model.getValue("minvalue", j);
            if (levelMin >= (levelMax = ((Integer)model.getValue("maxvalue", j)).intValue())) {
                String info = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u6570\u4e0b\u9650\u5e94\u5c0f\u4e8e\u5206\u6570\u4e0a\u9650\uff1b", (String)"CreditLevelListPlugin_21", (String)"fi-fircm-formplugin", (Object[])new Object[0]), j + 1);
                this.getView().showTipNotification(info);
                return false;
            }
            if (levelMin < minVal || levelMax > maxVal) {
                String info = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u4fe1\u7528\u7b49\u7ea7\u8bbe\u7f6e\u7684\u5206\u6570\u8303\u56f4\u5e94\u5728[%2$s,%3$s]\u5185\u3002", (String)"CreditLevelListPlugin_20", (String)"fi-fircm-formplugin", (Object[])new Object[0]), j + 1, minVal, maxVal);
                this.getView().showTipNotification(info);
                return false;
            }
            if (levelMax < maxVal) {
                --levelMax;
            }
            for (int i = levelMin; i <= levelMax; ++i) {
                if (scoreInterval[i - minVal] > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5404\u4fe1\u7528\u7b49\u7ea7\u7684\u5206\u6570\u8303\u56f4\u4e0d\u80fd\u91cd\u53e0\u3002", (String)"CreditLevelListPlugin_13", (String)"fi-fircm-formplugin", (Object[])new Object[0]));
                    return false;
                }
                scoreInterval[i - minVal] = 1;
            }
        }
        for (int i = 0; i <= maxVal - minVal; ++i) {
            if (scoreInterval[i] != 0) continue;
            String info = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4fe1\u7528\u5206\u6570\u8303\u56f4\u662f[%1$s,%2$s]\uff0c\u5404\u4fe1\u7528\u7b49\u7ea7\u7684\u5206\u6570\u8303\u56f4\u5fc5\u987b\u8fde\u7eed\u3002", (String)"CreditLevelListPlugin_18", (String)"fi-fircm-formplugin", (Object[])new Object[0]), minVal, maxVal);
            this.getView().showTipNotification(info);
            return false;
        }
        return true;
    }

    private boolean checkRepeat(IDataModel model, ChangeData changeData, int curIndex, String fieldName) {
        String newValue;
        DynamicObjectCollection dync = model.getEntryEntity("creditlist");
        String string = newValue = "name".equals(fieldName) ? ((OrmLocaleValue)model.getValue(fieldName, curIndex)).getLocaleValue() : (String)model.getValue(fieldName, curIndex);
        if (StringUtils.isEmpty((String)newValue)) {
            return false;
        }
        for (int i = 0; i < dync.size(); ++i) {
            String value;
            String string2 = value = "name".equals(fieldName) ? ((DynamicObject)dync.get(i)).getLocaleString(fieldName).getLocaleValue() : ((DynamicObject)dync.get(i)).getString(fieldName);
            if (i == curIndex || !newValue.trim().equals(value)) continue;
            model.setValue(fieldName, null, curIndex);
            return true;
        }
        return false;
    }

    private boolean checkReference(List<Long> selIDs) {
        if (selIDs.size() == 0) {
            return false;
        }
        QFilter flagFil = new QFilter("flag", "=", (Object)Character.valueOf('1'));
        QFilter commonRuleFil = new QFilter("levelstart", "in", selIDs).or(new QFilter("levelend", "in", selIDs));
        boolean result0 = QueryServiceHelper.exists((String)"task_credit_commonrule", (QFilter[])new QFilter[]{flagFil, commonRuleFil});
        QFilter withdrawalFil = new QFilter("sublevel", "in", selIDs);
        boolean result1 = QueryServiceHelper.exists((String)"task_creditbywithdrawal", (QFilter[])new QFilter[]{flagFil, withdrawalFil});
        QFilter creditAppFil = new QFilter("creditlevel", "in", selIDs);
        boolean result2 = QueryServiceHelper.exists((String)"task_creditappwaittime", (QFilter[])new QFilter[]{creditAppFil});
        QFilter creditEquity = new QFilter("entryentity.equitylevel", "in", selIDs);
        boolean result3 = QueryServiceHelper.exists((String)"my_creditsetting", (QFilter[])new QFilter[]{creditEquity});
        return result0 || result1 || result2 || result3;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String flag;
        super.beforeClosed(e);
        if (this.isChangedScoreRange()) {
            this.getModel().setDataChanged(true);
        }
        boolean isChanged = this.getModel().getDataChanged();
        String isDelRow = this.getPageCache().get("isDeleteRow");
        if (!(!isChanged && isDelRow == null || (flag = this.getPageCache().get("flag")) != null && "1".equals(flag))) {
            ConfirmCallBackListener close = new ConfirmCallBackListener("exit");
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u6539\u53d8\uff0c\u662f\u5426\u7ee7\u7eed\u9000\u51fa\uff1f", (String)"CreditLevelListPlugin_15", (String)"fi-fircm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, close);
            e.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if ("exit".equals(callBackId)) {
            if (event.getResult() == MessageBoxResult.Yes) {
                this.getPageCache().put("flag", "1");
                this.getView().close();
            }
        } else if ("deleterow".equals(callBackId)) {
            if (event.getResult() == MessageBoxResult.Yes) {
                EntryGrid entry = (EntryGrid)this.getControl("creditlist");
                int[] selRows = entry.getSelectRows();
                this.getModel().deleteEntryRows("creditlist", selRows);
            }
        } else if ("scorerangechange".equals(callBackId) && event.getResult() == MessageBoxResult.Yes) {
            this.saveData(this.getModel());
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        Map returnData = (Map)event.getReturnData();
        if (returnData == null) {
            return;
        }
        if ("scorerange".equals(event.getActionId())) {
            this.getPageCache().put("maxval", (String)returnData.get("maxval"));
            this.getPageCache().put("minval", (String)returnData.get("minval"));
        }
    }

    private void setScoreRange() {
        FormShowParameter show = new FormShowParameter();
        show.setFormId("task_creditscorerange");
        show.getOpenStyle().setShowType(ShowType.Modal);
        show.setCustomParam("minval", (Object)this.getPageCache().get("minval"));
        show.setCustomParam("maxval", (Object)this.getPageCache().get("maxval"));
        CloseCallBack close = new CloseCallBack((IFormPlugin)this, "scorerange");
        show.setCloseCallBack(close);
        this.getView().showForm(show);
    }

    private boolean isChangedScoreRange() {
        IPageCache pageCache = this.getPageCache();
        int minval = Integer.parseInt(pageCache.get("minval"));
        int maxval = Integer.parseInt(pageCache.get("maxval"));
        int minval_copy = Integer.parseInt(pageCache.get("minval_copy"));
        int maxval_copy = Integer.parseInt(pageCache.get("maxval_copy"));
        return minval != minval_copy || maxval != maxval_copy;
    }

    private boolean isExistCreditFiles() {
        QFilter statusFilter = new QFilter("status", "!=", (Object)Character.valueOf('D'));
        return QueryServiceHelper.exists((String)"task_creditfiles", (QFilter[])new QFilter[]{statusFilter});
    }

    private void updateLevelOfCreditFiles() {
        CreditLevelSerivce serivce = CreditLevelSerivceFactory.newInstance();
        String algoKey = CreditLevelListPlugin.class + ".updateCreditFilesLevel()";
        QFilter statusFilter = new QFilter("status", "!=", (Object)Character.valueOf('D'));
        try (DataSet creditFiles = QueryServiceHelper.queryDataSet((String)algoKey, (String)"task_creditfiles", (String)"id,creditlevel,creditvalue", (QFilter[])new QFilter[]{statusFilter}, null);){
            String sql = "update t_tk_creditfiles set fcreditlevel=? where fid=?";
            ArrayList<Object[]> params = new ArrayList<Object[]>();
            for (Row row : creditFiles) {
                long id = row.getLong("id");
                long levelId = row.getLong("creditlevel");
                BigDecimal score = row.getBigDecimal("creditvalue");
                DynamicObject creditLevel = serivce.getCreditLevel(score);
                if (creditLevel == null) continue;
                if (levelId != creditLevel.getLong("id")) {
                    Object[] param = new Object[]{creditLevel.getLong("id"), id};
                    params.add(param);
                }
                if (params.size() != 1000) continue;
                DB.executeBatch((DBRoute)DBRoute.of((String)"fi"), (String)sql, params);
                params.clear();
            }
            if (params.size() > 0) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"fi"), (String)sql, params);
            }
        }
    }
}

