/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fircm.formplugin.operationmonitor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fircm.task.util.FircmLicenseUtil;

public class CreditModifyLogListPlugin
extends AbstractListPlugin {
    private static final String TYPE_SYSTEM = "fi-fircm-formplugin";
    private List<FilterColumn> commFilCols = new ArrayList<FilterColumn>(8);
    private List<FilterColumn> fastFilCols = new ArrayList<FilterColumn>(8);

    public void preOpenForm(PreOpenFormEventArgs e) {
        FircmLicenseUtil.checkGroupLicense((PreOpenFormEventArgs)e);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if (StringUtils.equals((CharSequence)"billno", (CharSequence)fieldName)) {
            int rowIndex = args.getHyperLinkClickEvent().getRowIndex();
            ListSelectedRowCollection selectedRows = ((BillList)this.getView().getControl("billlistap")).getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)selectedRows)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u5fd7\u3002", (String)"CreditModifyLogListPlugin_0", (String)TYPE_SYSTEM, (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            Long rowID = this.getSelectRowId(selectedRows, rowIndex);
            if (rowID == null || rowID == 0L) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u65e5\u5fd7\u3002", (String)"CreditModifyLogListPlugin_1", (String)TYPE_SYSTEM, (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObject logObj = this.getCreditModifyLog(rowID);
            if (logObj == null) {
                return;
            }
            String pkIdStr = logObj.getString("billid");
            Long pkId = 0L;
            try {
                pkId = Long.valueOf(pkIdStr);
            }
            catch (NumberFormatException e) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u67e5\u770b\u5f02\u6784\u7cfb\u7edf\u5355\u636e\u3002", (String)"CreditModifyLogListPlugin_2", (String)TYPE_SYSTEM, (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String billEntity = logObj.getString("billentity").trim();
            BillShowParameter parameter = new BillShowParameter();
            parameter.setStatus(OperationStatus.VIEW);
            parameter.setBillStatus(BillOperationStatus.AUDIT);
            parameter.setHasRight(true);
            parameter.setPkId((Object)pkId);
            parameter.setFormId(billEntity);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.addCustPlugin("kd.bos.ext.fircm.formplugin.CreditHideBillMenuPlugin");
            this.getView().showForm((FormShowParameter)parameter);
            args.setCancel(true);
        }
    }

    private Long getSelectRowId(ListSelectedRowCollection selectedRows, int rowIndex) {
        for (int i = 0; i < selectedRows.size(); ++i) {
            ListSelectedRow listSelectedRow = selectedRows.get(i);
            int rowKey = listSelectedRow.getRowKey();
            if (rowIndex != rowKey) continue;
            return Long.valueOf(selectedRows.get(i).getPrimaryKeyValue().toString());
        }
        return null;
    }

    private DynamicObject getCreditModifyLog(Long rowID) {
        QFilter filter = new QFilter("id", "=", (Object)rowID);
        DynamicObject loObj = QueryServiceHelper.queryOne((String)"task_creditmodifylog", (String)"billtopic,billentity,billid", (QFilter[])new QFilter[]{filter});
        if (loObj == null) {
            return null;
        }
        return loObj;
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.commFilCols = args.getCommonFilterColumns();
        this.fastFilCols = args.getFastFilterColumns();
        this.rebuildCommonFilter();
    }

    private void rebuildCommonFilter() {
        block9: {
            String originalType;
            Map<String, Object> paramMap;
            block8: {
                paramMap = this.getCustomParams();
                originalType = String.valueOf(paramMap.get("Creditfiles"));
                if (!"creditfilesList_link".equals(originalType) && !"creditfileslist_btn".equals(originalType)) break block8;
                for (FilterColumn fastFilterColumn : this.fastFilCols) {
                    if (!"raiser.number".equals(fastFilterColumn.getFieldName())) continue;
                    Object userNumber = paramMap.get("usernumber");
                    if (userNumber instanceof List) {
                        fastFilterColumn.setDefaultValues((List)userNumber);
                        continue;
                    }
                    if (!(userNumber instanceof String)) continue;
                    fastFilterColumn.setDefaultValue((String)userNumber);
                }
                if ("creditfileslist_btn".equals(originalType)) {
                    return;
                }
                for (FilterColumn filterColumn : this.commFilCols) {
                    CharSequence s0;
                    CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                    String fieldName = commonFilterColumn.getFieldName();
                    if ("modifytype".equals(fieldName)) {
                        List types = (List)paramMap.get("modifytype");
                        CharSequence t0 = (CharSequence)types.get(0);
                        CharSequence t1 = (CharSequence)types.get(1);
                        commonFilterColumn.setDefaultValues(new Object[]{t0, t1});
                        continue;
                    }
                    if (!"modifysource".equals(fieldName)) continue;
                    List sources = (List)paramMap.get("modifysource");
                    if (sources.size() == 3) {
                        s0 = (CharSequence)sources.get(0);
                        CharSequence s1 = (CharSequence)sources.get(1);
                        CharSequence s2 = (CharSequence)sources.get(2);
                        commonFilterColumn.setDefaultValues(new Object[]{s0, s1, s2});
                        continue;
                    }
                    s0 = (CharSequence)sources.get(0);
                    commonFilterColumn.setDefaultValues(new Object[]{s0});
                }
                break block9;
            }
            if (!"fromEasVoucher".equals(originalType)) break block9;
            for (FilterColumn fastFilterColumn : this.fastFilCols) {
                if (!"raiser.name".equals(fastFilterColumn.getFieldName())) continue;
                Object obj = paramMap.get("username");
                if (obj instanceof String) {
                    fastFilterColumn.setDefaultValue(String.valueOf(obj));
                    continue;
                }
                if (!(obj instanceof List)) continue;
                List names = (List)paramMap.get("username");
                fastFilterColumn.setDefaultValues(new Object[]{names});
            }
        }
    }

    private Map<String, Object> getCustomParams() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        return paramMap;
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.getQFilters().add(new QFilter("status", "!=", (Object)Character.valueOf('D')));
        Map<String, Object> paramMap = this.getCustomParams();
        Object userNumber = paramMap.get("usernumber");
        if (userNumber == null) {
            return;
        }
        if (userNumber instanceof List) {
            e.getQFilters().add(new QFilter("raiser.number", "in", (Object)((List)userNumber)));
        } else if (userNumber instanceof String) {
            e.getQFilters().add(new QFilter("raiser.number", "=", (Object)((String)userNumber)));
        }
    }
}

