/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fircm.formplugin.subscorerule;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class SubScoreDistributeListPlugin
extends AbstractListPlugin
implements ClickListener {
    private static final Log log = LogFactory.getLog(SubScoreDistributeListPlugin.class);
    private FormShowParameter paramter;

    public void initialize() {
        super.initialize();
        this.paramter = this.getView().getFormShowParameter();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button cancelBtn = (Button)this.getView().getControl("btncancel");
        cancelBtn.addClickListener((ClickListener)this);
        Button okBtn = (Button)this.getView().getControl("btnok");
        okBtn.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        QFilter qfilter = new QFilter("enable", "=", (Object)"1");
        String selectField = "bizbill.name,bizbill.id";
        DynamicObject[] taskbills = BusinessDataServiceHelper.load((String)"fircm_creditarg", (String)selectField, (QFilter[])new QFilter[]{qfilter});
        for (int i = 0; i < taskbills.length; ++i) {
            this.getModel().createNewEntryRow("entryentity");
            DynamicObject dynObj = taskbills[i];
            this.getModel().setValue("taskbillname", dynObj.get("bizbill.name"), i);
            this.getModel().setValue("taskbillid", dynObj.get("bizbill.id"), i);
        }
        this.getView().updateView("entryentity");
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        if ("btnok".equalsIgnoreCase(c.getKey())) {
            this.distributeSubScoreRule();
        } else if ("btncancel".equalsIgnoreCase(c.getKey())) {
            this.getView().close();
        }
    }

    private void distributeSubScoreRule() {
        List<String> taskBillIds = this.getCurrentSelector();
        if (CollectionUtils.isEmpty(taskBillIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"SubScoreDistributeListPlugin_0", (String)"fi-fircm-formplugin", (Object[])new Object[0]));
            return;
        }
        List subScoreRuleIds = (List)this.paramter.getCustomParam("subScoreRuleList");
        this.saveData(taskBillIds, subScoreRuleIds);
        this.getView().returnDataToParent((Object)"assignok");
        this.getView().close();
    }

    private void saveData(List<String> taskBillIds, List<Long> subScoreRuleIds) {
        ArrayList<DynamicObject> saveDataList = new ArrayList<DynamicObject>();
        for (String taskBillId : taskBillIds) {
            for (Long subScoreRuleId : subScoreRuleIds) {
                if (this.checkIsExist(taskBillId, subScoreRuleId)) continue;
                DynamicObject distributeQuery = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fircm_subscoredisquery"));
                distributeQuery.set("taskbillid", (Object)taskBillId);
                distributeQuery.set("subscoreruleid", (Object)subScoreRuleId);
                distributeQuery.set("status", (Object)"C");
                distributeQuery.set("enable", (Object)"1");
                distributeQuery.set("createtime", (Object)new Date());
                saveDataList.add(distributeQuery);
            }
        }
        SaveServiceHelper.save((DynamicObject[])saveDataList.toArray(new DynamicObject[0]));
    }

    private boolean checkIsExist(String taskBillId, Long subScoreRuleId) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        filterList.add(new QFilter("taskbillid", "=", (Object)taskBillId));
        filterList.add(new QFilter("subscoreruleid", "=", (Object)subScoreRuleId));
        return QueryServiceHelper.exists((String)"fircm_subscoredisquery", (QFilter[])filterList.toArray(new QFilter[0]));
    }

    private List<String> getCurrentSelector() {
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("entryentity");
        AbstractGrid grid = (AbstractGrid)this.getControl("entryentity");
        int[] selectedRows = grid.getEntryState().getSelectedRows();
        ArrayList<String> taskBillIdList = new ArrayList<String>(8);
        for (int rows : selectedRows) {
            DynamicObject dyo = (DynamicObject)dynamicObjects.get(rows);
            taskBillIdList.add(dyo.getString("taskbillid"));
        }
        return taskBillIdList;
    }
}

