/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fircm.formplugin.subscorerule;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.operate.SaveAndNew;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;

public class SubScoreRuleEditPlugin
extends AbstractFormPlugin
implements ClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit tx = (TextEdit)this.getControl("subscorestr");
        tx.addButtonClickListener((ClickListener)this);
    }

    public void click(EventObject e) {
        super.click(e);
        String key = ((Control)e.getSource()).getKey();
        if ("subscorestr".equals(key)) {
            this.showCreditSettingForm();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        args.getSource();
        if (args.getSource() instanceof SaveAndNew) {
            return;
        }
        if ("save".equals(args.getOperateKey()) && args.getOperationResult().isSuccess()) {
            this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"CreditLevelListPlugin_6", (String)"fi-fircm-formplugin", (Object[])new Object[0]));
            this.getView().close();
        }
    }

    private void showCreditSettingForm() {
        FormShowParameter showParam = new FormShowParameter();
        showParam.setFormId("task_creditscoresetting");
        showParam.getOpenStyle().setShowType(ShowType.Modal);
        IDataModel model = this.getModel();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("frompage", "sub");
        paramMap.put("subscore", model.getValue("subscore"));
        DynamicObject subLevel = (DynamicObject)model.getValue("sublevel");
        if (subLevel != null) {
            paramMap.put("sublevel", subLevel.getPkValue());
        }
        paramMap.put("flag", model.getValue("flag"));
        showParam.setCustomParams(paramMap);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "setscorechange");
        showParam.setCloseCallBack(callBack);
        this.getView().showForm(showParam);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        if ("setscorechange".equals(e.getActionId())) {
            IDataModel model = this.getModel();
            Map dataMap = (Map)returnData;
            model.setValue("subscore", dataMap.get("subscore"));
            model.setValue("sublevel", dataMap.get("sublevel"));
            boolean flag = (Boolean)dataMap.get("flag");
            String subScoreStr = this.buildAddScoreStr(!flag, dataMap.get("subscore"), (DynamicObject)dataMap.get("sublevel"));
            model.setValue("subscorestr", (Object)subScoreStr);
            model.setValue("flag", (Object)(!flag ? 1 : 0));
        }
    }

    private String buildAddScoreStr(boolean flag, Object subScore, DynamicObject subLevel) {
        String subScoreStr = null;
        if (!flag) {
            subScoreStr = String.format(ResManager.loadKDString((String)"\u51cf %s \u5206", (String)"SubScoreRuleEditPlugin_0", (String)"fi-fircm-formplugin", (Object[])new Object[0]), ((BigDecimal)subScore).stripTrailingZeros().toPlainString());
        } else if (subLevel != null) {
            subScoreStr = String.format(ResManager.loadKDString((String)"\u51cf\u5206\u81f3 %s", (String)"SubScoreRuleEditPlugin_1", (String)"fi-fircm-formplugin", (Object[])new Object[0]), subLevel.getString("name"));
        }
        return subScoreStr;
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        Map data = e.getSourceData();
        Optional.ofNullable(data.get("flag")).orElseThrow(() -> new KDBizException(ResManager.loadKDString((String)"\u662f\uff1a\u964d\u7ea7\uff0c\u5426\uff1a\u51cf\u5206\u4e0d\u80fd\u4e3a\u7a7a", (String)"SubScoreRuleListPlugin_5", (String)"fi-fircm-formplugin", (Object[])new Object[0])));
        Boolean flag = (Boolean)data.get("flag");
        if (flag.booleanValue()) {
            Optional.ofNullable(data.get("sublevel.number")).orElseThrow(() -> new KDBizException(ResManager.loadKDString((String)"\u51cf\u5206\u81f3\u4fe1\u7528\u7b49\u7ea7.\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"SubScoreRuleListPlugin_6", (String)"fi-fircm-formplugin", (Object[])new Object[0])));
            Optional.ofNullable(data.get("sublevel.name")).orElseThrow(() -> new KDBizException(ResManager.loadKDString((String)"\u51cf\u5206\u81f3\u4fe1\u7528\u7b49\u7ea7.\u4fe1\u7528\u7b49\u7ea7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"SubScoreRuleListPlugin_7", (String)"fi-fircm-formplugin", (Object[])new Object[0])));
        } else {
            Optional.ofNullable(data.get("subscore")).orElseThrow(() -> new KDBizException(ResManager.loadKDString((String)"\u51cf\u5206\u4e0d\u80fd\u4e3a\u7a7a", (String)"SubScoreRuleListPlugin_8", (String)"fi-fircm-formplugin", (Object[])new Object[0])));
        }
    }
}

