/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fircm.formplugin.workflow;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.engine.extitf.IWorkflowPlugin;
import kd.fi.fircm.business.CreditScoreLockDecorate;
import kd.ssc.task.workflow.dto.CreditPointDTO;

public class AuditBonusStrategyPlugin
implements IWorkflowPlugin {
    private static final Log log = LogFactory.getLog(AuditBonusStrategyPlugin.class);

    public void notify(AgentExecution execution) {
        String billId = execution.getBusinessKey();
        String billNumber = execution.getEntityNumber();
        log.info(String.format("AuditBonusStrategyPlugin start execution ,billId:%s ,billNumber:%s", billId, billNumber));
        DynamicObject dy = QueryServiceHelper.queryOne((String)billNumber, (String)"creator.id,applier.id,billno", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(billId))});
        long creatorId = dy.getLong("applier.id");
        CreditPointDTO dto = new CreditPointDTO(billId, billNumber, creatorId);
        try {
            String billNo = dy.getString("billno");
            dto.setBillNo(billNo);
        }
        catch (Exception e) {
            log.warn(String.format("AuditBonusStrategyPlugin occur an error, param: %s, msg: %s", dto, e));
        }
        String creditPointDTOStr = SerializationUtils.toJsonString((Object)dto);
        CreditScoreLockDecorate.updateCreditPoints((String)creditPointDTOStr);
    }
}

