/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fircm.api.helper;

import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.task.workflow.dto.CreditPointDTO;

public class CreditOpenApiHelper {
    public static final String DIRECT_POINT_METHOD = "directCreditPoints";
    public static final String DEDUCT_POINT_METHOD = "deductCreditPoints";
    public static final String IMAGE_MUNUS_POINT_METHOD = "minusCreditPoints";
    public static final String QUERY_SUBSCORERULE_ID = "getSubScoreRuleIdsByBillNumAndType";
    public static final String IS_CONFIG_ARG = "isConfigCreditArg";
    public static final String SERVER_ERROR_CODE = "400";
    public static final String SERVER_ERROR_MSG = "Operation failed:";
    public static final String SERVER_SUCCESS_MSG = "Operation succeeded.";

    public static void commonValidate(CreditPointDTO dto) {
        CreditOpenApiHelper.checkBillNumberExist(dto);
        CreditOpenApiHelper.checkUserIdExist(dto);
        CreditOpenApiHelper.checkBillExist(dto);
    }

    private static void checkBillNumberExist(CreditPointDTO dto) {
        QFilter billNumberFilter = new QFilter("bizbill", "=", (Object)dto.getBillNumber());
        boolean exists = QueryServiceHelper.exists((String)"fircm_creditarg", (QFilter[])new QFilter[]{billNumberFilter});
        if (exists) {
            return;
        }
        throw new OpenApiException(ApiErrorCode.fromStatusCode((String)SERVER_ERROR_CODE), String.format("%s does not exist in fircm_creditarg.", dto.getBillNumber()), new Object[0]);
    }

    private static void checkUserIdExist(CreditPointDTO dto) {
        QFilter userIdFilter = new QFilter("user", "=", (Object)dto.getUserId());
        boolean exists = QueryServiceHelper.exists((String)"task_creditfiles", (QFilter[])new QFilter[]{userIdFilter});
        if (exists) {
            return;
        }
        throw new OpenApiException(ApiErrorCode.fromStatusCode((String)SERVER_ERROR_CODE), String.format("%s does not exist in task_creditfiles.", dto.getUserId()), new Object[0]);
    }

    private static void checkBillExist(CreditPointDTO dto) {
        boolean exists = QueryServiceHelper.exists((String)dto.getBillNumber(), (Object)dto.getBillId());
        if (exists) {
            return;
        }
        throw new OpenApiException(ApiErrorCode.fromStatusCode((String)SERVER_ERROR_CODE), String.format("%1$s does not exist in %2$s.", dto.getBillId(), dto.getBillNumber()), new Object[0]);
    }
}

