/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fircm.api.openapi;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiGetMapping;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.fi.fircm.api.customerbase.FircmCustomerApi;
import kd.fi.fircm.api.helper.CreditOpenApiHelper;
import kd.fi.fircm.api.openapi.DeductCreditPointRequest;
import kd.fi.fircm.api.openapi.DirectCreditPointRequest;
import kd.fi.fircm.api.openapi.ImageMinusCreditPointRequest;
import kd.fi.fircm.exception.ExceptionUtil;
import kd.ssc.task.workflow.dto.CreditPointDTO;

@ApiController(value="fircm", desc="\u62a5\u8d26\u4fe1\u7528\u7ba1\u7406OpenApi")
@ApiMapping(value="/openapi/fircm")
public class CreditOpenApiService
extends FircmCustomerApi
implements Serializable {
    private static final Log log = LogFactory.getLog(CreditOpenApiService.class);
    private static final long serialVersionUID = -14258846243698401L;

    @ApiPostMapping(value="/directCreditPoints", desc="\u4fe1\u7528\u6309\u5355\u52a0\u5206")
    public CustomApiResult<String> directCreditPoints(@Valid @NotNull @ApiParam(value="\u4fe1\u7528\u52a0\u5206\u8bf7\u6c42") @Valid @NotNull @ApiParam(value="\u4fe1\u7528\u52a0\u5206\u8bf7\u6c42") DirectCreditPointRequest request) {
        log.info(String.format("directCreditPoints, parameter:%s", request));
        try {
            CreditPointDTO dto = new CreditPointDTO(request.getBillId(), request.getBillType(), request.getBillNumber(), request.getUserId().longValue());
            CreditOpenApiHelper.commonValidate(dto);
            String creditPointDtoStr = SerializationUtils.toJsonString((Object)dto);
            this.invokeFircmService("directCreditPoints", creditPointDtoStr);
        }
        catch (Exception e) {
            String stackTrace = ExceptionUtil.getStackTrace((Throwable)e, (int)1000);
            log.error(String.format("directCreditPoints error, msg:%s", stackTrace));
            return CustomApiResult.fail((String)"400", (String)("Operation failed:" + e.getMessage()));
        }
        return CustomApiResult.success((Object)"Operation succeeded.");
    }

    @ApiPostMapping(value="/deductCreditPoints", desc="\u4fe1\u7528\u5ba1\u5355\u6263\u5206")
    public CustomApiResult<String> deductCreditPoints(@Valid @NotNull @ApiParam(value="\u4fe1\u7528\u6263\u5206\u8bf7\u6c42") @Valid @NotNull @ApiParam(value="\u4fe1\u7528\u6263\u5206\u8bf7\u6c42") DeductCreditPointRequest request) {
        log.info(String.format("deductCreditPoints, parameter:%s", request));
        try {
            CreditPointDTO dto = new CreditPointDTO(request.getBillId(), request.getBillType(), request.getBillNumber(), request.getUserId().longValue());
            CreditOpenApiHelper.commonValidate(dto);
            List<Long> subScoreRuleIds = request.getSubScoreRuleIds();
            String modifySource = request.getModifySource();
            String creditPointDtoStr = SerializationUtils.toJsonString((Object)dto);
            String description = request.getDescription();
            this.invokeFircmService("deductCreditPoints", subScoreRuleIds, modifySource, creditPointDtoStr, description);
        }
        catch (Exception e) {
            String stackTrace = ExceptionUtil.getStackTrace((Throwable)e, (int)1000);
            log.error(String.format("deductCreditPoints error, msg:%s", stackTrace));
            return CustomApiResult.fail((String)"400", (String)("Operation failed:" + e.getMessage()));
        }
        return CustomApiResult.success((Object)"Operation succeeded.");
    }

    @ApiPostMapping(value="/imageMinusCreditPoints", desc="\u5f71\u50cf\u6263\u5206")
    public CustomApiResult<String> imageMinusCreditPoints(@Valid @NotNull @ApiParam(value="\u5f71\u50cf\u6263\u5206\u8bf7\u6c42") @Valid @NotNull @ApiParam(value="\u5f71\u50cf\u6263\u5206\u8bf7\u6c42") ImageMinusCreditPointRequest request) {
        log.info(String.format("imageMinusCreditPoints, parameter:%s", request));
        try {
            CreditPointDTO dto = new CreditPointDTO(request.getBillId(), request.getBillType(), request.getBillNumber(), request.getUserId().longValue());
            CreditOpenApiHelper.commonValidate(dto);
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("billId", request.getBillId());
            paramMap.put("billNumber", request.getBillType());
            paramMap.put("billNo", request.getBillNumber());
            paramMap.put("userId", request.getUserId().toString());
            String creditPointDtoStr = SerializationUtils.toJsonString(paramMap);
            this.invokeFircmService("minusCreditPoints", creditPointDtoStr, request.getOffset());
        }
        catch (Exception e) {
            String stackTrace = ExceptionUtil.getStackTrace((Throwable)e, (int)1000);
            log.error(String.format("imageMinusCreditPoints error, msg:%s", stackTrace));
            return CustomApiResult.fail((String)"400", (String)("Operation failed:" + e.getMessage()));
        }
        return CustomApiResult.success((Object)"Operation succeeded.");
    }

    @ApiGetMapping(value="/querySubScoreRule", desc="\u67e5\u8be2\u5ba1\u6838\u4fe1\u7528\u6263\u5206\u89c4\u5219")
    public CustomApiResult<List<Long>> querySubScoreRule(@ApiParam(value="\u5355\u636e\u7c7b\u578b\u6807\u8bc6", required=true) @ApiParam(value="\u5355\u636e\u7c7b\u578b\u6807\u8bc6", required=true) String billType, @Pattern(regexp="[0|1]") @ApiParam(value="\u5ba1\u6838\u7c7b\u578b", required=true) @Pattern(regexp="[0|1]") @ApiParam(value="\u5ba1\u6838\u7c7b\u578b", required=true) String auditType) {
        List results;
        log.info(String.format("querySubScoreRule, billNumber:%s, type:%s", billType, auditType));
        try {
            results = (List)this.invokeFircmService("getSubScoreRuleIdsByBillNumAndType", billType, auditType);
        }
        catch (Exception e) {
            String stackTrace = ExceptionUtil.getStackTrace((Throwable)e, (int)1000);
            log.error(String.format("querySubScoreRule error, msg:%s", stackTrace));
            return CustomApiResult.fail((String)"400", (String)("Operation failed:" + e.getMessage()));
        }
        return CustomApiResult.success((Object)results);
    }

    @ApiGetMapping(value="/isConfigCreditArg", desc="\u5355\u636e\u662f\u5426\u914d\u7f6e\u4fe1\u7528\u53c2\u6570")
    public CustomApiResult<Boolean> isConfigCreditArg(@Valid @ApiParam(value="\u5355\u636e\u7c7b\u578b\u6807\u8bc6", required=true) @Valid @ApiParam(value="\u5355\u636e\u7c7b\u578b\u6807\u8bc6", required=true) String billType) {
        Boolean result;
        log.info(String.format("isConfigCreditArg, billNumber:%s", billType));
        try {
            result = (Boolean)this.invokeFircmService("isConfigCreditArg", billType);
        }
        catch (Exception e) {
            String stackTrace = ExceptionUtil.getStackTrace((Throwable)e, (int)1000);
            log.error(String.format("isConfigCreditArg error, msg:%s", stackTrace));
            return CustomApiResult.fail((String)"400", (String)("Operation failed:" + e.getMessage()));
        }
        return CustomApiResult.success((Object)result);
    }
}

