/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ReconciliationPlanEnableOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("useorg");
        e.getFieldKeys().add("booktype");
        e.getFieldKeys().add("bizapp");
        e.getFieldKeys().add("accounttable");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                HashMap<String, String> existPlan = new HashMap<String, String>(dataEntities.length);
                for (ExtendedDataEntity extDataEntity : dataEntities) {
                    String alertStr;
                    ArrayList<QFilter> filters = new ArrayList<QFilter>();
                    DynamicObject dataEntity = extDataEntity.getDataEntity();
                    Long useOrgId = dataEntity.getLong("useorg.id");
                    QFilter orgIdFilter = new QFilter("useorg", "=", (Object)useOrgId);
                    Long bookTypeId = dataEntity.getLong("booktype.id");
                    QFilter bookTypeIdFilter = new QFilter("booktype", "=", (Object)bookTypeId);
                    String appId = dataEntity.getString("bizapp.id");
                    QFilter appIdFilter = new QFilter("bizapp", "=", (Object)appId);
                    QFilter billStatusFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
                    QFilter accountTableFilter = new QFilter("accounttable", "=", dataEntity.get("accounttable.id"));
                    filters.add(orgIdFilter);
                    filters.add(bookTypeIdFilter);
                    filters.add(appIdFilter);
                    filters.add(billStatusFilter);
                    filters.add(accountTableFilter);
                    String existKey = useOrgId + "," + bookTypeId + "," + appId;
                    String planName = (String)existPlan.get(existKey);
                    DynamicObject dyScheme = BusinessDataServiceHelper.loadSingleFromCache((String)"frm_reconciliation_scheme", (String)"id,name", (QFilter[])filters.toArray(new QFilter[0]));
                    if (dyScheme != null) {
                        alertStr = String.format(ResManager.loadKDString((String)"[%1$s]\u7684[%2$s]\u7684[%3$s]\u5df2\u5b58\u5728\u5bf9\u8d26\u65b9\u6848[%4$s]", (String)"ReconciliationPlanEnableOp_1", (String)"fi-frm-opplugin", (Object[])new Object[0]), dataEntity.get("useorg.name"), dataEntity.get("booktype.name"), dataEntity.get("bizapp.name"), dyScheme.getString("name"));
                        this.addMessage(extDataEntity, alertStr, ErrorLevel.Error);
                        continue;
                    }
                    if (planName != null) {
                        alertStr = String.format(ResManager.loadKDString((String)"[%1$s]\u7684[%2$s]\u7684[%3$s]\u5df2\u5b58\u5728\u5bf9\u8d26\u65b9\u6848[%4$s]", (String)"ReconciliationPlanEnableOp_1", (String)"fi-frm-opplugin", (Object[])new Object[0]), dataEntity.get("useorg.name"), dataEntity.get("booktype.name"), dataEntity.get("bizapp.name"), planName);
                        this.addMessage(extDataEntity, alertStr, ErrorLevel.Error);
                        continue;
                    }
                    existPlan.put(existKey, dataEntity.getString("name"));
                }
            }
        });
    }
}

