/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.upgradeservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.ExceptionUtils;
import kd.fi.frm.upgradeservice.model.RecCommonEntryModel;

public class ApArAcctFieldUpgradeService
implements IUpgradeService {
    private static final Log log = LogFactory.getLog((String)ApArAcctFieldUpgradeService.class.getName());
    private static final String ALGO_KEY = ApArAcctFieldUpgradeService.class.getName();
    private static final String DB_ROUT_AI = "ai";
    private static final int ASSIST_NUM = 8;
    private static final Map<String, String[]> ACCT_FIELD_MAP = new HashMap<String, String[]>();

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        try (TXHandle txHandle = TX.requiresNew();){
            UpgradeResult upgradeResult = new UpgradeResult();
            try {
                this.exec();
                upgradeResult.setSuccess(true);
                log.info("UPGRADE ACCT FIELD MAP ENTRY SUCCESS");
            }
            catch (Exception e) {
                txHandle.markRollback();
                upgradeResult.setSuccess(false);
                log.info("UPGRADE ACCT FIELD MAP ENTRY ERROR");
                upgradeResult.setErrorInfo("UPGRADE ACCT FIELD MAP ENTRY" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
            UpgradeResult upgradeResult2 = upgradeResult;
            return upgradeResult2;
        }
    }

    private void exec() {
        Object row3;
        Object row22;
        DBRoute ai = DBRoute.of((String)DB_ROUT_AI);
        String deleteSqlAp = "delete from t_ai_acctfieldmapentry where fid in (1284796039697579008,1283344148803368960)and (fentityid = 'bd_supplier' or fentityid = 'bd_currency')";
        DB.execute((DBRoute)ai, (String)deleteSqlAp);
        String deleteSqlAr = "delete from t_ai_acctfieldmapentry where fid in (1305725681644127232,1305730330275135488)and (fentityid = 'bd_customer' or fentityid = 'bd_currency' or fentityid = 'bd_supplier')";
        DB.execute((DBRoute)ai, (String)deleteSqlAr);
        String itemClassTypeSql = "select fid,fitemclasstype from t_ai_rec_common_filter where fid in (1284796039697579008,1283344148803368960,1305725681644127232,1305730330275135488)";
        HashMap<Long, String> itemClassTypeMap = new HashMap<Long, String>(12);
        try (DataSet ds = DB.queryDataSet((String)ALGO_KEY, (DBRoute)ai, (String)itemClassTypeSql);){
            for (Object row22 : ds) {
                itemClassTypeMap.put(row22.getLong("fid"), row22.getString("fitemclasstype"));
            }
        }
        String commonEntrySql = "select fid,fbizassist0,fbizassist1,fbizassist2,fbizassist3,fbizassist4,fbizassist5,fbizassist6,fbizassist7 from t_ai_rec_common_entry where fid in (1284796039697579008,1283344148803368960,1305725681644127232,1305730330275135488)";
        ArrayList<RecCommonEntryModel> commonEntrys = new ArrayList<RecCommonEntryModel>(12);
        DataSet ds = DB.queryDataSet((String)ALGO_KEY, (DBRoute)ai, (String)commonEntrySql);
        row22 = null;
        try {
            for (Object row3 : ds) {
                for (int i = 0; i < 8; ++i) {
                    if (!StringUtils.isNotEmpty((CharSequence)row3.getString("fbizassist" + i))) continue;
                    RecCommonEntryModel recCommonEntryModel = new RecCommonEntryModel();
                    recCommonEntryModel.setCommonFilterId(row3.getLong("fid"));
                    recCommonEntryModel.setBaseDataIndex("basedata" + i);
                    String itemClassType = (String)itemClassTypeMap.get(row3.getLong("fid"));
                    if ("asstact".equals(row3.getString("fbizassist" + i)) && StringUtils.isNotEmpty((CharSequence)itemClassType)) {
                        recCommonEntryModel.setBizAssist(itemClassType);
                    } else {
                        recCommonEntryModel.setBizAssist(row3.getString("fbizassist" + i));
                    }
                    recCommonEntryModel.setIndex(i + 1);
                    commonEntrys.add(recCommonEntryModel);
                }
            }
        }
        catch (Throwable throwable) {
            row22 = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (row22 != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)row22).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        String acctFieldMapEntrySql = "select fid,fentityid,ffieldkey from t_ai_acctfieldmapentry where fid in (1284796039697579008,1283344148803368960,1305725681644127232,1305730330275135488)";
        HashMap<String, String> acctFieldMap = new HashMap<String, String>(12);
        DataSet ds2 = DB.queryDataSet((String)ALGO_KEY, (DBRoute)ai, (String)acctFieldMapEntrySql);
        row3 = null;
        try {
            for (Row row4 : ds2) {
                acctFieldMap.put(row4.getLong("fid") + "," + row4.getString("ffieldkey"), row4.getString("fentityid"));
            }
        }
        catch (Throwable i) {
            row3 = i;
            throw i;
        }
        finally {
            if (ds2 != null) {
                if (row3 != null) {
                    try {
                        ds2.close();
                    }
                    catch (Throwable i) {
                        ((Throwable)row3).addSuppressed(i);
                    }
                } else {
                    ds2.close();
                }
            }
        }
        ArrayList<Object[]> upgradeList = new ArrayList<Object[]>(commonEntrys.size());
        long[] newSchemeIds = DB.genLongIds((String)"t_ai_acctfieldmapentry", (int)commonEntrys.size());
        int index = 0;
        for (RecCommonEntryModel commonEntry : commonEntrys) {
            String key = commonEntry.getCommonFilterId() + "," + commonEntry.getBaseDataIndex();
            if (acctFieldMap.containsKey(key) && ((String)acctFieldMap.get(key)).equals(ACCT_FIELD_MAP.get(commonEntry.getBizAssist())[0])) continue;
            Object[] acctField = new Object[]{commonEntry.getCommonFilterId(), newSchemeIds[index], 1, ACCT_FIELD_MAP.get(commonEntry.getBizAssist())[0], ACCT_FIELD_MAP.get(commonEntry.getBizAssist())[1], commonEntry.getBaseDataIndex(), commonEntry.getIndex()};
            upgradeList.add(acctField);
            ++index;
        }
        if (upgradeList.size() > 0) {
            DB.executeBatch((DBRoute)ai, (String)"INSERT INTO t_ai_acctfieldmapentry(FID,FENTRYID,FDATATYPE,FENTITYID,FFIELDNAME,FFIELDKEY,FSEQ) VALUES (?,?,?,?,?,?,?)", upgradeList);
        }
    }

    static {
        String[] supplier = new String[]{ResManager.loadKDString((String)"bd_supplier", (String)"ApArAcctFieldUpgradeService_1", (String)"fi-frm-upgradeservice", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4f9b\u5e94\u5546", (String)"ApArAcctFieldUpgradeService_2", (String)"fi-frm-upgradeservice", (Object[])new Object[0])};
        ACCT_FIELD_MAP.put(ResManager.loadKDString((String)"asstacttype:bd_supplier", (String)"ApArAcctFieldUpgradeService_0", (String)"fi-frm-upgradeservice", (Object[])new Object[0]), supplier);
        String[] customer = new String[]{ResManager.loadKDString((String)"bd_customer", (String)"ApArAcctFieldUpgradeService_8", (String)"fi-frm-upgradeservice", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5ba2\u6237", (String)"ApArAcctFieldUpgradeService_9", (String)"fi-frm-upgradeservice", (Object[])new Object[0])};
        ACCT_FIELD_MAP.put(ResManager.loadKDString((String)"asstacttype:bd_customer", (String)"ApArAcctFieldUpgradeService_7", (String)"fi-frm-upgradeservice", (Object[])new Object[0]), customer);
        String[] currency = new String[]{ResManager.loadKDString((String)"bd_currency", (String)"ApArAcctFieldUpgradeService_4", (String)"fi-frm-upgradeservice", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5e01\u522b", (String)"ApArAcctFieldUpgradeService_5", (String)"fi-frm-upgradeservice", (Object[])new Object[0])};
        ACCT_FIELD_MAP.put(ResManager.loadKDString((String)"currency", (String)"ApArAcctFieldUpgradeService_3", (String)"fi-frm-upgradeservice", (Object[])new Object[0]), currency);
    }
}

