/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.upgradeservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.ExceptionUtils;

public class DataRuleNumberUpgradeService
implements IUpgradeService {
    private static final Log log = LogFactory.getLog((String)DataRuleNumberUpgradeService.class.getName());
    private static final String ALGO_KEY = DataRuleNumberUpgradeService.class.getName();
    private static final String DB_ROUT_AI = "ai";
    private static final String DB_ROUT_SYS = "sys";
    private static final String DB_ROUT_META = "sys.meta";
    private static final String TABLE_NAME_ORG = "t_org_org";
    private static final String TABLE_NAME_APP = "t_meta_bizapp";

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult upgradeResult = new UpgradeResult();
        try {
            this.exec();
            upgradeResult.setSuccess(true);
            log.info("UPGRADE REC DATA RULE SUCCESS");
        }
        catch (Exception e) {
            upgradeResult.setSuccess(false);
            log.info("UPGRADE REC DATA RULE ERROR");
            upgradeResult.setErrorInfo("UPGRADE REC DATA RULE ERROR" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return upgradeResult;
    }

    private void exec() {
        Map<Object, String> appNumberMap;
        Map<Object, String> orgNumberMap;
        HashSet<Object> orgIdList = new HashSet<Object>(12);
        HashSet<Object> appIdList = new HashSet<Object>(12);
        List<Object[]> dataRuleList = this.getDataRuleList(orgIdList, appIdList);
        List<Object[]> updateParamList = this.createDataRuleNumber(dataRuleList, orgNumberMap = this.getNumberMap(orgIdList, DB_ROUT_SYS, TABLE_NAME_ORG), appNumberMap = this.getNumberMap(appIdList, DB_ROUT_META, TABLE_NAME_APP));
        if (updateParamList.size() > 0) {
            String updateSql = "UPDATE t_ai_recdatarule SET fnumber = ? WHERE fid = ?";
            DB.executeBatch((DBRoute)DBRoute.of((String)DB_ROUT_AI), (String)updateSql, updateParamList);
        }
    }

    private List<Object[]> getDataRuleList(Set<Object> orgIdList, Set<Object> appIdList) {
        ArrayList<Object[]> dataRuleList = new ArrayList<Object[]>(12);
        String dataRuleSelectSql = "SELECT %s FROM t_ai_recdatarule WHERE FNUMBER = ' ';";
        String dataRuleFields = "fid, fuseorg, fbizapp";
        dataRuleSelectSql = String.format(dataRuleSelectSql, dataRuleFields);
        try (DataSet ds = DB.queryDataSet((String)"ALGO_KEY", (DBRoute)DBRoute.of((String)DB_ROUT_AI), (String)dataRuleSelectSql);){
            for (Row row : ds) {
                Object[] dataRule = new Object[]{row.get("fid"), row.get("fuseorg"), row.get("fbizapp")};
                dataRuleList.add(dataRule);
                orgIdList.add(dataRule[1]);
                appIdList.add(dataRule[2]);
            }
        }
        return dataRuleList;
    }

    private Map<Object, String> getNumberMap(Set<Object> idList, String dbRout, String tableName) {
        if (idList == null || idList.size() == 0) {
            return new HashMap<Object, String>(0);
        }
        StringBuilder stringBuilder = new StringBuilder("SELECT fid,fnumber FROM ");
        stringBuilder.append(tableName).append(" where fid in (");
        for (Object id : idList) {
            if (id instanceof String) {
                stringBuilder.append("'").append(id).append("'").append(',');
                continue;
            }
            stringBuilder.append(id).append(',');
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        stringBuilder.append(')');
        String sql = stringBuilder.toString();
        HashMap<Object, String> map = new HashMap<Object, String>(idList.size());
        try (DataSet ds = DB.queryDataSet((String)ALGO_KEY, (DBRoute)DBRoute.of((String)dbRout), (String)sql);){
            for (Row row : ds) {
                map.put(row.get("fid"), row.getString("fnumber"));
            }
        }
        return map;
    }

    private List<Object[]> createDataRuleNumber(List<Object[]> dataRuleList, Map<Object, String> orgNumberMap, Map<Object, String> appNumberMap) {
        ArrayList<Object[]> updateParamList = new ArrayList<Object[]>(dataRuleList.size());
        HashMap<String, Integer> dataRuleMap = new HashMap<String, Integer>(dataRuleList.size());
        StringBuilder dataRuleNumberPrefix = new StringBuilder();
        for (Object[] dataRule : dataRuleList) {
            Object[] updateParam = new Object[2];
            String orgNumber = orgNumberMap.getOrDefault(dataRule[1], "0").toUpperCase();
            String appNumber = appNumberMap.getOrDefault(dataRule[2], "0").toUpperCase();
            dataRuleNumberPrefix.append(orgNumber).append("_").append(appNumber);
            if (dataRuleMap.containsKey(dataRuleNumberPrefix.toString())) {
                Integer index = (Integer)dataRuleMap.get(dataRuleNumberPrefix.toString()) + 1;
                dataRuleMap.put(dataRuleNumberPrefix.toString(), index);
                dataRuleNumberPrefix.append("_").append(index);
            } else {
                dataRuleMap.put(dataRuleNumberPrefix.toString(), 0);
            }
            updateParam[0] = dataRuleNumberPrefix.toString();
            updateParam[1] = dataRule[0];
            updateParamList.add(updateParam);
            dataRuleNumberPrefix = new StringBuilder();
        }
        return updateParamList;
    }
}

