/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.upgradeservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.ExceptionUtils;

public class FaSplitBillDataRuleRepairUpgradeService
implements IUpgradeService {
    private static final Log log = LogFactory.getLog((String)FaSplitBillDataRuleRepairUpgradeService.class.getName());
    private static final String ALGO_KEY = FaSplitBillDataRuleRepairUpgradeService.class.getName();
    private static final DBRoute DB_ROUTE_AI = DBRoute.of((String)"ai");
    private static final String INSERT_T_AI_REC_DATARULEENTRY = "INSERT INTO t_ai_recdataruleentry(FID,FENTRYID,FDATATYPE,FBIZOBJ,FAMOUNTTYPE,FAMOUNTEXP_TAG,FDATAFILTERDESC,FTASKSIZE,FDATAFILTER_TAG,FSEQ,FCOMMONFILTER,FDISABLE,FAMOUNT) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            this.exec();
            result.setSuccess(true);
            log.info("UPGRADE_FA_SPLIT_BILL_DATA_RULE_SUCCESS");
        }
        catch (Exception e) {
            result.setSuccess(false);
            log.info("UPGRADE_FA_SPLIT_BILL_DATA_RULE_ERROR");
            result.setErrorInfo("UPGRADE_FA_SPLIT_BILL_DATA_RULE_ERROR" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return result;
    }

    private void exec() {
        Set<Long> dataRuleIds = this.getAllFaDataRule();
        if (dataRuleIds.size() == 0) {
            return;
        }
        try (TXHandle ignored = TX.requiresNew();){
            try {
                Map<Long, Integer> dataRuleMaxSeqMap = this.getDataRuleMaxSeqMap(dataRuleIds);
                this.addDataRuleEntry(dataRuleIds, dataRuleMaxSeqMap);
            }
            catch (Throwable e) {
                log.error("Save fa split bill dataRule error\uff1a", (Object)e.getMessage());
                ignored.markRollback();
                throw e;
            }
        }
    }

    private Set<Long> getAllFaDataRule() {
        String selectSql = "SELECT fid FROM t_ai_recdatarule a WHERE a.fbizapp = '83bfebc800001aac' and not  exists (select 'x' from t_ai_recdataruleentry e  where a.fid = e.fid and e.fbizobj= 'fa_assetsplitbill' and e.fdatatype = '2' and e.famounttype = 731601043674138625);";
        HashSet<Long> dataRuleIds = new HashSet<Long>(16);
        try (DataSet ds = DB.queryDataSet((String)ALGO_KEY, (DBRoute)DB_ROUTE_AI, (String)selectSql);){
            for (Row row : ds) {
                dataRuleIds.add(row.getLong("fid"));
            }
        }
        return dataRuleIds;
    }

    private Map<Long, Integer> getDataRuleMaxSeqMap(Set<Long> dataRuleIds) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("SELECT fid,MAX(FSEQ) fseq FROM t_ai_recdataruleentry WHERE ", new Object[0]);
        sqlBuilder.appendIn(" fid ", dataRuleIds.toArray());
        sqlBuilder.append(" group by fid", new Object[0]);
        return (Map)DB.query((DBRoute)DB_ROUTE_AI, (SqlBuilder)sqlBuilder, e -> {
            HashMap<Long, Integer> map = new HashMap<Long, Integer>(16);
            while (e.next()) {
                map.put(e.getLong("fid"), e.getInt("fseq"));
            }
            return map;
        });
    }

    private void addDataRuleEntry(Set<Long> dataRuleIds, Map<Long, Integer> dataRuleMaxSeqMap) {
        long[] ruleEntryIds = DB.genLongIds((String)"t_ai_recdataruleentry", (int)dataRuleIds.size());
        int index = 0;
        ArrayList<Object[]> list = new ArrayList<Object[]>(dataRuleIds.size());
        for (Long dataRuleId : dataRuleIds) {
            int maxSeq = dataRuleMaxSeqMap.get(dataRuleId) == null ? 0 : dataRuleMaxSeqMap.get(dataRuleId);
            list.add(new Object[]{dataRuleId, ruleEntryIds[index++], "2", "fa_assetsplitbill", 731601043674138625L, " assetsplitentry.subassetsplitentry.aft_originalval", "\u62c6\u5206\u540e\u5361\u7247.\u6e90\u5361\u7247 \u7b49\u4e8e \u5426   and    \u8bb0\u8d26\u6807\u8bc6 \u4e0d\u7b49\u4e8e \u65e0\u9700\u8bb0\u8d26", 0, "{\"expression\":\"\",\"exprTran\":\"\u62c6\u5206\u540e\u5361\u7247.\u6e90\u5361\u7247 \u7b49\u4e8e \u5426   and    \u8bb0\u8d26\u6807\u8bc6 \u4e0d\u7b49\u4e8e \u65e0\u9700\u8bb0\u8d26\",\"description\":{\"zh_CN\":\"\"},\"filterCondition\":{\"filterRow\":[{\"id\":\"3M0E45C3OE2=\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"issourcecard\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3M0E45C3OBD9\",\"value\":\"0\"}],\"baseDataIds\":[]},{\"id\":\"3M0E45C3OE2A\",\"leftBracket\":\"\",\"compareType\":\"106\",\"fieldName\":\"voucherflag\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3M0E45C3OBD=\",\"value\":\"A\"}],\"baseDataIds\":[]}],\"forList\":false},\"filterString\":\"{\\\"filterRow\\\":[{\\\"id\\\":\\\"3M0E45C3OE2=\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"105\\\",\\\"fieldName\\\":\\\"issourcecard\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"0\\\",\\\"value\\\":[{\\\"id\\\":\\\"3M0E45C3OBD9\\\",\\\"value\\\":\\\"0\\\"}],\\\"baseDataIds\\\":[]},{\\\"id\\\":\\\"3M0E45C3OE2A\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"106\\\",\\\"fieldName\\\":\\\"voucherflag\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"0\\\",\\\"value\\\":[{\\\"id\\\":\\\"3M0E45C3OBD=\\\",\\\"value\\\":\\\"A\\\"}],\\\"baseDataIds\\\":[]}],\\\"forList\\\":false}\",\"initialized\":false,\"exprDesc\":\"\u62c6\u5206\u540e\u5361\u7247.\u6e90\u5361\u7247 \u7b49\u4e8e \u5426   and    \u8bb0\u8d26\u6807\u8bc6 \u4e0d\u7b49\u4e8e \u65e0\u9700\u8bb0\u8d26\",\"localeExprTran\":{\"zh_CN\":\"\u62c6\u5206\u540e\u5361\u7247.\u6e90\u5361\u7247 \u7b49\u4e8e \u5426   and    \u8bb0\u8d26\u6807\u8bc6 \u4e0d\u7b49\u4e8e \u65e0\u9700\u8bb0\u8d26\"}}", ++maxSeq, 1731104194561048576L, "1", "  \u62c6\u5206\u524d\u5361\u7247.\u62c6\u5206\u540e\u5361\u7247.\u8d44\u4ea7\u539f\u503c"});
        }
        if (list.size() > 0) {
            DB.executeBatch((DBRoute)DB_ROUTE_AI, (String)INSERT_T_AI_REC_DATARULEENTRY, list);
        }
    }
}

