/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.upgradeservice;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.util.ExceptionUtils;

public class FaSplitBillDataRuleUpgradeService
implements IUpgradeService {
    private static final Log log = LogFactory.getLog((String)FaSplitBillDataRuleUpgradeService.class.getName());
    private static final String ALGO_KEY = FaSplitBillDataRuleUpgradeService.class.getName();
    private static final DBRoute DB_ROUTE_AI = DBRoute.of((String)"ai");
    private static final String INSERT_T_AI_REC_COMMON_FILTER = "INSERT INTO t_ai_rec_common_filter(FID,FCREATETIME,FMODIFYTIME,FMODIFIERID,FORGID,FMASTERID,FNUMBER,FENTITY,FBIZDATE,FBIZORG,FPRESET,FDETAILRULE) VALUES (?,?,?,?,?,?,?,?,?,?,?,?);";
    private static final String INSERT_T_AI_REC_DATARULEENTRY = "INSERT INTO t_ai_recdataruleentry(FID,FENTRYID,FDATATYPE,FBIZOBJ,FAMOUNTTYPE,FAMOUNTEXP_TAG,FDATAFILTERDESC,FTASKSIZE,FDATAFILTER_TAG,FSEQ,FCOMMONFILTER,FDISABLE,FAMOUNT) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            this.exec();
            result.setSuccess(true);
            log.info("UPGRADE_FA_SPLIT_BILL_DATA_RULE_SUCCESS");
        }
        catch (Exception e) {
            result.setSuccess(false);
            log.info("UPGRADE_FA_SPLIT_BILL_DATA_RULE_ERROR");
            result.setErrorInfo("UPGRADE_FA_SPLIT_BILL_DATA_RULE_ERROR" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return result;
    }

    private void exec() {
        boolean hasSplitBill = this.hasSplitBill();
        if (hasSplitBill) {
            return;
        }
        Set<Long> dataRuleIds = this.getAllFaDataRule();
        if (dataRuleIds.size() == 0) {
            return;
        }
        try (TXHandle ignored = TX.requiresNew();){
            try {
                this.addCommonFilter();
                Map<Long, Integer> dataRuleMaxSeqMap = this.getDataRuleMaxSeqMap(dataRuleIds);
                this.addDataRuleEntry(dataRuleIds, dataRuleMaxSeqMap);
            }
            catch (Throwable e) {
                log.error("Save fa split bill dataRule error\uff1a", (Object)e.getMessage());
                ignored.markRollback();
                throw e;
            }
        }
    }

    private boolean hasSplitBill() {
        String selectSql = "SELECT count(1) as counts FROM t_ai_rec_common_filter where fid in (1731104194561048576,1566692014630646784,1566696595985130496)";
        int counts = (Integer)DB.query((DBRoute)DB_ROUTE_AI, (String)selectSql, e -> {
            int count = 0;
            while (e.next()) {
                count = e.getInt("counts");
            }
            return count;
        });
        return counts > 0;
    }

    private Set<Long> getAllFaDataRule() {
        String selectSql = "SELECT fid FROM t_ai_recdatarule WHERE fbizapp = '83bfebc800001aac'";
        HashSet<Long> dataRuleIds = new HashSet<Long>(16);
        try (DataSet ds = DB.queryDataSet((String)ALGO_KEY, (DBRoute)DB_ROUTE_AI, (String)selectSql);){
            for (Row row : ds) {
                dataRuleIds.add(row.getLong("fid"));
            }
        }
        return dataRuleIds;
    }

    private void addCommonFilter() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sdf.setTimeZone(TimeServiceHelper.getUserTimeZone().getTimeZone());
        Date date = null;
        try {
            date = sdf.parse("2023-09-27 21:08:08");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        ArrayList<Object[]> list = new ArrayList<Object[]>(3);
        list.add(new Object[]{1566692014630646784L, date, date, 1L, 100000L, 1566692014630646784L, "001", "fa_mergebill", "mergedate", "org", Character.valueOf('0'), Character.valueOf('1')});
        list.add(new Object[]{1731104194561048576L, date, date, 1L, 100000L, 1731104194561048576L, "001", "fa_assetsplitbill", "splitdate", "org", Character.valueOf('0'), Character.valueOf('1')});
        list.add(new Object[]{1566696595985130496L, date, date, 1L, 100000L, 1566696595985130496L, "002", "fa_mergebill", "mergedate", "org", Character.valueOf('0'), Character.valueOf('1')});
        DB.executeBatch((DBRoute)DB_ROUTE_AI, (String)INSERT_T_AI_REC_COMMON_FILTER, list);
        list.clear();
        ArrayList<Object[]> commParams = new ArrayList<Object[]>(2);
        commParams.add(new Object[]{1583476223818973184L, 1566692014630646784L, "fa_assetcategory"});
        commParams.add(new Object[]{1583476224246793216L, 1566696595985130496L, "fa_assetcategory"});
        DB.executeBatch((DBRoute)DB_ROUTE_AI, (String)"INSERT INTO t_ai_rec_common_assist(FPKID,FID,FBASEDATAID) VALUES (?,?,?);", commParams);
        ArrayList<Object[]> commLParams = new ArrayList<Object[]>(9);
        commLParams.add(new Object[]{"2XEVNXA8E928", 1566692014630646784L, "zh_TW", "\u8d44\u4ea7\u5408\u5e76\u5355\uff08\u8f6c\u5165\u65b9\uff09"});
        commLParams.add(new Object[]{"2XEVNXA8E929", 1566692014630646784L, "zh_TW", "\u8cc7\u7522\u5408\u4e26\u55ae\uff08\u8f49\u5165\u65b9\uff09"});
        commLParams.add(new Object[]{"3IG+W6Q=RX/6", 1566692014630646784L, "en_US", "^en_US\u8d44\u4ea7\u5408\u5e76\u8f6c\u5165\u65b9^"});
        commLParams.add(new Object[]{"2XEWI=C=AQIK", 1566696595985130496L, "zh_CN", "\u8d44\u4ea7\u5408\u5e76\u5355\uff08\u8f6c\u51fa\u65b9\uff09"});
        commLParams.add(new Object[]{"2XEWI=C=AQIL", 1566696595985130496L, "zh_TW", "\u8cc7\u7522\u5408\u4e26\u55ae\uff08\u8f49\u51fa\u65b9\uff09"});
        commLParams.add(new Object[]{"3IG+W6Q=RX0+", 1566696595985130496L, "en_US", "^en_US\u8d44\u4ea7\u5408\u5e76\u8f6c\u51fa\u65b9^"});
        commLParams.add(new Object[]{"3EMJCNFUCBU5", 1731104194561048576L, "zh_CN", "\u8d44\u4ea7\u62c6\u5206\u5355"});
        commLParams.add(new Object[]{"3EMJCNFUCBU6", 1731104194561048576L, "zh_CN", "\u8cc7\u7522\u62c6\u5206\u55ae"});
        commLParams.add(new Object[]{"3IG+W6Q=RXP5", 1731104194561048576L, "zh_CN", "^en_US\u62c6\u5206\u5355^"});
        DB.executeBatch((DBRoute)DB_ROUTE_AI, (String)"INSERT INTO t_ai_rec_common_filter_l(FPKID,FID,FLOCALEID,FNAME) VALUES (?,?,?,?);", commLParams);
        ArrayList<Object[]> commEParams = new ArrayList<Object[]>(3);
        commEParams.add(new Object[]{1731104194561048576L, 1731104194946924544L, "assetsplitentry.subassetsplitentry.aft_assetcat"});
        commEParams.add(new Object[]{1566692014630646784L, 1583476223818974208L, "realcard.assetcat"});
        commEParams.add(new Object[]{1566696595985130496L, 1583476224246792192L, "inentryentity.outentryentity.afteroutfin.assetcat"});
        DB.executeBatch((DBRoute)DB_ROUTE_AI, (String)"INSERT INTO t_ai_rec_common_entry(FID,FENTRYID,FBIZASSIST0) VALUES (?,?,?);", commEParams);
    }

    private Map<Long, Integer> getDataRuleMaxSeqMap(Set<Long> dataRuleIds) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("SELECT fid,MAX(FSEQ) fseq FROM t_ai_recdataruleentry WHERE ", new Object[0]);
        sqlBuilder.appendIn(" fid ", dataRuleIds.toArray());
        sqlBuilder.append(" group by fid", new Object[0]);
        return (Map)DB.query((DBRoute)DB_ROUTE_AI, (SqlBuilder)sqlBuilder, e -> {
            HashMap<Long, Integer> map = new HashMap<Long, Integer>(16);
            while (e.next()) {
                map.put(e.getLong("fid"), e.getInt("fseq"));
            }
            return map;
        });
    }

    private void addDataRuleEntry(Set<Long> dataRuleIds, Map<Long, Integer> dataRuleMaxSeqMap) {
        long[] ruleEntryIds = DB.genLongIds((String)"t_ai_recdataruleentry", (int)(11 * dataRuleIds.size()));
        int index = 0;
        ArrayList<Object[]> list = new ArrayList<Object[]>(2048);
        for (Long dataRuleId : dataRuleIds) {
            int maxSeq = dataRuleMaxSeqMap.get(dataRuleId) == null ? 0 : dataRuleMaxSeqMap.get(dataRuleId);
            list.add(new Object[]{dataRuleId, ruleEntryIds[index++], "3", "fa_assetsplitbill", 731601043674138626L, " assetsplitentry.subassetsplitentry.aft_accumdepre", "\u62c6\u5206\u540e\u5361\u7247.\u6e90\u5361\u7247 \u7b49\u4e8e \u5426   and    \u8bb0\u8d26\u6807\u8bc6 \u4e0d\u7b49\u4e8e \u65e0\u9700\u8bb0\u8d26", 0, "{\"expression\":\"\",\"exprTran\":\"\u62c6\u5206\u540e\u5361\u7247.\u6e90\u5361\u7247 \u7b49\u4e8e \u5426   and    \u8bb0\u8d26\u6807\u8bc6 \u4e0d\u7b49\u4e8e \u65e0\u9700\u8bb0\u8d26\",\"description\":{\"zh_CN\":\"\"},\"filterCondition\":{\"filterRow\":[{\"id\":\"3L5AFX3847K2\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"issourcecard\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3L5AFX3824SA\",\"value\":\"0\"}],\"baseDataIds\":[]},{\"id\":\"3L5AFX3847K3\",\"leftBracket\":\"\",\"compareType\":\"106\",\"fieldName\":\"voucherflag\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3L5AFX3824SB\",\"value\":\"A\"}],\"baseDataIds\":[]}],\"forList\":false},\"filterString\":\"{\\\"filterRow\\\":[{\\\"id\\\":\\\"3L5AFX3847K2\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"105\\\",\\\"fieldName\\\":\\\"issourcecard\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"0\\\",\\\"value\\\":[{\\\"id\\\":\\\"3L5AFX3824SA\\\",\\\"value\\\":\\\"0\\\"}],\\\"baseDataIds\\\":[]},{\\\"id\\\":\\\"3L5AFX3847K3\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"106\\\",\\\"fieldName\\\":\\\"voucherflag\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"0\\\",\\\"value\\\":[{\\\"id\\\":\\\"3L5AFX3824SB\\\",\\\"value\\\":\\\"A\\\"}],\\\"baseDataIds\\\":[]}],\\\"forList\\\":false}\",\"initialized\":false,\"localeExprTran\":{\"zh_CN\":\"\u62c6\u5206\u540e\u5361\u7247.\u6e90\u5361\u7247 \u7b49\u4e8e \u5426   and    \u8bb0\u8d26\u6807\u8bc6 \u4e0d\u7b49\u4e8e \u65e0\u9700\u8bb0\u8d26\"},\"exprDesc\":\"\u62c6\u5206\u540e\u5361\u7247.\u6e90\u5361\u7247 \u7b49\u4e8e \u5426   and    \u8bb0\u8d26\u6807\u8bc6 \u4e0d\u7b49\u4e8e \u65e0\u9700\u8bb0\u8d26\"}", ++maxSeq, 1731104194561048576L, "1", " \u62c6\u5206\u524d\u5361\u7247.\u62c6\u5206\u540e\u5361\u7247.\u7d2f\u8ba1\u6298\u65e7"});
            list.add(new Object[]{dataRuleId, ruleEntryIds[index++], "3", "fa_assetsplitbill", 731601043674138627L, " assetsplitentry.subassetsplitentry.aft_decval", "\u62c6\u5206\u540e\u5361\u7247.\u6e90\u5361\u7247 \u7b49\u4e8e \u5426   and    \u8bb0\u8d26\u6807\u8bc6 \u4e0d\u7b49\u4e8e \u65e0\u9700\u8bb0\u8d26", 0, "{\"expression\":\"\",\"exprTran\":\"\u62c6\u5206\u540e\u5361\u7247.\u6e90\u5361\u7247 \u7b49\u4e8e \u5426   and    \u8bb0\u8d26\u6807\u8bc6 \u4e0d\u7b49\u4e8e \u65e0\u9700\u8bb0\u8d26\",\"description\":{\"zh_CN\":\"\"},\"filterCondition\":{\"filterRow\":[{\"id\":\"3L5AFX3847K2\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"issourcecard\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3L5AFX3824SA\",\"value\":\"0\"}],\"baseDataIds\":[]},{\"id\":\"3L5AFX3847K3\",\"leftBracket\":\"\",\"compareType\":\"106\",\"fieldName\":\"voucherflag\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3L5AFX3824SB\",\"value\":\"A\"}],\"baseDataIds\":[]}],\"forList\":false},\"filterString\":\"{\\\"filterRow\\\":[{\\\"id\\\":\\\"3L5AFX3847K2\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"105\\\",\\\"fieldName\\\":\\\"issourcecard\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"0\\\",\\\"value\\\":[{\\\"id\\\":\\\"3L5AFX3824SA\\\",\\\"value\\\":\\\"0\\\"}],\\\"baseDataIds\\\":[]},{\\\"id\\\":\\\"3L5AFX3847K3\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"106\\\",\\\"fieldName\\\":\\\"voucherflag\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"0\\\",\\\"value\\\":[{\\\"id\\\":\\\"3L5AFX3824SB\\\",\\\"value\\\":\\\"A\\\"}],\\\"baseDataIds\\\":[]}],\\\"forList\\\":false}\",\"initialized\":false,\"localeExprTran\":{\"zh_CN\":\"\u62c6\u5206\u540e\u5361\u7247.\u6e90\u5361\u7247 \u7b49\u4e8e \u5426   and    \u8bb0\u8d26\u6807\u8bc6 \u4e0d\u7b49\u4e8e \u65e0\u9700\u8bb0\u8d26\"},\"exprDesc\":\"\u62c6\u5206\u540e\u5361\u7247.\u6e90\u5361\u7247 \u7b49\u4e8e \u5426   and    \u8bb0\u8d26\u6807\u8bc6 \u4e0d\u7b49\u4e8e \u65e0\u9700\u8bb0\u8d26\"}", ++maxSeq, 1731104194561048576L, "1", " \u62c6\u5206\u524d\u5361\u7247.\u62c6\u5206\u540e\u5361\u7247.\u51cf\u503c\u51c6\u5907"});
            list.add(new Object[]{dataRuleId, ruleEntryIds[index++], "3", "fa_assetsplitbill", 731601043674138625L, "- assetsplitentry.subassetsplitentry.aft_monthorigvalchg", "\u62c6\u5206\u540e\u5361\u7247.\u6e90\u5361\u7247 \u7b49\u4e8e \u662f   and    \u8bb0\u8d26\u6807\u8bc6 \u4e0d\u7b49\u4e8e \u65e0\u9700\u8bb0\u8d26", 0, "{\"expression\":\"\",\"exprTran\":\"\u62c6\u5206\u540e\u5361\u7247.\u6e90\u5361\u7247 \u7b49\u4e8e \u662f   and    \u8bb0\u8d26\u6807\u8bc6 \u4e0d\u7b49\u4e8e \u65e0\u9700\u8bb0\u8d26\",\"description\":{\"zh_CN\":\"\"},\"filterCondition\":{\"filterRow\":[{\"id\":\"3L5AQJFN/TGF\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"issourcecard\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3L5AQJFN1W97\",\"value\":\"1\"}],\"baseDataIds\":[]},{\"id\":\"3L5AQJFN/TGG\",\"leftBracket\":\"\",\"compareType\":\"106\",\"fieldName\":\"voucherflag\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3L5AQJFN1W98\",\"value\":\"A\"}],\"baseDataIds\":[]}],\"forList\":false},\"filterString\":\"{\\\"filterRow\\\":[{\\\"id\\\":\\\"3L5AQJFN/TGF\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"105\\\",\\\"fieldName\\\":\\\"issourcecard\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"0\\\",\\\"value\\\":[{\\\"id\\\":\\\"3L5AQJFN1W97\\\",\\\"value\\\":\\\"1\\\"}],\\\"baseDataIds\\\":[]},{\\\"id\\\":\\\"3L5AQJFN/TGG\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"106\\\",\\\"fieldName\\\":\\\"voucherflag\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"0\\\",\\\"value\\\":[{\\\"id\\\":\\\"3L5AQJFN1W98\\\",\\\"value\\\":\\\"A\\\"}],\\\"baseDataIds\\\":[]}],\\\"forList\\\":false}\",\"initialized\":false,\"localeExprTran\":{\"zh_CN\":\"\u62c6\u5206\u540e\u5361\u7247.\u6e90\u5361\u7247 \u7b49\u4e8e \u662f   and    \u8bb0\u8d26\u6807\u8bc6 \u4e0d\u7b49\u4e8e \u65e0\u9700\u8bb0\u8d26\"},\"exprDesc\":\"\u62c6\u5206\u540e\u5361\u7247.\u6e90\u5361\u7247 \u7b49\u4e8e \u662f   and    \u8bb0\u8d26\u6807\u8bc6 \u4e0d\u7b49\u4e8e \u65e0\u9700\u8bb0\u8d26\"}", ++maxSeq, 1731104194561048576L, "1", "- \u62c6\u5206\u524d\u5361\u7247.\u62c6\u5206\u540e\u5361\u7247.\u62c6\u5206\u672c\u671f\u539f\u503c\u53d8\u52a8"});
            list.add(new Object[]{dataRuleId, ruleEntryIds[index++], "2", "fa_assetsplitbill", 731601043674138626L, "- assetsplitentry.subassetsplitentry.aft_monthaccumdeprechg", "\u62c6\u5206\u540e\u5361\u7247.\u6e90\u5361\u7247 \u7b49\u4e8e \u662f   and    \u8bb0\u8d26\u6807\u8bc6 \u4e0d\u7b49\u4e8e \u65e0\u9700\u8bb0\u8d26", 0, "{\"expression\":\"\",\"exprTran\":\"\u62c6\u5206\u540e\u5361\u7247.\u6e90\u5361\u7247 \u7b49\u4e8e \u662f   and    \u8bb0\u8d26\u6807\u8bc6 \u4e0d\u7b49\u4e8e \u65e0\u9700\u8bb0\u8d26\",\"description\":{\"zh_CN\":\"\"},\"filterCondition\":{\"filterRow\":[{\"id\":\"3L5AQJFN/TGF\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"issourcecard\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3L5AQJFN1W97\",\"value\":\"1\"}],\"baseDataIds\":[]},{\"id\":\"3L5AQJFN/TGG\",\"leftBracket\":\"\",\"compareType\":\"106\",\"fieldName\":\"voucherflag\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3L5AQJFN1W98\",\"value\":\"A\"}],\"baseDataIds\":[]}],\"forList\":false},\"filterString\":\"{\\\"filterRow\\\":[{\\\"id\\\":\\\"3L5AQJFN/TGF\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"105\\\",\\\"fieldName\\\":\\\"issourcecard\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"0\\\",\\\"value\\\":[{\\\"id\\\":\\\"3L5AQJFN1W97\\\",\\\"value\\\":\\\"1\\\"}],\\\"baseDataIds\\\":[]},{\\\"id\\\":\\\"3L5AQJFN/TGG\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"106\\\",\\\"fieldName\\\":\\\"voucherflag\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"0\\\",\\\"value\\\":[{\\\"id\\\":\\\"3L5AQJFN1W98\\\",\\\"value\\\":\\\"A\\\"}],\\\"baseDataIds\\\":[]}],\\\"forList\\\":false}\",\"initialized\":false,\"localeExprTran\":{\"zh_CN\":\"\u62c6\u5206\u540e\u5361\u7247.\u6e90\u5361\u7247 \u7b49\u4e8e \u662f   and    \u8bb0\u8d26\u6807\u8bc6 \u4e0d\u7b49\u4e8e \u65e0\u9700\u8bb0\u8d26\"},\"exprDesc\":\"\u62c6\u5206\u540e\u5361\u7247.\u6e90\u5361\u7247 \u7b49\u4e8e \u662f   and    \u8bb0\u8d26\u6807\u8bc6 \u4e0d\u7b49\u4e8e \u65e0\u9700\u8bb0\u8d26\"}", ++maxSeq, 1731104194561048576L, "1", "- \u62c6\u5206\u524d\u5361\u7247.\u62c6\u5206\u540e\u5361\u7247.\u62c6\u5206\u672c\u671f\u7d2f\u8ba1\u6298\u65e7\u53d8\u52a8"});
            list.add(new Object[]{dataRuleId, ruleEntryIds[index++], "2", "fa_assetsplitbill", 731601043674138627L, "- assetsplitentry.subassetsplitentry.aft_monthdeprechg", "\u62c6\u5206\u540e\u5361\u7247.\u6e90\u5361\u7247 \u7b49\u4e8e \u662f   and    \u8bb0\u8d26\u6807\u8bc6 \u4e0d\u7b49\u4e8e \u65e0\u9700\u8bb0\u8d26", 0, "{\"expression\":\"\",\"exprTran\":\"\u62c6\u5206\u540e\u5361\u7247.\u6e90\u5361\u7247 \u7b49\u4e8e \u662f   and    \u8bb0\u8d26\u6807\u8bc6 \u4e0d\u7b49\u4e8e \u65e0\u9700\u8bb0\u8d26\",\"description\":{\"zh_CN\":\"\"},\"filterCondition\":{\"filterRow\":[{\"id\":\"3L5AQJFN/TGF\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"issourcecard\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3L5AQJFN1W97\",\"value\":\"1\"}],\"baseDataIds\":[]},{\"id\":\"3L5AQJFN/TGG\",\"leftBracket\":\"\",\"compareType\":\"106\",\"fieldName\":\"voucherflag\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3L5AQJFN1W98\",\"value\":\"A\"}],\"baseDataIds\":[]}],\"forList\":false},\"filterString\":\"{\\\"filterRow\\\":[{\\\"id\\\":\\\"3L5AQJFN/TGF\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"105\\\",\\\"fieldName\\\":\\\"issourcecard\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"0\\\",\\\"value\\\":[{\\\"id\\\":\\\"3L5AQJFN1W97\\\",\\\"value\\\":\\\"1\\\"}],\\\"baseDataIds\\\":[]},{\\\"id\\\":\\\"3L5AQJFN/TGG\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"106\\\",\\\"fieldName\\\":\\\"voucherflag\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"0\\\",\\\"value\\\":[{\\\"id\\\":\\\"3L5AQJFN1W98\\\",\\\"value\\\":\\\"A\\\"}],\\\"baseDataIds\\\":[]}],\\\"forList\\\":false}\",\"initialized\":false,\"localeExprTran\":{\"zh_CN\":\"\u62c6\u5206\u540e\u5361\u7247.\u6e90\u5361\u7247 \u7b49\u4e8e \u662f   and    \u8bb0\u8d26\u6807\u8bc6 \u4e0d\u7b49\u4e8e \u65e0\u9700\u8bb0\u8d26\"},\"exprDesc\":\"\u62c6\u5206\u540e\u5361\u7247.\u6e90\u5361\u7247 \u7b49\u4e8e \u662f   and    \u8bb0\u8d26\u6807\u8bc6 \u4e0d\u7b49\u4e8e \u65e0\u9700\u8bb0\u8d26\"}", ++maxSeq, 1731104194561048576L, "1", "- \u62c6\u5206\u524d\u5361\u7247.\u62c6\u5206\u540e\u5361\u7247.\u62c6\u5206\u672c\u671f\u51cf\u503c\u53d8\u52a8"});
            list.add(new Object[]{dataRuleId, ruleEntryIds[index++], "2", "fa_mergebill", 731601043674138625L, " inentryentity.inoriginalval", "\u8bb0\u8d26\u6807\u8bc6 \u4e0d\u7b49\u4e8e \u65e0\u9700\u8bb0\u8d26", 0, "{\"expression\":\"\",\"exprTran\":\"\u8bb0\u8d26\u6807\u8bc6 \u4e0d\u7b49\u4e8e \u65e0\u9700\u8bb0\u8d26\",\"description\":{\"zh_CN\":\"\"},\"filterCondition\":{\"filterRow\":[{\"id\":\"3EMVZH5ARI=H\",\"leftBracket\":\"\",\"compareType\":\"106\",\"fieldName\":\"voucherflag\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3EMVZH5EEF1A\",\"value\":\"A\"}],\"baseDataIds\":[]}],\"forList\":false},\"filterString\":\"{\\\"filterRow\\\":[{\\\"id\\\":\\\"3EMVZH5ARI=H\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"106\\\",\\\"fieldName\\\":\\\"voucherflag\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"0\\\",\\\"value\\\":[{\\\"id\\\":\\\"3EMVZH5EEF1A\\\",\\\"value\\\":\\\"A\\\"}],\\\"baseDataIds\\\":[]}],\\\"forList\\\":false}\",\"initialized\":false,\"localeExprTran\":{\"zh_CN\":\"\u8bb0\u8d26\u6807\u8bc6 \u4e0d\u7b49\u4e8e \u65e0\u9700\u8bb0\u8d26\"},\"exprDesc\":\"\u8bb0\u8d26\u6807\u8bc6 \u4e0d\u7b49\u4e8e \u65e0\u9700\u8bb0\u8d26\"}", ++maxSeq, 1566692014630646784L, "1", "\u8f6c\u5165\u8d44\u4ea7\u660e\u7ec6.\u8f6c\u5165\u8d44\u4ea7\u539f\u503c"});
            list.add(new Object[]{dataRuleId, ruleEntryIds[index++], "3", "fa_mergebill", 731601043674138626L, " inentryentity.inaccumdepre", "\u8bb0\u8d26\u6807\u8bc6 \u4e0d\u7b49\u4e8e \u65e0\u9700\u8bb0\u8d26", 0, "{\"expression\":\"\",\"exprTran\":\"\u8bb0\u8d26\u6807\u8bc6 \u4e0d\u7b49\u4e8e \u65e0\u9700\u8bb0\u8d26\",\"description\":{\"zh_CN\":\"\"},\"filterCondition\":{\"filterRow\":[{\"id\":\"3EMW2C2/9RVM\",\"leftBracket\":\"\",\"compareType\":\"106\",\"fieldName\":\"voucherflag\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3EMW2C2/89=A\",\"value\":\"A\"}],\"baseDataIds\":[]}],\"forList\":false},\"filterString\":\"{\\\"filterRow\\\":[{\\\"id\\\":\\\"3EMW2C2/9RVM\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"106\\\",\\\"fieldName\\\":\\\"voucherflag\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"0\\\",\\\"value\\\":[{\\\"id\\\":\\\"3EMW2C2/89=A\\\",\\\"value\\\":\\\"A\\\"}],\\\"baseDataIds\\\":[]}],\\\"forList\\\":false}\",\"initialized\":false,\"localeExprTran\":{\"zh_CN\":\"\u8bb0\u8d26\u6807\u8bc6 \u4e0d\u7b49\u4e8e \u65e0\u9700\u8bb0\u8d26\"},\"exprDesc\":\"\u8bb0\u8d26\u6807\u8bc6 \u4e0d\u7b49\u4e8e \u65e0\u9700\u8bb0\u8d26\"}", ++maxSeq, 1566692014630646784L, "1", " \u8f6c\u5165\u8d44\u4ea7\u660e\u7ec6.\u8f6c\u5165\u7d2f\u8ba1\u6298\u65e7"});
            list.add(new Object[]{dataRuleId, ruleEntryIds[index++], "3", "fa_mergebill", 731601043674138627L, " inentryentity.indecval", "\u8bb0\u8d26\u6807\u8bc6 \u4e0d\u7b49\u4e8e \u65e0\u9700\u8bb0\u8d26", 0, "{\"expression\":\"\",\"exprTran\":\"\u8bb0\u8d26\u6807\u8bc6 \u4e0d\u7b49\u4e8e \u65e0\u9700\u8bb0\u8d26\",\"description\":{\"zh_CN\":\"\"},\"filterCondition\":{\"filterRow\":[{\"id\":\"3EMW4R9A4OID\",\"leftBracket\":\"\",\"compareType\":\"106\",\"fieldName\":\"voucherflag\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3EMW4R9A4NV4\",\"value\":\"A\"}],\"baseDataIds\":[]}],\"forList\":false},\"filterString\":\"{\\\"filterRow\\\":[{\\\"id\\\":\\\"3EMW4R9A4OID\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"106\\\",\\\"fieldName\\\":\\\"voucherflag\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"0\\\",\\\"value\\\":[{\\\"id\\\":\\\"3EMW4R9A4NV4\\\",\\\"value\\\":\\\"A\\\"}],\\\"baseDataIds\\\":[]}],\\\"forList\\\":false}\",\"initialized\":false,\"localeExprTran\":{\"zh_CN\":\"\u8bb0\u8d26\u6807\u8bc6 \u4e0d\u7b49\u4e8e \u65e0\u9700\u8bb0\u8d26\"},\"exprDesc\":\"\u8bb0\u8d26\u6807\u8bc6 \u4e0d\u7b49\u4e8e \u65e0\u9700\u8bb0\u8d26\"}", ++maxSeq, 1566692014630646784L, "1", " \u8f6c\u5165\u8d44\u4ea7\u660e\u7ec6.\u8f6c\u5165\u51cf\u503c\u51c6\u5907"});
            list.add(new Object[]{dataRuleId, ruleEntryIds[index++], "3", "fa_mergebill", 731601043674138625L, " inentryentity.outentryentity.outoriginalval", "\u8bb0\u8d26\u6807\u8bc6 \u4e0d\u7b49\u4e8e \u65e0\u9700\u8bb0\u8d26", 0, "{\"expression\":\"\",\"exprTran\":\"\u8bb0\u8d26\u6807\u8bc6 \u4e0d\u7b49\u4e8e \u65e0\u9700\u8bb0\u8d26\",\"description\":{\"zh_CN\":\"\"},\"filterCondition\":{\"filterRow\":[{\"id\":\"3EMW8/OY3A45\",\"leftBracket\":\"\",\"compareType\":\"106\",\"fieldName\":\"voucherflag\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3EMW8/OY3=FX\",\"value\":\"A\"}],\"baseDataIds\":[]}],\"forList\":false},\"filterString\":\"{\\\"filterRow\\\":[{\\\"id\\\":\\\"3EMW8/OY3A45\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"106\\\",\\\"fieldName\\\":\\\"voucherflag\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"0\\\",\\\"value\\\":[{\\\"id\\\":\\\"3EMW8/OY3=FX\\\",\\\"value\\\":\\\"A\\\"}],\\\"baseDataIds\\\":[]}],\\\"forList\\\":false}\",\"initialized\":false,\"localeExprTran\":{\"zh_CN\":\"\u8bb0\u8d26\u6807\u8bc6 \u4e0d\u7b49\u4e8e \u65e0\u9700\u8bb0\u8d26\"},\"exprDesc\":\"\u8bb0\u8d26\u6807\u8bc6 \u4e0d\u7b49\u4e8e \u65e0\u9700\u8bb0\u8d26\"}", ++maxSeq, 1566696595985130496L, "1", " \u8f6c\u5165\u8d44\u4ea7\u660e\u7ec6.\u8f6c\u51fa\u8d44\u4ea7\u660e\u7ec6.\u8f6c\u51fa\u8d44\u4ea7\u539f\u503c"});
            list.add(new Object[]{dataRuleId, ruleEntryIds[index++], "2", "fa_mergebill", 731601043674138626L, " inentryentity.outentryentity.outaccumdepre", "\u8bb0\u8d26\u6807\u8bc6 \u4e0d\u7b49\u4e8e \u65e0\u9700\u8bb0\u8d26", 0, "{\"expression\":\"\",\"exprTran\":\"\u8bb0\u8d26\u6807\u8bc6 \u4e0d\u7b49\u4e8e \u65e0\u9700\u8bb0\u8d26\",\"description\":{\"zh_CN\":\"\"},\"filterCondition\":{\"filterRow\":[{\"id\":\"3EMW8WQ4QXAJ\",\"leftBracket\":\"\",\"compareType\":\"106\",\"fieldName\":\"voucherflag\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3EMW8WQ4PDR8\",\"value\":\"A\"}],\"baseDataIds\":[]}],\"forList\":false},\"filterString\":\"{\\\"filterRow\\\":[{\\\"id\\\":\\\"3EMW8WQ4QXAJ\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"106\\\",\\\"fieldName\\\":\\\"voucherflag\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"0\\\",\\\"value\\\":[{\\\"id\\\":\\\"3EMW8WQ4PDR8\\\",\\\"value\\\":\\\"A\\\"}],\\\"baseDataIds\\\":[]}],\\\"forList\\\":false}\",\"initialized\":false,\"localeExprTran\":{\"zh_CN\":\"\u8bb0\u8d26\u6807\u8bc6 \u4e0d\u7b49\u4e8e \u65e0\u9700\u8bb0\u8d26\"},\"exprDesc\":\"\u8bb0\u8d26\u6807\u8bc6 \u4e0d\u7b49\u4e8e \u65e0\u9700\u8bb0\u8d26\"}", ++maxSeq, 1566696595985130496L, "1", " \u8f6c\u5165\u8d44\u4ea7\u660e\u7ec6.\u8f6c\u51fa\u8d44\u4ea7\u660e\u7ec6.\u8f6c\u51fa\u7d2f\u8ba1\u6298\u65e7"});
            list.add(new Object[]{dataRuleId, ruleEntryIds[index++], "2", "fa_mergebill", 731601043674138627L, " inentryentity.outentryentity.outdecval", "\u8bb0\u8d26\u6807\u8bc6 \u4e0d\u7b49\u4e8e \u65e0\u9700\u8bb0\u8d26", 0, "{\"expression\":\"\",\"exprTran\":\"\u8bb0\u8d26\u6807\u8bc6 \u4e0d\u7b49\u4e8e \u65e0\u9700\u8bb0\u8d26\",\"description\":{\"zh_CN\":\"\"},\"filterCondition\":{\"filterRow\":[{\"id\":\"3EMW=AWC4O91\",\"leftBracket\":\"\",\"compareType\":\"106\",\"fieldName\":\"voucherflag\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3EMW=AWFQKW9\",\"value\":\"A\"}],\"baseDataIds\":[]}],\"forList\":false},\"filterString\":\"{\\\"filterRow\\\":[{\\\"id\\\":\\\"3EMW=AWC4O91\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"106\\\",\\\"fieldName\\\":\\\"voucherflag\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"0\\\",\\\"value\\\":[{\\\"id\\\":\\\"3EMW=AWFQKW9\\\",\\\"value\\\":\\\"A\\\"}],\\\"baseDataIds\\\":[]}],\\\"forList\\\":false}\",\"initialized\":false,\"localeExprTran\":{\"zh_CN\":\"\u8bb0\u8d26\u6807\u8bc6 \u4e0d\u7b49\u4e8e \u65e0\u9700\u8bb0\u8d26\"},\"exprDesc\":\"\u8bb0\u8d26\u6807\u8bc6 \u4e0d\u7b49\u4e8e \u65e0\u9700\u8bb0\u8d26\"}", ++maxSeq, 1566696595985130496L, "1", " \u8f6c\u5165\u8d44\u4ea7\u660e\u7ec6.\u8f6c\u51fa\u8d44\u4ea7\u660e\u7ec6.\u8f6c\u51fa\u51cf\u503c\u51c6\u5907"});
        }
        DB.executeBatch((DBRoute)DB_ROUTE_AI, (String)INSERT_T_AI_REC_DATARULEENTRY, list);
    }
}

