/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.upgradeservice;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.frm.common.util.ThrowableHelper;

public class FrmPlanEntryCloseParamUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(FrmPlanEntryCloseParamUpgradeService.class);
    private static final DBRoute ROUTE_FI = DBRoute.of((String)"fi");

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        ArrayList<Object[]> params;
        Throwable throwable;
        TXHandle h;
        UpgradeResult result;
        block18: {
            Iterator iterator;
            block19: {
                block20: {
                    result = new UpgradeResult();
                    h = TX.requiresNew();
                    throwable = null;
                    String selectSql = "SELECT fid,fcloseparam FROM t_ai_recon_scheme";
                    DataSet schemeDs = DB.queryDataSet((String)"FrmPlanEntryCloseParamUpgradeService.queryScheme", (DBRoute)ROUTE_FI, (String)selectSql);
                    params = new ArrayList<Object[]>(1000);
                    for (Row scheme : schemeDs) {
                        Object[] param = new Object[]{scheme.getBoolean("fcloseparam"), scheme.getLong("fid")};
                        params.add(param);
                    }
                    if (params.size() != 0) break block18;
                    logger.info("No plan to upgrade !");
                    result.setSuccess(true);
                    iterator = result;
                    if (h == null) break block19;
                    if (throwable == null) break block20;
                    try {
                        h.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block19;
                }
                h.close();
            }
            return iterator;
        }
        try {
            try {
                this.upgradePlanEntry("t_ai_recon_schemeentry", params);
                this.upgradePlanEntry("t_ai_recon_tab2entry", params);
                this.upgradePlanEntry("t_ai_recon_tab3entry", params);
                result.setSuccess(true);
            }
            catch (Exception e) {
                h.markRollback();
                logger.error("Upgrade planEntry failed !", (Throwable)e);
                result.setSuccess(false);
                result.setErrorInfo(ThrowableHelper.toString((Exception)e));
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        catch (Throwable throwable4) {
            throw throwable4;
        }
        finally {
            if (h != null) {
                if (throwable != null) {
                    try {
                        h.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    h.close();
                }
            }
        }
        return result;
    }

    private void upgradePlanEntry(String tableName, List<Object[]> params) {
        String updateSql = "UPDATE " + tableName + " SET fcloseparam = ? WHERE fid = ?";
        DB.executeBatch((DBRoute)ROUTE_FI, (String)updateSql, params);
    }
}

