/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.upgradeservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.frm.common.util.ThrowableHelper;

public class ReconCommonFilterAssistUpService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(ReconCommonFilterAssistUpService.class);
    private static Map<String, String> BIZ_ASSIST_DBKEY_MAP = new HashMap<String, String>(10);

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try (TXHandle h = TX.requiresNew();){
            try {
                String querySql = "select fid,fentity,fitemclasstype from t_ai_rec_common_filter where fitemclasstype != ' '";
                DataSet needUpCommonFilters = DB.queryDataSet((String)"ReconCommonFilterAssistUpService", (DBRoute)DBRoute.of((String)"fi"), (String)querySql);
                ArrayList<Object[]> batchUpParams = new ArrayList<Object[]>(20);
                for (Row row : needUpCommonFilters) {
                    Long pk = row.getLong("fid");
                    String mainEntity = row.getString("fentity");
                    String itemClassTypeCfg = row.getString("fitemclasstype");
                    if (StringUtils.isEmpty((CharSequence)itemClassTypeCfg)) continue;
                    String[] typeCfgSplit = itemClassTypeCfg.split(":");
                    Map<String, String> fieldMapCfg = this.queryFieldMapConfig(pk);
                    String cfgFieldKey = fieldMapCfg.get(typeCfgSplit[1]);
                    if (cfgFieldKey == null) continue;
                    cfgFieldKey = BIZ_ASSIST_DBKEY_MAP.get(cfgFieldKey);
                    String queryEntryConfigSql = String.format("select %s from t_ai_rec_common_entry where fid = %s", cfgFieldKey, pk);
                    DataSet entryCfgDataSet = DB.queryDataSet((String)"ReconCommonFilterAssistUpService", (DBRoute)DBRoute.of((String)"fi"), (String)queryEntryConfigSql).top(1);
                    if (entryCfgDataSet.isEmpty()) continue;
                    Row cfgRow = (Row)entryCfgDataSet.iterator().next();
                    String itemClassProp = cfgRow.getString(cfgFieldKey);
                    String upItemClassProp = itemClassProp + "(" + typeCfgSplit[1] + ":" + typeCfgSplit[0] + ")";
                    DB.execute((DBRoute)DBRoute.of((String)"fi"), (String)("update t_ai_rec_common_entry set " + cfgFieldKey + " = ? where fid = ?"), (Object[])new Object[]{upItemClassProp, pk});
                    batchUpParams.add(new Object[]{itemClassTypeCfg, pk});
                }
                if (batchUpParams.size() > 0) {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"fi"), (String)"update t_ai_rec_common_filter set fitemclasstype = ' ', fitemclassbak = ? where fid = ?", batchUpParams);
                }
            }
            catch (Exception e) {
                h.markRollback();
                logger.error("\u5347\u7ea7\u7a0b\u5e8f\u6267\u884c\u5931\u8d25", (Throwable)e);
                result.setSuccess(false);
                result.setErrorInfo(ThrowableHelper.toString((Exception)e));
            }
        }
        return result;
    }

    private Map<String, String> queryFieldMapConfig(Long commonFilterPk) {
        String queryFieldMapSql = "select fentityid,ffieldkey from t_ai_acctfieldmapentry where fid = " + commonFilterPk;
        HashMap<String, String> fieldMap = new HashMap<String, String>(4);
        DB.query((DBRoute)DBRoute.of((String)"fi"), (String)queryFieldMapSql, resultSet -> {
            while (resultSet.next()) {
                String entityId = resultSet.getString("fentityid");
                String fieldKey = resultSet.getString("ffieldkey");
                fieldMap.put(entityId, fieldKey);
            }
            return fieldMap;
        });
        return fieldMap;
    }

    static {
        BIZ_ASSIST_DBKEY_MAP.put("basedata0", "fbizassist0");
        BIZ_ASSIST_DBKEY_MAP.put("basedata1", "fbizassist1");
        BIZ_ASSIST_DBKEY_MAP.put("basedata2", "fbizassist2");
        BIZ_ASSIST_DBKEY_MAP.put("basedata3", "fbizassist3");
        BIZ_ASSIST_DBKEY_MAP.put("basedata4", "fbizassist4");
        BIZ_ASSIST_DBKEY_MAP.put("basedata5", "fbizassist5");
        BIZ_ASSIST_DBKEY_MAP.put("basedata6", "fbizassist6");
        BIZ_ASSIST_DBKEY_MAP.put("basedata7", "fbizassist7");
    }
}

