/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.upgradeservice;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.frm.common.util.ThrowableHelper;

public class ReconDataRuleSeqUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(ReconDataRuleSeqUpgradeService.class);
    private static final String reSeqUpdateSql = "update t_ai_recdataruleentry set fseq = ? where fentryid = ?";

    /*
     * WARNING - void declaration
     */
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult upgradeResult = new UpgradeResult();
        try {
            StringBuilder queryPresetDataRuleSql = new StringBuilder();
            queryPresetDataRuleSql.append("select a.fid, b.fentryid , b.fseq ").append("from t_ai_recdatarule a left join t_ai_recdataruleentry b on a.fid = b.fid ").append("where a.fpreset = '1' ").append("order by a.fid, b.fseq");
            HashMap dataRuleMap = new HashMap(16);
            DataSet presetDataRuleDs = DB.queryDataSet((String)"ReconDataRuleSeqUpgradeService", (DBRoute)DBRoute.of((String)"fi"), (String)queryPresetDataRuleSql.toString());
            Object object = null;
            try {
                Object var10_11 = null;
                ArrayList<Object[]> upRules = new ArrayList<Object[]>(10);
                for (Row dataRule : presetDataRuleDs) {
                    void var10_12;
                    Long ruleId = dataRule.getLong("fid");
                    Long entryId = dataRule.getLong("fentryid");
                    Integer seq = dataRule.getInteger("fseq");
                    Object[] entry = new Object[]{entryId, seq};
                    if (var10_12 == null) {
                        Long l = ruleId;
                    }
                    if (var10_12.equals(ruleId)) {
                        upRules.add(entry);
                        continue;
                    }
                    dataRuleMap.put(var10_12, upRules);
                    upRules = new ArrayList(10);
                    upRules.add(entry);
                    Object var10_14 = null;
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (presetDataRuleDs != null) {
                    if (object != null) {
                        try {
                            presetDataRuleDs.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        presetDataRuleDs.close();
                    }
                }
            }
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(50);
            for (Map.Entry entry : dataRuleMap.entrySet()) {
                paramList.addAll(this.reSeqRuleEntry((List)entry.getValue()));
            }
            if (paramList.size() > 0) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"fi"), (String)reSeqUpdateSql, paramList);
            }
        }
        catch (Exception e) {
            logger.error("\u53d6\u6570\u89c4\u5219\u66f4\u65b0\u5206\u5f55\u5e8f\u53f7\u5931\u8d25", (Throwable)e);
            upgradeResult.setSuccess(false);
            upgradeResult.setErrorInfo(ThrowableHelper.toString((Exception)e));
        }
        return upgradeResult;
    }

    private List<Object[]> reSeqRuleEntry(List<Object[]> dataRuleEntryDs) {
        try {
            boolean needReSeq;
            HashSet<Integer> seqSet = new HashSet<Integer>(20);
            for (Object[] item : dataRuleEntryDs) {
                seqSet.add((Integer)item[1]);
            }
            boolean bl = needReSeq = seqSet.size() != dataRuleEntryDs.size();
            if (!needReSeq) {
                return Collections.emptyList();
            }
            int index = 1;
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(dataRuleEntryDs.size());
            for (Object[] item : dataRuleEntryDs) {
                paramList.add(new Object[]{index, item[0]});
                ++index;
            }
            return paramList;
        }
        catch (Exception e) {
            logger.error("\u53d6\u6570\u89c4\u5219\u66f4\u65b0\u5206\u5f55\u5e8f\u53f7\u5931\u8d25", (Throwable)e);
            return Collections.emptyList();
        }
    }
}

