/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.upgradeservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.ExceptionUtils;
import kd.fi.frm.common.util.FrmStringUtil;

public class ReconPlanAssistUpgradeService
implements IUpgradeService {
    private static final Log log = LogFactory.getLog((String)ReconPlanAssistUpgradeService.class.getName());
    private static final String ALGO_KEY = ReconPlanAssistUpgradeService.class.getName();
    private int logIndex = 1;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        this.logIndex = 1;
        UpgradeResult result = new UpgradeResult();
        try {
            this.exec();
            result.setSuccess(true);
            log.info("UPGRADE_CHANGEBILL_SUCCESS");
        }
        catch (Exception e) {
            result.setSuccess(false);
            log.info("UPGRADE_CHANGEBILL_ERROR");
            result.setErrorInfo("UPGRADE_CHANGEBILL_ERROR" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return result;
    }

    private void exec() {
        String sql = "SELECT %s FROM t_bas_flex_property T1 INNER JOIN t_bas_flex_property_L T2 ON T1.FENTRYID=T2.FENTRYID WHERE T2.FLOCALEID='zh_CN';";
        String fields = FrmStringUtil.comma((String[])new String[]{FrmStringUtil.dot((String[])new String[]{"T1", "fentryid fentryid"}), FrmStringUtil.dot((String[])new String[]{"T1", "fnumber fnumber"}), FrmStringUtil.dot((String[])new String[]{"T2", "fname fname"})});
        sql = String.format(sql, fields);
        HashMap<Long, String[]> assistDescMap = new HashMap<Long, String[]>();
        try (DataSet ds = DB.queryDataSet((String)ALGO_KEY, (DBRoute)DBRoute.base, (String)sql);){
            for (Row row : ds) {
                String[] assistInfo = new String[]{row.getString("fnumber"), row.getString("fname")};
                assistDescMap.put(row.getLong("fentryid"), assistInfo);
            }
        }
        String tableName = "t_ai_recon_tab2entry";
        String mulBasedataTableName = "t_ai_recon_scheme_assist1";
        String assistInfoFieldName = "fmulassistinfo_tag";
        String assistInfoDescFieldName = "fmulassistinfodesc";
        this.upgradeReconPlanTab(tableName, mulBasedataTableName, assistInfoFieldName, assistInfoDescFieldName, assistDescMap);
        tableName = "t_ai_recon_tab3entry";
        mulBasedataTableName = "t_ai_recon_scheme_assist2";
        assistInfoFieldName = "fmulassist2info_tag";
        assistInfoDescFieldName = "fmulassist2infodesc";
        this.upgradeReconPlanTab(tableName, mulBasedataTableName, assistInfoFieldName, assistInfoDescFieldName, assistDescMap);
    }

    private void upgradeReconPlanTab(String tableName, String mulBasedataTableName, String assistInfoFieldName, String assistInfoDescFieldName, Map<Long, String[]> assistDescMap) {
        String sql_upgrade = "UPDATE %s SET %s = ?, %s = ? WHERE fentryid = ? AND (%s = ' ' or %s = '' or %s is null)";
        sql_upgrade = String.format(sql_upgrade, tableName, assistInfoFieldName, assistInfoDescFieldName, assistInfoDescFieldName, assistInfoDescFieldName, assistInfoDescFieldName);
        ArrayList<Object[]> paramLst_upgrade = new ArrayList<Object[]>();
        String sql = "SELECT T1.fentryid fentryid, T2.fbasedataid fbasedataid FROM %s T1 INNER JOIN %s T2 ON T1.fentryid = T2.fentryid ORDER BY T1.fentryid";
        sql = String.format(sql, tableName, mulBasedataTableName);
        log.error(this.logIndex++ + sql);
        try (DataSet ds = DB.queryDataSet((String)ALGO_KEY, (DBRoute)DBRoute.of((String)"fi"), (String)sql);){
            log.error(this.logIndex++ + "ds.isEmpty(): " + ds.copy().isEmpty());
            long fentryid = -1111L;
            HashSet<Long> fbasedataIdLst = new HashSet<Long>();
            for (Row row : ds) {
                long row_fentryid = row.getLong("fentryid");
                if (row_fentryid != fentryid) {
                    if (!fbasedataIdLst.isEmpty()) {
                        paramLst_upgrade.add(this.buildUpgradeParam(fbasedataIdLst, fentryid, assistDescMap));
                        fbasedataIdLst.clear();
                    }
                    fentryid = row_fentryid;
                }
                fbasedataIdLst.add(row.getLong("fbasedataid"));
            }
            if (!fbasedataIdLst.isEmpty()) {
                paramLst_upgrade.add(this.buildUpgradeParam(fbasedataIdLst, fentryid, assistDescMap));
            }
        }
        log.error(this.logIndex++ + sql_upgrade);
        log.error(this.logIndex++ + "" + paramLst_upgrade.size());
        if (!paramLst_upgrade.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"fi"), (String)sql_upgrade, paramLst_upgrade);
        }
    }

    private Object[] buildUpgradeParam(Set<Long> fbasedataIdLst, long fentryid, Map<Long, String[]> assistDescMap) {
        StringBuilder assistInfoDesc = new StringBuilder();
        ArrayList assistInfoLst = new ArrayList(fbasedataIdLst.size());
        for (Long assistId : fbasedataIdLst) {
            HashMap<String, String> assistInfoMap = new HashMap<String, String>();
            assistInfoMap.put("conditionTag", "");
            assistInfoMap.put("assistId", assistId.toString());
            assistInfoLst.add(assistInfoMap);
            String[] assistDescArr = assistDescMap.get(assistId);
            if (assistDescArr == null) continue;
            assistInfoDesc.append(String.format(";%s,%s", assistDescArr[0], assistDescArr[1]));
        }
        Object[] param_upgrade = new Object[]{SerializationUtils.toJsonString(assistInfoLst), assistInfoDesc.substring(1), fentryid};
        log.error(this.logIndex++ + "param1: " + param_upgrade[0].toString());
        log.error(this.logIndex++ + "param2: " + param_upgrade[1].toString());
        log.error(this.logIndex++ + "param3: " + param_upgrade[2].toString());
        return param_upgrade;
    }
}

