/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.upgradeservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.frm.common.util.ReconciliationUtil;
import kd.fi.frm.common.util.ThrowableHelper;
import kd.fi.frm.upgradeservice.ReconPlanAssistUpgradeService;

public class ReconPlanDataRuleIdUpgradeService
implements IUpgradeService {
    private static final Log log = LogFactory.getLog((String)ReconPlanAssistUpgradeService.class.getName());
    private static final String ALGO_KEY = ReconPlanDataRuleIdUpgradeService.class.getName();
    private static final String DB_ROUT_AI = "Ai";
    private static final Long MAIN_BOOK_TYPE_ID = 237528347981256704L;
    private static final int RETRY_TIME = 60;

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        try (TXHandle txHandle = TX.requiresNew();){
            UpgradeResult upgradeResult = new UpgradeResult();
            try {
                this.exec();
                upgradeResult.setSuccess(true);
                log.info("UPGRADE RECONCILIATION SCHEME SUCCESS");
            }
            catch (Exception e) {
                txHandle.markRollback();
                upgradeResult.setSuccess(false);
                log.info("UPGRADE RECONCILIATION SCHEME ERROR");
                upgradeResult.setErrorInfo("UPGRADE RECONCILIATION SCHEME ERROR" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
            UpgradeResult upgradeResult2 = upgradeResult;
            return upgradeResult2;
        }
    }

    private void exec() throws InterruptedException {
        DBRoute ai = DBRoute.of((String)DB_ROUT_AI);
        DynamicObject[] schemeArr = this.loadScheme(ai);
        if (schemeArr == null || schemeArr.length == 0) {
            return;
        }
        DynamicObjectCollection rules = this.getDataRule();
        HashMap<String, Long> bizAppCreateOrgMap = new HashMap<String, Long>(rules.size());
        HashMap<Long, DynamicObject> allRuleMap = new HashMap<Long, DynamicObject>(rules.size());
        for (DynamicObject rule : rules) {
            Long id_r = rule.getLong("id");
            DynamicObject[] bizAppId_r = rule.getString("bizapp.id");
            long createOrgId_r = rule.getLong("createorg.id");
            bizAppCreateOrgMap.put((String)bizAppId_r + "," + createOrgId_r, id_r);
            allRuleMap.put(id_r, rule);
        }
        ArrayList<DynamicObject> updateSchemeList = new ArrayList<DynamicObject>(12);
        HashMap<Long, DynamicObject> allPlanMap = new HashMap<Long, DynamicObject>(schemeArr.length);
        ArrayList<String> existSchemes = new ArrayList<String>(12);
        for (DynamicObject dynamicObject : schemeArr) {
            allPlanMap.put(dynamicObject.getLong("id"), dynamicObject);
            Long ruleId = dynamicObject.getLong("reconciliactionconfig_id");
            if (ruleId == null || ruleId == 0L) {
                updateSchemeList.add(dynamicObject);
            } else {
                allRuleMap.remove(ruleId);
            }
            if (!"1".equals(dynamicObject.get("enable"))) continue;
            existSchemes.add(((DynamicObject)dynamicObject.get("useorg")).get("id") + "," + ((DynamicObject)dynamicObject.get("bizapp")).get("id"));
        }
        if (updateSchemeList.size() > 0) {
            for (DynamicObject scheme : updateSchemeList) {
                String bizAppId_s = scheme.getString("bizapp_id");
                Long createOrgId_s = scheme.getLong("createorg_id");
                String firstKey = bizAppId_s + "," + createOrgId_s;
                String secondKey = bizAppId_s + "," + OrgUnitServiceHelper.getRootOrgId();
                Long ruleId = (Long)bizAppCreateOrgMap.get(firstKey);
                if (ruleId == null) {
                    ruleId = (Long)bizAppCreateOrgMap.get(secondKey);
                }
                if (ruleId == null) continue;
                scheme.set("reconciliactionconfig_id", (Object)ruleId);
                allRuleMap.remove(ruleId);
            }
        }
        HashSet<Object> useOrgs = new HashSet<Object>(allRuleMap.size());
        for (DynamicObject rule : allRuleMap.values()) {
            useOrgs.add(rule.get("createorg.id"));
        }
        Map<Long, Long> accountBookMap = this.getAccountBook(ai, useOrgs);
        long[] newSchemeIds = DB.genLongIds((String)"t_ai_recon_scheme", (int)allRuleMap.size());
        ArrayList<Long[]> schemeU = new ArrayList<Long[]>(updateSchemeList.size());
        StringBuilder numberBuilder = new StringBuilder();
        StringBuilder nameBuilder = new StringBuilder();
        int index = 0;
        for (DynamicObject rule : allRuleMap.values()) {
            DynamicObject dynamicObject;
            Long orgId = rule.getLong("createorg.id");
            String bizAppId = rule.getString("bizapp.id");
            if (existSchemes.contains(orgId + "," + bizAppId)) continue;
            existSchemes.add(orgId + "," + bizAppId);
            Long acctTableId = accountBookMap.get(orgId);
            if (acctTableId == null) continue;
            DynamicObject[] matchedSchemes = null;
            Long optimalPlanId = null;
            Boolean frmPrepared = this.metaDataPrepared("frm_reconciliation_scheme");
            Boolean aiPrepared = this.metaDataPrepared("ai_reconciliation_scheme");
            if (frmPrepared.booleanValue() && aiPrepared.booleanValue()) {
                for (int retryLoadSchemeTime = 0; retryLoadSchemeTime < 60; ++retryLoadSchemeTime) {
                    try {
                        matchedSchemes = ReconciliationUtil.getRecScheme((Long)acctTableId, (Long)orgId, (String)bizAppId);
                        optimalPlanId = ReconciliationUtil.getOptimalPlanId((DynamicObject[])matchedSchemes, (Long)orgId, (Long)MAIN_BOOK_TYPE_ID);
                        break;
                    }
                    catch (Exception e) {
                        log.error("\u67e5\u8be2\u5bf9\u8d26\u65b9\u6848\u51fa\u9519!" + ThrowableHelper.toString((Exception)e));
                        Thread.sleep(5000L);
                        continue;
                    }
                }
            }
            if (optimalPlanId == null || (dynamicObject = (DynamicObject)allPlanMap.get(optimalPlanId)) == null) continue;
            DynamicObject newScheme = (DynamicObject)new CloneUtils(true, true).clone((IDataEntityBase)dynamicObject);
            newScheme.set("reconciliactionconfig_id", (Object)rule.getLong("id"));
            newScheme.set("useorg_id", (Object)orgId);
            newScheme.set("createorg_id", (Object)orgId);
            newScheme.set("org_id", (Object)orgId);
            numberBuilder = new StringBuilder();
            nameBuilder = new StringBuilder();
            nameBuilder.append(rule.get("createorg.name")).append('_').append(rule.get("bizapp.name"));
            numberBuilder.append(rule.get("createorg.number")).append('_').append(rule.get("bizapp.number"));
            newScheme.set("number", (Object)numberBuilder.toString().toUpperCase());
            newScheme.set("name", (Object)nameBuilder.toString().toUpperCase());
            newScheme.set("ctrlstrategy", (Object)"7");
            newScheme.set("id", (Object)newSchemeIds[index]);
            newScheme.set("masterid", (Object)newSchemeIds[index]);
            schemeU.add(new Long[]{newSchemeIds[index], orgId});
            ++index;
            updateSchemeList.add(newScheme);
        }
        Boolean frmPrepared = this.metaDataPrepared("frm_reconciliation_scheme");
        if (frmPrepared.booleanValue()) {
            SaveServiceHelper.save((DynamicObject[])updateSchemeList.toArray(new DynamicObject[0]));
        }
        if (schemeU.size() > 0) {
            DB.executeBatch((DBRoute)ai, (String)"insert into t_ai_recon_scheme_u(fdataid,fuseorgid) values (?,?)", schemeU);
        }
    }

    private DynamicObject[] loadScheme(DBRoute dbRoute) throws InterruptedException {
        String schemeIdSql = "SELECT fid FROM t_ai_recon_scheme;";
        ArrayList<Object> schemeIdList = new ArrayList<Object>(12);
        try (DataSet ds = DB.queryDataSet((String)ALGO_KEY, (DBRoute)dbRoute, (String)schemeIdSql);){
            for (Row row : ds) {
                schemeIdList.add(row.get("fid"));
            }
        }
        if (schemeIdList.size() == 0) {
            return new DynamicObject[0];
        }
        Boolean prepared = this.metaDataPrepared("frm_reconciliation_scheme");
        DynamicObject[] load = null;
        if (prepared.booleanValue()) {
            load = BusinessDataServiceHelper.load((Object[])schemeIdList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"frm_reconciliation_scheme"));
        }
        return load;
    }

    private DynamicObjectCollection getDataRule() throws InterruptedException {
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        HashSet<Long> idSet = new HashSet<Long>(2);
        idSet.add(1283346385885737984L);
        idSet.add(1305729722814088192L);
        idSet.add(1358565117804983295L);
        idSet.add(1358565117804983296L);
        idSet.add(1393557998676213760L);
        idSet.add(1393550434307671040L);
        QFilter idFilter = new QFilter("id", "not in", idSet);
        DynamicObjectCollection dataRuleCollection = new DynamicObjectCollection();
        Boolean prepared = this.metaDataPrepared("frm_recdatarule");
        if (prepared.booleanValue()) {
            dataRuleCollection = QueryServiceHelper.query((String)"frm_recdatarule", (String)"id,bizapp.id,bizapp.number,bizapp.name, createorg.id, createorg.number, createorg.name", (QFilter[])new QFilter[]{enableFilter, idFilter});
        }
        return dataRuleCollection;
    }

    private Map<Long, Long> getAccountBook(DBRoute route, Set<Object> useOrgs) {
        HashMap<Long, Long> accountTableMap = new HashMap<Long, Long>(12);
        if (useOrgs != null && useOrgs.size() > 0) {
            SqlBuilder accountBoosSelectSqlBuilder = new SqlBuilder();
            accountBoosSelectSqlBuilder.appendIn("SELECT DISTINCT tba.faccounttableid AS faccounttableid,tba.forgid AS forgid  from t_bd_accountbooks tba WHERE tba.fenable = '1' AND tba.fbookstypeid = 237528347981256704 AND tba.forgid", useOrgs.toArray());
            try (DataSet ds = DB.queryDataSet((String)ALGO_KEY, (DBRoute)route, (SqlBuilder)accountBoosSelectSqlBuilder);){
                for (Row row : ds) {
                    accountTableMap.put(row.getLong("forgid"), row.getLong("faccounttableid"));
                }
            }
        }
        return accountTableMap;
    }

    private boolean metaDataPrepared(String entityName) throws InterruptedException {
        boolean prepared = Boolean.FALSE;
        for (int i = 0; i < 60; ++i) {
            try {
                EntityMetadataCache.getDataEntityType((String)entityName);
                prepared = true;
                break;
            }
            catch (Exception e) {
                Thread.sleep(5000L);
                log.error("Get metadataCache falied !" + e.getMessage());
                log.error("Get metadataCache falied ! Retrying " + i);
                continue;
            }
        }
        return prepared;
    }
}

