/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.upgradeservice;

import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.ExceptionUtils;

public class ReconSchemeAccountsUpgradeService
implements IUpgradeService {
    private static final Log log = LogFactory.getLog((String)ReconSchemeAccountsUpgradeService.class.getName());
    private static final String ALGO_KEY = ReconSchemeAccountsUpgradeService.class.getName();
    private static final String DB_ROUT_AI = "Ai";

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        try (TXHandle txHandle = TX.requiresNew();){
            UpgradeResult upgradeResult = new UpgradeResult();
            try {
                this.exec();
                upgradeResult.setSuccess(true);
                log.info("UPGRADE SCHEME ACCOUNTS SUCCESS");
            }
            catch (Exception e) {
                txHandle.markRollback();
                upgradeResult.setSuccess(false);
                log.info("UPGRADE SCHEME ACCOUNTS ERROR");
                upgradeResult.setErrorInfo("UPGRADE SCHEME ACCOUNTS" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
            UpgradeResult upgradeResult2 = upgradeResult;
            return upgradeResult2;
        }
    }

    private void exec() {
        DBRoute ai = DBRoute.of((String)DB_ROUT_AI);
        String selectSql = "select fentryid,faccount from t_ai_recon_schemeentry where fentryid not in (select fentryid from t_frm_scheme_account)";
        ArrayList<Object[]> insertParam = new ArrayList<Object[]>(12);
        try (DataSet ds = DB.queryDataSet((String)ALGO_KEY, (DBRoute)ai, (String)selectSql);){
            for (Row row : ds) {
                Object[] arr = new Object[3];
                arr[1] = row.get("fentryid");
                arr[2] = row.get("faccount");
                insertParam.add(arr);
            }
        }
        if (insertParam.size() > 0) {
            long[] newSchemeIds = DB.genLongIds((String)"t_frm_scheme_account", (int)insertParam.size());
            for (int i = 0; i < insertParam.size(); ++i) {
                ((Object[])insertParam.get((int)i))[0] = newSchemeIds[i];
            }
            DB.executeBatch((DBRoute)ai, (String)"INSERT INTO t_frm_scheme_account (fpkid,fentryid,fbasedataid) VALUES (?,?,?)", insertParam);
        }
    }
}

