/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.upgradeservice;

import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.ExceptionUtils;

public class SchemeUseOrgUpgradeService
implements IUpgradeService {
    private static final Log log = LogFactory.getLog((String)SchemeUseOrgUpgradeService.class.getName());
    private static final String ALGO_KEY = SchemeUseOrgUpgradeService.class.getName();
    private static final String DB_ROUT_AI = "Ai";

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        try (TXHandle txHandle = TX.requiresNew();){
            UpgradeResult upgradeResult = new UpgradeResult();
            try {
                this.exec();
                upgradeResult.setSuccess(true);
                log.info("UPGRADE SCHEME USEORG SUCCESS");
            }
            catch (Exception e) {
                txHandle.markRollback();
                upgradeResult.setSuccess(false);
                log.info("UPGRADE SCHEME USEORG ERROR");
                upgradeResult.setErrorInfo("UPGRADE RECONCILIATION SCHEME USEORG" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
            UpgradeResult upgradeResult2 = upgradeResult;
            return upgradeResult2;
        }
    }

    private void exec() {
        DBRoute ai = DBRoute.of((String)DB_ROUT_AI);
        String selectSql = "select fid,fcreateorgid from t_ai_recon_scheme where fcreateorgid = forgid and fcreateorgid <> fuseorg";
        ArrayList<Object[]> updateParam = new ArrayList<Object[]>(12);
        try (DataSet ds = DB.queryDataSet((String)ALGO_KEY, (DBRoute)ai, (String)selectSql);){
            for (Row row : ds) {
                Object[] arr = new Object[]{row.get("fcreateorgid"), row.get("fid")};
                updateParam.add(arr);
            }
        }
        if (updateParam.size() > 0) {
            DB.executeBatch((DBRoute)ai, (String)"update t_ai_recon_scheme set fuseorg = ? where fid = ?", updateParam);
        }
    }
}

