/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.algox;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.Input;
import kd.bos.algo.input.OrmInput;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.fi.frm.algox.BigFilter;
import kd.fi.frm.algox.DataRangeHolder;

public class DataInputFactory {
    private static final Log logger = LogFactory.getLog(DataInputFactory.class);
    private static final String ALGOKEY = "kd.fi.ai.reconciliation.algox.DataInputFactory";
    private final DataRangeHolder holder;
    private BigFilter bigFilter = null;

    public DataInputFactory(DataRangeHolder holder) {
        this.holder = holder;
    }

    public Input[] createQueryBizDataInput() {
        ArrayList<OrmInput> inputList = new ArrayList<OrmInput>();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)this.holder.getParam().getEntityKey());
        List<QFilter[]> splitFilters = this.holder.getSplitFilters();
        if (splitFilters != null && splitFilters.size() > 0) {
            for (QFilter[] splitFilter : splitFilters) {
                OrmInput input;
                BigFilter bigFilter = BigFilter.getBatchQFilter(mainEntityType, splitFilter);
                if (bigFilter != null) {
                    String selectors = bigFilter.getBigProp().length() > 0 ? bigFilter.getBigProp().append(" ").append("ori_ai_bigfield").append(",").append(this.holder.getSourceEntity().getSelectString()).toString() : this.holder.getSourceEntity().getSelectString();
                    input = new OrmInput(ALGOKEY, this.holder.getParam().getEntityKey(), selectors, bigFilter.getNewQFilters().toArray(new QFilter[0]));
                } else {
                    input = new OrmInput(ALGOKEY, this.holder.getParam().getEntityKey(), this.holder.getSourceEntity().getSelectString(), splitFilter);
                }
                inputList.add(input);
            }
        }
        return inputList.toArray(new Input[inputList.size()]);
    }

    public Input[] createQueryBigDataInput() {
        ArrayList<OrmInput> inputList = new ArrayList<OrmInput>();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)this.holder.getParam().getEntityKey());
        List<QFilter[]> splitFilters = this.holder.getSplitFilters();
        if (splitFilters != null && splitFilters.size() > 0) {
            for (QFilter[] splitFilter : splitFilters) {
                this.bigFilter = BigFilter.getBigDataQFilter(mainEntityType, splitFilter);
                if (this.bigFilter == null) continue;
                OrmInput input = new OrmInput(ALGOKEY, this.bigFilter.getEntity(), "id ori_ai_bigfield", this.bigFilter.getNewQFilters().toArray(new QFilter[0]));
                inputList.add(input);
            }
        }
        return inputList.toArray(new Input[inputList.size()]);
    }

    public BigFilter getBigFilter() {
        return this.bigFilter;
    }
}

