/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.algox;

import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Set;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;

public class SumGroupReduceFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = -123814144988948840L;
    private final RowMeta resultMeta;
    private final Set<String> sumFields;

    public SumGroupReduceFunction(RowMeta outMetadata, Set<String> sumFields) {
        this.resultMeta = outMetadata;
        this.sumFields = sumFields;
    }

    public RowMeta getResultRowMeta() {
        return this.resultMeta;
    }

    public void setSourceRowMeta(RowMeta sourceRowMeta) {
        this.sourceRowMeta = this.resultMeta;
    }

    public void reduce(Iterable<RowX> paramIterable, Collector paramCollector) {
        Iterator<RowX> iterator = paramIterable.iterator();
        RowX row = null;
        while (iterator.hasNext()) {
            RowX srcRow = iterator.next();
            if (row == null) {
                row = this.createEmptyRow(srcRow, this.resultMeta);
                continue;
            }
            for (String amountField : this.sumFields) {
                this.addRowValue(row, srcRow, amountField);
            }
        }
        paramCollector.collect(row);
    }

    private RowX createEmptyRow(RowX row, RowMeta rowMeta) {
        Field[] fields = rowMeta.getFields();
        Object[] values = new Object[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            values[i] = "id".equals(fields[i].getName()) ? Long.valueOf(0L) : row.get(i);
        }
        return new RowX(values);
    }

    private void addRowValue(RowX row, RowX addRow, String field) {
        BigDecimal oldValue = row.getBigDecimal(this.resultMeta.getFieldIndex(field));
        BigDecimal addValue = addRow.getBigDecimal(this.resultMeta.getFieldIndex(field));
        if (oldValue == null) {
            oldValue = BigDecimal.ZERO;
        }
        if (addValue == null) {
            addValue = BigDecimal.ZERO;
        }
        row.set(this.resultMeta.getFieldIndex(field), (Object)oldValue.add(addValue));
    }
}

