/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.common.cache.frm;

import java.security.SecureRandom;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.dlock.DLock;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.fi.frm.common.cache.frm.AppCacheKeyEnum;
import kd.fi.frm.common.enums.DataTypeEnum;
import kd.fi.frm.common.enums.ReconcilationResultEnum;
import kd.fi.frm.common.task.TaskDao;
import kd.fi.frm.common.task.TaskInfo;
import kd.fi.frm.common.task.TaskStatusEnum;

public class AppCacheHelper {
    private static final Log log = LogFactory.getLog(AppCacheHelper.class);
    private static final int RETRY_LOCK_TIME = 5;
    protected static final SecureRandom SECURE_RANDOM = new SecureRandom();
    private static DistributeSessionlessCache newCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("frm-execcache");
    private static IAppCache cache = AppCache.get((String)"frm");

    public static Map<String, String> getAll(DataTypeEnum keyEnum, String batchNo) {
        return newCache.getAll((Object)((Object)keyEnum) + batchNo);
    }

    public static Map<String, String> getAll(String taskId) {
        return newCache.getAll(taskId);
    }

    public static void removeAll(String taskId) {
        newCache.remove(taskId);
    }

    public static Map<String, String> getBatchCache(String batchNo) {
        return newCache.getAll(batchNo);
    }

    public static String getTaskCache(String batchNo, String taskId) {
        return (String)newCache.get(batchNo, taskId);
    }

    public static void removeTaskCache(String batchNo, String taskId) {
        newCache.remove(batchNo, taskId);
    }

    @Deprecated
    public static void putAll(DataTypeEnum keyEnum, String batchNo, Map<String, String> values) {
        newCache.put((Object)((Object)keyEnum) + batchNo, values);
    }

    @Deprecated
    public static void put(DataTypeEnum keyEnum, String batchNo, String taskId, String value) {
        newCache.put((Object)((Object)keyEnum) + batchNo, taskId, (Object)value);
    }

    public static void putBatchCache(String batchNo, Map<String, String> values) {
        newCache.put(batchNo, values);
    }

    public static void putTaskCache(String batchNo, String taskId, String value) {
        newCache.put(batchNo, taskId, (Object)value);
    }

    public static void addList(String key, String value) {
        newCache.addList(key, new String[]{value});
    }

    public static String[] getList(String key) {
        return newCache.getList(key);
    }

    public static void removeAll(DataTypeEnum keyEnum, String batchNo) {
        newCache.remove((Object)((Object)keyEnum) + batchNo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TaskInfo updateTaskStatus(String batchNo, String taskId, ReconcilationResultEnum resultCode, String status, TaskStatusEnum taskStatus, Integer step, String[] error) {
        try (DLock dLock = null;){
            dLock = DLock.create((String)("UPDATE_STATUS:" + taskId)).fastMode();
            boolean getLock = dLock.tryLock(10000L);
            if (!getLock) {
                log.error("\u672c\u6b21\u5bf9\u8d26\u66f4\u65b0\u7f13\u5b58\u83b7\u53d6\u9501\u5931\u8d25,taskID={} !", (Object)taskId);
                TaskInfo taskInfo = null;
                return taskInfo;
            }
            TaskInfo taskInfo = AppCacheHelper._update(batchNo, taskId, resultCode, status, taskStatus, step, error);
            newCache.put(batchNo, taskId, (Object)SerializationUtils.serializeToBase64((Object)taskInfo));
            TaskInfo taskInfo2 = taskInfo;
            return taskInfo2;
        }
        return null;
    }

    private static TaskInfo _update(String batchNo, String taskId, ReconcilationResultEnum resultCode, String status, TaskStatusEnum taskStatus, Integer step, String[] error) {
        Integer totalStep;
        String taskCache = AppCacheHelper.getTaskCache(batchNo, taskId);
        TaskInfo taskInfo = (TaskInfo)SerializationUtils.deSerializeFromBase64((String)taskCache);
        if (TaskStatusEnum.STOPPED == taskInfo.getTaskStatus()) {
            return taskInfo;
        }
        if (resultCode != null) {
            ReconcilationResultEnum code = taskInfo.getCode();
            if (code == null) {
                taskInfo.setCode(resultCode);
            } else if (resultCode.getIndex() > code.getIndex()) {
                taskInfo.setCode(resultCode);
            }
        }
        if (step != null && (totalStep = taskInfo.getTotalStep()) != null) {
            Integer exedStep = taskInfo.getExedStep();
            int percent = (int)((double)(exedStep + step) * 100.0) / totalStep;
            taskInfo.setPercent(percent);
            taskInfo.setExedStep(exedStep + step);
        }
        if (StringUtils.isNotEmpty((String)status)) {
            taskInfo.setStatus(status);
        }
        if (error != null) {
            taskInfo.setError(error);
        }
        if (taskStatus != null) {
            TaskStatusEnum lastStatus = taskInfo.getTaskStatus();
            if (Integer.parseInt(lastStatus.getValue()) < Integer.parseInt(taskStatus.getValue())) {
                taskInfo.setTaskStatus(taskStatus);
            }
            if (TaskStatusEnum.FINISHED == taskStatus || TaskStatusEnum.ERROR == taskStatus) {
                taskInfo.setPercent(100);
            }
        }
        return taskInfo;
    }

    public static TaskInfo updateTaskStatusWithDB(String batchNo, String taskId, ReconcilationResultEnum resultCode, String status, TaskStatusEnum taskStatus, Integer step, String[] error) {
        try (DLock dLock = null;){
            dLock = DLock.create((String)("UPDATE_STATUS:" + taskId)).fastMode();
            boolean getLock = dLock.tryLock(10000L);
            if (!getLock) {
                log.error("\u672c\u6b21\u5bf9\u8d26\u66f4\u65b0\u7f13\u5b58\u83b7\u53d6\u9501\u5931\u8d25,taskID={} !", (Object)taskId);
                TaskInfo taskInfo = null;
                return taskInfo;
            }
            TaskInfo taskInfo = AppCacheHelper._update(batchNo, taskId, resultCode, status, taskStatus, step, error);
            if (TaskStatusEnum.ERROR == taskInfo.getTaskStatus()) {
                TaskDao.failTask(taskInfo);
            } else if (TaskStatusEnum.FINISHED == taskInfo.getTaskStatus()) {
                TaskDao.finishTask(taskInfo.getId(), taskInfo.getCode());
            }
            newCache.put(batchNo, taskId, (Object)SerializationUtils.serializeToBase64((Object)taskInfo));
            TaskInfo taskInfo2 = taskInfo;
            return taskInfo2;
        }
    }

    public static void putResultCache(String key, Object content) {
        cache.put(key, content);
    }

    public static String getResultCache(String key) {
        return (String)cache.get(key, String.class);
    }

    public static void removeResultCache(String key) {
        cache.remove(key);
    }

    @Deprecated
    public static void put(AppCacheKeyEnum keyEnum, String pageId, String content) {
        cache.put((Object)((Object)keyEnum) + pageId, (Object)content);
    }

    @Deprecated
    public static String get(AppCacheKeyEnum keyEnum, String pageId) {
        return (String)cache.get((Object)((Object)keyEnum) + pageId, String.class);
    }

    @Deprecated
    public static void remove(AppCacheKeyEnum keyEnum, String pageId) {
        cache.remove((Object)((Object)keyEnum) + pageId);
    }

    public static void updateDetailRestCount(String taskId, int limit, int input) {
        try (DLock dLock = null;){
            dLock = DLock.create((String)("UPDATE_DETAIL_REST_COUNT:" + taskId)).fastMode();
            boolean getLock = dLock.tryLock(10000L);
            if (!getLock) {
                return;
            }
            String restCountStr = AppCacheHelper.getResultCache("DETAIL_REST_COUNT:" + taskId);
            int restCount = StringUtils.isEmpty((String)restCountStr) ? limit : Integer.parseInt(restCountStr);
            if (restCount <= 0) {
                return;
            }
            if (restCount <= input) {
                return;
            }
            restCount = input;
            if (restCount <= 0) {
                AppCacheHelper.putResultCache("DETAIL_NOT_ALL:" + taskId, Boolean.TRUE);
            }
            AppCacheHelper.putResultCache("DETAIL_REST_COUNT:" + taskId, String.valueOf(restCount));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getDetailRestCount(String taskId, int defaultValue) {
        try (DLock dLock = DLock.create((String)("UPDATE_DETAIL_REST_COUNT:" + taskId)).fastMode();){
            boolean getLock = dLock.tryLock(10000L);
            if (!getLock) {
                int n = -1;
                return n;
            }
            String restCountStr = AppCacheHelper.getResultCache("DETAIL_REST_COUNT:" + taskId);
            if (StringUtils.isEmpty((String)restCountStr)) {
                int n = defaultValue;
                return n;
            }
            int n = Integer.parseInt(restCountStr);
            return n;
        }
        catch (Exception e) {
            log.error("Get detail rest count failed !", (Throwable)e);
            throw e;
        }
    }

    public static String getCacheTaskId() {
        return String.valueOf(DB.genGlobalLongId());
    }

    public static void updateFunctionMap(String batchNo, String taskId, String functionKey, Long functionValue) {
        try (DLock dLock = null;){
            dLock = DLock.create((String)("UPDATE_STATUS:" + taskId)).fastMode();
            boolean getLock = dLock.tryLock(10000L);
            if (!getLock) {
                log.error("\u672c\u6b21\u5bf9\u8d26\u66f4\u65b0\u7f13\u5b58\u83b7\u53d6\u9501\u5931\u8d25,taskID={} !", (Object)taskId);
                return;
            }
            String taskCache = AppCacheHelper.getTaskCache(batchNo, taskId);
            if (StringUtils.isNotEmpty((String)taskCache)) {
                TaskInfo taskInfo = (TaskInfo)SerializationUtils.deSerializeFromBase64((String)taskCache);
                Map<String, Long> functionMap = taskInfo.getFunctionMap();
                functionMap.putIfAbsent(functionKey, functionValue);
                newCache.put(batchNo, taskId, (Object)SerializationUtils.serializeToBase64((Object)taskInfo));
            }
        }
    }
}

