/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.common.cache.frm;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.frm.common.model.ReconciliationParamModel;
import kd.fi.frm.common.model.bizdata.BizDataParam;
import kd.fi.frm.common.model.bizdata.BizDataSourceConfig;
import kd.fi.frm.common.model.bizdata.BizReconPlanModel;
import kd.fi.frm.common.util.FaBillParamUtils;
import kd.fi.frm.common.util.ReconciliationParmUtil;
import kd.fi.frm.common.util.ReconciliationUtil;

public class ReconModelCacheHelper {
    private static final DistributeSessionlessCache APP_MODEL_CACHE = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("frm-modelcache");
    private static final Map<String, BizReconPlanModel> PLAN_MODEL_CACHE = new ConcurrentHashMap<String, BizReconPlanModel>(20);
    private static final Map<String, Long> PLAN_MODEL_CACHE_VERSION = new ConcurrentHashMap<String, Long>(20);
    private static final Object PLAN_LOCK = new Object();
    private static final String APP_MODEL_VERSION_LOCK_PREFIX = "UPDATE_PLAN_CACHE:";
    private static final Map<String, List<BizDataParam>> RULE_PARAM_CACHE = new ConcurrentHashMap<String, List<BizDataParam>>(20);
    private static final Map<String, Long> RULE_PARAM_CACHE_VERSION = new ConcurrentHashMap<String, Long>(20);
    private static final Object RULE_LOCK = new Object();
    private static final String APP_RULE_VERSION_LOCK_PREFIX = "UPDATE_RULE_CACHE:";
    private static final Log logger = LogFactory.getLog(ReconModelCacheHelper.class);

    public static void removePlanModel(String planId) {
        String key = RequestContext.get().getAccountId() + "_" + planId;
        PLAN_MODEL_CACHE.remove(key);
        PLAN_MODEL_CACHE_VERSION.remove(key);
        String dLockKey = APP_MODEL_VERSION_LOCK_PREFIX + planId;
        ReconModelCacheHelper.increaseCacheVersion(key, dLockKey);
    }

    public static BizReconPlanModel getPlanModel(String planId) {
        boolean planExists = QueryServiceHelper.exists((String)"frm_reconciliation_scheme", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(planId))});
        if (!planExists) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bf9\u8d26\u65b9\u6848\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664", (String)"ReconModelCacheHelper_0", (String)"fi-frm-common", (Object[])new Object[0]));
        }
        boolean planModeCacheEnable = FaBillParamUtils.getBooleanValue(0L, "frm_plan_cache_enable");
        if (planModeCacheEnable) {
            BizReconPlanModel planModel;
            boolean sameVersion;
            String key = RequestContext.get().getAccountId() + "_" + planId;
            String appCacheVersion = APP_MODEL_CACHE.get(key) == null ? "0" : (String)APP_MODEL_CACHE.get(key);
            long localCacheVersion = PLAN_MODEL_CACHE_VERSION.get(key) == null ? 0L : PLAN_MODEL_CACHE_VERSION.get(key);
            boolean bl = sameVersion = Long.parseLong(appCacheVersion) == localCacheVersion;
            if (!sameVersion) {
                PLAN_MODEL_CACHE.remove(key);
                PLAN_MODEL_CACHE_VERSION.remove(key);
            }
            if ((planModel = PLAN_MODEL_CACHE.get(key)) == null) {
                String planLockKey = "plan_lock" + Instance.getInstanceId();
                try (DLock dLock = DLock.create((String)planLockKey).fastMode();){
                    boolean getLock = dLock.tryLock(10000L);
                    if (!getLock) {
                        logger.error("Get plan lock failed ! InstanceId : {}", (Object)Instance.getInstanceId());
                    }
                    if ((planModel = PLAN_MODEL_CACHE.get(key)) == null) {
                        planModel = ReconciliationUtil.loadPlanModel(Long.valueOf(planId));
                        PLAN_MODEL_CACHE.put(key, planModel);
                    }
                }
                String dLockKey = APP_MODEL_VERSION_LOCK_PREFIX + planId;
                ReconModelCacheHelper.updateCacheVersion(dLockKey, key, PLAN_MODEL_CACHE_VERSION);
            }
            String copyString = SerializationUtils.serializeToBase64((Object)planModel);
            return (BizReconPlanModel)SerializationUtils.deSerializeFromBase64((String)copyString);
        }
        return ReconciliationUtil.loadPlanModel(Long.valueOf(planId));
    }

    public static boolean isPlanModified(Long planId) {
        boolean planExists = QueryServiceHelper.exists((String)"frm_reconciliation_scheme", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)planId)});
        if (!planExists) {
            return true;
        }
        boolean planModeCacheEnable = FaBillParamUtils.getBooleanValue(0L, "frm_plan_cache_enable");
        String key = RequestContext.get().getAccountId() + "_" + planId;
        if (!APP_MODEL_CACHE.contains(key) && planModeCacheEnable) {
            logger.info("\u5bf9\u8d26\u65b9\u6848[{}]\u5728\u7f13\u5b58\u4e2d\u4e0d\u5b58\u5728", (Object)planId);
            return true;
        }
        return false;
    }

    public static void removeRuleCache(String ruleId) {
        String key = RequestContext.get().getAccountId() + "_" + ruleId;
        RULE_PARAM_CACHE.remove(key);
        RULE_PARAM_CACHE_VERSION.remove(key);
        String dLockKey = APP_RULE_VERSION_LOCK_PREFIX + ruleId;
        ReconModelCacheHelper.increaseCacheVersion(key, dLockKey);
    }

    private static void increaseCacheVersion(String cacheKey, String dLockKey) {
        try (DLock dLock = DLock.create((String)dLockKey).fastMode();){
            boolean getLock = dLock.tryLock(10000L);
            if (!getLock) {
                logger.error("\u672c\u6b21\u66f4\u65b0\u5bf9\u8d26\u65b9\u6848\u7f13\u5b58\u7248\u672c\u53f7\u83b7\u53d6\u9501\u5931\u8d25,\u7f13\u5b58key={} !", (Object)cacheKey);
            }
            long newVersion = DBServiceHelper.genGlobalLongId();
            APP_MODEL_CACHE.put(cacheKey, (Object)String.valueOf(newVersion));
        }
        catch (Exception interruptedException) {
            logger.error("Update plan version cache failed !", (Throwable)interruptedException);
        }
    }

    public static List<BizDataParam> getRuleParam(Long orgId, DynamicObject dataRule, ReconciliationParamModel paramModel) {
        List<BizDataParam> bizDataParams;
        boolean sameVersion;
        long ruleId = dataRule.getLong("id");
        String key = RequestContext.get().getAccountId() + "_" + ruleId;
        String appCacheVersion = APP_MODEL_CACHE.get(key) == null ? "0" : (String)APP_MODEL_CACHE.get(key);
        long localCacheVersion = RULE_PARAM_CACHE_VERSION.get(key) == null ? 0L : RULE_PARAM_CACHE_VERSION.get(key);
        boolean bl = sameVersion = Long.parseLong(appCacheVersion) == localCacheVersion;
        if (!sameVersion) {
            RULE_PARAM_CACHE.remove(key);
            RULE_PARAM_CACHE_VERSION.remove(key);
        }
        if ((bizDataParams = RULE_PARAM_CACHE.get(key)) == null) {
            String ruleLockKey = "rule_lock" + Instance.getInstanceId();
            try (DLock dLock = DLock.create((String)ruleLockKey).fastMode();){
                boolean getLock = dLock.tryLock(10000L);
                if (!getLock) {
                    logger.error("Get rule lock failed ! InstanceId : {}", (Object)Instance.getInstanceId());
                }
                if ((bizDataParams = RULE_PARAM_CACHE.get(key)) == null) {
                    bizDataParams = ReconciliationParmUtil.loadDataRuleParam(dataRule, paramModel, orgId);
                }
                RULE_PARAM_CACHE.put(key, bizDataParams);
            }
            String dLockKey = APP_RULE_VERSION_LOCK_PREFIX + ruleId;
            ReconModelCacheHelper.updateCacheVersion(dLockKey, key, RULE_PARAM_CACHE_VERSION);
        }
        ArrayList<BizDataParam> result = new ArrayList<BizDataParam>(bizDataParams.size());
        for (BizDataParam bizDataParam : bizDataParams) {
            BizDataSourceConfig sourceConfig = bizDataParam.getSourceConfig();
            String bizDataParamStr = SerializationUtils.toJsonString((Object)bizDataParam);
            String sourceConfigStr = SerializationUtils.toJsonString((Object)sourceConfig);
            BizDataParam tmpBizDataParam = (BizDataParam)SerializationUtils.fromJsonString((String)bizDataParamStr, BizDataParam.class);
            tmpBizDataParam.setSourceConfig((BizDataSourceConfig)SerializationUtils.fromJsonString((String)sourceConfigStr, BizDataSourceConfig.class));
            result.add(tmpBizDataParam);
        }
        return result;
    }

    private static void updateCacheVersion(String dLockKey, String cacheKey, Map<String, Long> localVersionCache) {
        try (DLock dLock = DLock.create((String)dLockKey).fastMode();){
            long cacheVersion;
            String appCacheVersion;
            boolean getLock = dLock.tryLock(10000L);
            if (!getLock) {
                logger.error("\u672c\u6b21\u66f4\u65b0\u53d6\u6570\u89c4\u5219\u7f13\u5b58\u83b7\u53d6\u9501\u5931\u8d25,\u672c\u5730\u7f13\u5b58key={} !", (Object)cacheKey);
            }
            boolean appVersionEmpty = (appCacheVersion = (String)APP_MODEL_CACHE.get(cacheKey)) == null;
            long l = cacheVersion = appVersionEmpty ? DBServiceHelper.genGlobalLongId() : Long.parseLong(appCacheVersion);
            if (appVersionEmpty) {
                APP_MODEL_CACHE.put(cacheKey, (Object)String.valueOf(cacheVersion));
            }
            localVersionCache.put(cacheKey, cacheVersion);
        }
        catch (Exception interruptedException) {
            logger.error("Update app cache version failed !", (Throwable)interruptedException);
        }
    }
}

