/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.common.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.fi.frm.common.model.FrmLogger;
import kd.fi.frm.common.util.FrmStringUtil;

public class FrmAnalyzeLogger
extends FrmLogger {
    private static final String SUB_LOG_CONST = "$SubLog";
    private static final String LF = "\n";
    private Map<String, List<String>> logMap = new HashMap<String, List<String>>();
    private Map<String, Long> timeMap = new HashMap<String, Long>();
    private Map<String, Integer> subThreadCache = new HashMap<String, Integer>();
    private Set<String> subLogNameSet = new HashSet<String>();
    private Map<String, Stack<String>> curLogNameMap = new HashMap<String, Stack<String>>();
    private Map<String, Map<String, Integer>> logNameVersionMap = new HashMap<String, Map<String, Integer>>();
    private boolean printDataSet;

    private String getCurLogName() {
        String curThreadVersionedName = this.getThreadVersionedName(Thread.currentThread().getId() + "");
        return this.getLogName(curThreadVersionedName);
    }

    private String getLogName(String threadVersionedName) {
        Stack<String> logNameStack = this.curLogNameMap.get(threadVersionedName);
        if (logNameStack == null) {
            logNameStack = new Stack();
            logNameStack.push(threadVersionedName);
        }
        return logNameStack.peek();
    }

    @Override
    public void log(String msg) {
        this.getLogLst(this.getCurLogName()).add(this.getFullMsg(msg));
    }

    @Override
    public void begin(String event) {
        Integer version;
        Map<String, Integer> _map;
        String curThreadVersionedName = this.getThreadVersionedName(Thread.currentThread().getId() + "");
        Stack<String> logNameStack = this.curLogNameMap.get(curThreadVersionedName);
        if (logNameStack == null) {
            logNameStack = new Stack();
            logNameStack.push(curThreadVersionedName);
            this.curLogNameMap.put(curThreadVersionedName, logNameStack);
        }
        if ((_map = this.logNameVersionMap.get(curThreadVersionedName)) == null) {
            _map = new HashMap<String, Integer>();
            this.logNameVersionMap.put(curThreadVersionedName, _map);
        }
        if ((version = _map.get(event)) == null) {
            version = 0;
        } else {
            Integer n = version;
            Integer n2 = version = Integer.valueOf(version + 1);
        }
        _map.put(event, version);
        String versionedEvent = String.format("%s{%s%s}%s", SUB_LOG_CONST, curThreadVersionedName, version, this.getFullMsg(event));
        this.timeMap.put(versionedEvent, System.currentTimeMillis());
        this.getLogLst(this.getCurLogName()).add(versionedEvent);
        this.subLogNameSet.add(versionedEvent);
        logNameStack.push(versionedEvent);
    }

    @Override
    public void end(String event0) {
        String curThreadVersionedName = this.getThreadVersionedName(Thread.currentThread().getId() + "");
        Stack<String> logNameStack = this.curLogNameMap.get(curThreadVersionedName);
        String versionedEvent = logNameStack.pop();
        long currentTimeMillis = System.currentTimeMillis();
        Long beginTimeMillis = this.timeMap.get(versionedEvent);
        String msg = event0 + ": ";
        if (beginTimeMillis != null) {
            long delta = currentTimeMillis - beginTimeMillis;
            this.timeMap.remove(versionedEvent);
            msg = msg + "cost " + delta + " ms";
        } else {
            msg = msg + "no beginTimeMIllis recorded.";
        }
        this.log(msg);
    }

    private String getFullMsg(String msg) {
        String invoker = "";
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        for (int i = 1; i < stackTrace.length; ++i) {
            StackTraceElement stackTraceElement = stackTrace[i];
            String str = stackTraceElement.toString();
            if (str.contains(".FrmAnalyzeLogger.") || str.contains(".FrmQueryServiceHelper.") || str.contains(".ReconciliationParamModel.")) continue;
            invoker = str;
            break;
        }
        return String.format("[%s] %s", invoker, msg);
    }

    private List<String> getLogLst(String logName) {
        List<String> logLst = this.logMap.get(logName);
        if (logLst == null) {
            logLst = new ArrayList<String>();
            this.logMap.put(logName, logLst);
        }
        return logLst;
    }

    private String getThreadVersionedName(String threadName) {
        Integer version = this.subThreadCache.get(threadName);
        return "Thread: " + threadName + version;
    }

    @Override
    public void setParentThread(String parentThreadName) {
        String curThreadName = Thread.currentThread().getId() + "";
        Integer version = this.subThreadCache.get(curThreadName);
        if (version == null) {
            version = 0;
        } else {
            Integer n = version;
            Integer n2 = version = Integer.valueOf(version + 1);
        }
        this.subThreadCache.put(curThreadName, version);
        curThreadName = this.getThreadVersionedName(Thread.currentThread().getId() + "");
        parentThreadName = this.getThreadVersionedName(parentThreadName);
        String subLogName = curThreadName;
        this.getLogLst(this.getLogName(parentThreadName)).add(subLogName);
        this.subLogNameSet.add(subLogName);
    }

    @Override
    public String getLogs() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, List<String>> entry : this.logMap.entrySet()) {
            if (this.subLogNameSet.contains(entry.getKey())) continue;
            List<String> logLst = entry.getValue();
            sb.append(this.getLogs("", logLst));
        }
        return sb.toString();
    }

    private String getLogs(String prefix, List<String> logLst) {
        StringBuilder sb = new StringBuilder();
        for (String msg : logLst) {
            List<String> subLogLst;
            if (msg.startsWith(SUB_LOG_CONST)) {
                subLogLst = this.logMap.get(msg);
                if (subLogLst == null) continue;
                String _subLogName = msg.substring(msg.indexOf("}") + 1);
                sb.append(prefix).append(_subLogName).append(LF);
                msg = this.getLogs(prefix + "\t", subLogLst);
                sb.append(msg);
                continue;
            }
            if (msg.startsWith("Thread: ")) {
                subLogLst = this.logMap.get(msg);
                if (subLogLst == null) continue;
                sb.append(prefix).append(msg).append(LF);
                msg = this.getLogs(prefix + "\t", subLogLst);
                sb.append(msg);
                continue;
            }
            sb.append(prefix).append(msg).append(LF);
        }
        return sb.toString();
    }

    @Override
    public void logDataSet(String desc, DataSet originalDs) {
        this.log(desc);
        if (!this.printDataSet) {
            return;
        }
        if (originalDs == null) {
            return;
        }
        try (DataSet ds = originalDs.copy();){
            Object[] fields2 = ds.getRowMeta().getFields();
            this.log(FrmStringUtil.join(fields2, "\t"));
            for (Row row : ds) {
                this.log(Stream.of(fields2).map(v -> {
                    Object obj = row.get(v.getName());
                    return obj == null ? "null" : obj.toString();
                }).collect(Collectors.joining("\t")));
            }
        }
    }

    @Override
    public void logWithSerialize(String key, Object value) {
        Map _map;
        if (value instanceof Map && !(_map = (Map)value).isEmpty()) {
            ArrayList _keys = new ArrayList(_map.keySet());
            boolean isComplicateObj = false;
            for (Object _key : _keys) {
                if (_key == null) continue;
                if (!(_key instanceof String || _key instanceof Integer || _key instanceof Boolean || _key instanceof Date || _key instanceof Double || _key instanceof BigDecimal || _key instanceof Long)) {
                    isComplicateObj = true;
                    break;
                }
                try {
                    SerializationUtils.toJsonString(_key);
                }
                catch (Exception e) {
                    isComplicateObj = false;
                }
                break;
            }
            if (isComplicateObj) {
                Set entrySet = _map.entrySet();
                ArrayList<String> _keyInfos = new ArrayList<String>(entrySet.size());
                HashMap<String, String> _valueInfos = new HashMap<String, String>(entrySet.size());
                int index = 0;
                for (Map.Entry entry : entrySet) {
                    _keyInfos.add(index + ": " + SerializationUtils.toJsonString(entry.getKey()));
                    _valueInfos.put(index + "", SerializationUtils.toJsonString(entry.getValue()));
                }
                this.logWithSerialize(key + ".keys", _keyInfos);
                this.logWithSerialize(key + ".values", _valueInfos);
                return;
            }
        }
        this.log(key + ": " + SerializationUtils.toJsonString((Object)value));
    }

    public void setPrintDataSet(boolean printDataSet) {
        this.printDataSet = printDataSet;
    }
}

