/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.common.model.bizdata;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.frm.common.enums.DetailTypeEnum;
import kd.fi.frm.common.enums.ReconAmountTypeEnum;

public enum BizDataTypeEnum {
    Init(0),
    PeriodStart(1),
    Debit(2),
    Credit(3),
    Close(4);

    private int value;

    private BizDataTypeEnum(int value) {
        this.value = value;
    }

    public static BizDataTypeEnum getEnum(Integer value) {
        for (BizDataTypeEnum s : BizDataTypeEnum.values()) {
            if (s.getValue() != value.intValue()) continue;
            return s;
        }
        return null;
    }

    public static BizDataTypeEnum getEnum(String key) {
        for (BizDataTypeEnum s : BizDataTypeEnum.values()) {
            if (!s.toString().equals(key)) continue;
            return s;
        }
        return null;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        switch (this.value) {
            case 0: {
                return ResManager.loadKDString((String)"\u521d\u59cb\u5316", (String)"BizDataTypeEnum_0", (String)"fi-frm-common", (Object[])new Object[0]);
            }
            case 1: {
                return ResManager.loadKDString((String)"\u671f\u521d\u4f59\u989d", (String)"BizDataTypeEnum_1", (String)"fi-frm-common", (Object[])new Object[0]);
            }
            case 2: {
                return ResManager.loadKDString((String)"\u501f\u65b9\u91d1\u989d", (String)"BizDataTypeEnum_2", (String)"fi-frm-common", (Object[])new Object[0]);
            }
            case 3: {
                return ResManager.loadKDString((String)"\u8d37\u65b9\u91d1\u989d", (String)"BizDataTypeEnum_3", (String)"fi-frm-common", (Object[])new Object[0]);
            }
            case 4: {
                return ResManager.loadKDString((String)"\u671f\u672b\u4f59\u989d", (String)"BizDataTypeEnum_4", (String)"fi-frm-common", (Object[])new Object[0]);
            }
        }
        return "";
    }

    public static Set<Integer> getInitTypes() {
        HashSet<Integer> types = new HashSet<Integer>(1);
        types.add(BizDataTypeEnum.Init.value);
        return types;
    }

    public static Set<Integer> getClosePeriodTypes() {
        HashSet<Integer> types = new HashSet<Integer>(4);
        types.add(BizDataTypeEnum.PeriodStart.value);
        types.add(BizDataTypeEnum.Debit.value);
        types.add(BizDataTypeEnum.Credit.value);
        types.add(BizDataTypeEnum.Close.value);
        return types;
    }

    public static Set<Integer> getClosePeriodTypesByReconAmountType(ReconAmountTypeEnum reconAmountType) {
        HashSet<Integer> types = new HashSet<Integer>(4);
        switch (reconAmountType) {
            case DEBIT: {
                types.add(BizDataTypeEnum.Debit.value);
                break;
            }
            case CREDIT: {
                types.add(BizDataTypeEnum.Credit.value);
                break;
            }
            case DEBIT_CREDIT: {
                types.add(BizDataTypeEnum.Debit.value);
                types.add(BizDataTypeEnum.Credit.value);
                break;
            }
            case DEBIT_CREDIT_CLOSE: {
                types.add(BizDataTypeEnum.PeriodStart.value);
                types.add(BizDataTypeEnum.Debit.value);
                types.add(BizDataTypeEnum.Credit.value);
                types.add(BizDataTypeEnum.Close.value);
                break;
            }
        }
        return types;
    }

    public static Set<Integer> getDetailTypes() {
        HashSet<Integer> types = new HashSet<Integer>(4);
        types.add(BizDataTypeEnum.Debit.value);
        types.add(BizDataTypeEnum.Credit.value);
        return types;
    }

    public static Set<Integer> getDetailTypesByReconAmountType(ReconAmountTypeEnum reconAmountType) {
        HashSet<Integer> types = new HashSet<Integer>(4);
        switch (reconAmountType) {
            case DEBIT: {
                types.add(BizDataTypeEnum.Debit.value);
                break;
            }
            case CREDIT: {
                types.add(Credit.getValue());
                break;
            }
            case DEBIT_CREDIT: 
            case DEBIT_CREDIT_CLOSE: {
                types.add(BizDataTypeEnum.Debit.value);
                types.add(BizDataTypeEnum.Credit.value);
                break;
            }
        }
        return types;
    }

    public static Set<Integer> filterDataTypeByClickItem(DetailTypeEnum detailTypeEnum, Set<Integer> dataTypes) {
        switch (detailTypeEnum) {
            case DEBIT_DIFF: {
                dataTypes.remove(BizDataTypeEnum.Credit.value);
                break;
            }
            case CREDIT_DIFF: {
                dataTypes.remove(BizDataTypeEnum.Debit.value);
                break;
            }
        }
        return dataTypes;
    }
}

