/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.common.relation;

import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.util.bitset.LongBitSet;
import kd.bos.entity.param.AppParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.frm.common.model.FrmLogger;
import kd.fi.frm.common.relation.AbstractRelationService;
import kd.fi.frm.common.relation.RelationParam;
import kd.fi.frm.common.relation.RelationTypeEnum;
import kd.fi.frm.common.util.FrmQueryServiceHelper;

public class CASService
extends AbstractRelationService {
    public CASService(FrmLogger frmLogger, RelationParam relationParam) {
        RelationTypeEnum relationType = this.getRelationType(relationParam.getBizOrgIds());
        relationParam.setRelationType(relationType);
        this.relationParam = relationParam;
        this.frmLogger = frmLogger;
    }

    @Override
    public DataSet getRelation(RelationParam param, LongBitSet billBitSet, Set<Long> vchIdSet) {
        Set<Long> orgIds = param.getBizOrgIds();
        Long periodId = param.getPeriodId();
        String entity = param.getSourceEntity();
        QFilter filter = new QFilter("org", "in", orgIds).and(new QFilter("period", "=", (Object)periodId));
        DataSet vchDs = FrmQueryServiceHelper.queryDataSet(this.frmLogger, this.getClass().getName(), entity, "id, sourcebilltype entity , sourcebillid, '" + entity + "' curr", filter.toArray(), null);
        DataSet vchDataSet = vchDs.filter("entity = 'gl_voucher'").select(new String[]{"id", "curr entity", "id sourcebillid", "sourcebillid voucherid"});
        if (RelationTypeEnum.VCH == param.getRelationType() || RelationTypeEnum.HAND == param.getRelationType()) {
            return vchDataSet;
        }
        QFilter copy = filter.copy();
        if (CollectionUtils.isNotEmpty(vchIdSet)) {
            QFilter idFilter = new QFilter("voucherid", "in", vchIdSet);
            copy.and(idFilter);
        }
        DataSet dapRelDs = FrmQueryServiceHelper.queryDataSet(this.frmLogger, this.getClass().getName(), "ai_daptracker", "billtype.number entity1,sourcebillid sourcebillid1, voucherid voucherid1,'" + entity + "' curr", copy.toArray(), null);
        DataSet billlDs = FrmQueryServiceHelper.queryDataSet(this.frmLogger, this.getClass().getName(), entity, "id, (case when sourcebilltype = 'cas_paybill_cash' or sourcebilltype = 'cas_paybill_synonym' then 'cas_paybill' else sourcebilltype end) entity , sourcebillid, '" + entity + "' curr", filter.toArray(), null);
        JoinDataSet dapDataSet = billlDs.filter("entity != 'gl_voucher'").join(dapRelDs, JoinType.INNER).on("sourcebillid", "sourcebillid1").on("entity", "entity1").select(new String[]{"id", "curr entity", "id sourcebillid", "voucherid1 voucherid"});
        if (RelationTypeEnum.DAP == param.getRelationType()) {
            return dapDataSet.finish();
        }
        return vchDataSet.union(dapDataSet.finish());
    }

    @Override
    public final RelationTypeEnum getRelationType(Set<Long> orgIds) {
        RelationTypeEnum relationType = null;
        for (Long bizOrg : orgIds) {
            String type;
            AppParam param = new AppParam("d2bb1733000000ac", "08", bizOrg, Long.valueOf(0L));
            Object cs105 = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param, (String)"cs105");
            switch (type = cs105 == null ? "1" : cs105.toString()) {
                case "0": {
                    relationType = RelationTypeEnum.DAP;
                    break;
                }
                case "1": {
                    relationType = RelationTypeEnum.VCH;
                    break;
                }
                case "2": {
                    relationType = RelationTypeEnum.HAND;
                    break;
                }
                case "3": {
                    relationType = RelationTypeEnum.MIX;
                    break;
                }
            }
            if (relationType == null) continue;
            break;
        }
        if (relationType == null) {
            relationType = RelationTypeEnum.VCH;
        }
        return relationType;
    }
}

